/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.binary.types;

import java.sql.Timestamp;
import java.util.Date;
import java.util.function.Function;
import org.apache.tinkerpop.gremlin.structure.io.Buffer;
import org.apache.tinkerpop.gremlin.structure.io.binary.DataType;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.SimpleTypeSerializer;

public class DateSerializer<T extends Date>
extends SimpleTypeSerializer<T> {
    public static final DateSerializer<Date> DateSerializer = new DateSerializer<Date>(DataType.DATE, Date::new);
    public static final DateSerializer<Timestamp> TimestampSerializer = new DateSerializer<Timestamp>(DataType.TIMESTAMP, Timestamp::new);
    private final Function<Long, T> reader;

    private DateSerializer(DataType type, Function<Long, T> reader) {
        super(type);
        this.reader = reader;
    }

    @Override
    protected T readValue(Buffer buffer, GraphBinaryReader context) {
        return (T)((Date)this.reader.apply(buffer.readLong()));
    }

    @Override
    protected void writeValue(T value, Buffer buffer, GraphBinaryWriter context) {
        buffer.writeLong(((Date)value).getTime());
    }
}

