/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.doccat;

import opennlp.tools.doccat.DoccatEvaluationMonitor;
import opennlp.tools.doccat.DocumentCategorizer;
import opennlp.tools.doccat.DocumentSample;
import opennlp.tools.util.eval.Evaluator;
import opennlp.tools.util.eval.Mean;

public class DocumentCategorizerEvaluator
extends Evaluator<DocumentSample> {
    private final DocumentCategorizer categorizer;
    private final Mean accuracy = new Mean();

    public DocumentCategorizerEvaluator(DocumentCategorizer categorizer, DoccatEvaluationMonitor ... listeners) {
        super(listeners);
        this.categorizer = categorizer;
    }

    @Override
    public DocumentSample processSample(DocumentSample sample) {
        String[] document = sample.getText();
        double[] probs = this.categorizer.categorize(document);
        String cat = this.categorizer.getBestCategory(probs);
        if (sample.getCategory().equals(cat)) {
            this.accuracy.add(1.0);
        } else {
            this.accuracy.add(0.0);
        }
        return new DocumentSample(cat, sample.getText());
    }

    public double getAccuracy() {
        return this.accuracy.mean();
    }

    public long getDocumentCount() {
        return this.accuracy.count();
    }

    public String toString() {
        return "Accuracy: " + this.accuracy.mean() + "\nNumber of documents: " + this.accuracy.count();
    }
}

