/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.netpreserve.jwarc.FetchOptions;
import org.netpreserve.jwarc.FetchResult;
import org.netpreserve.jwarc.GzipChannel;
import org.netpreserve.jwarc.HttpRequest;
import org.netpreserve.jwarc.HttpResponse;
import org.netpreserve.jwarc.IOUtils;
import org.netpreserve.jwarc.MediaType;
import org.netpreserve.jwarc.MessageBody;
import org.netpreserve.jwarc.MessageVersion;
import org.netpreserve.jwarc.WarcCompression;
import org.netpreserve.jwarc.WarcDigest;
import org.netpreserve.jwarc.WarcRecord;
import org.netpreserve.jwarc.WarcRequest;
import org.netpreserve.jwarc.WarcResponse;
import org.netpreserve.jwarc.WarcTruncationReason;

public class WarcWriter
implements Closeable {
    private static final byte[] TRAILER = new byte[]{13, 10, 13, 10};
    private final WritableByteChannel channel;
    private final WarcCompression compression;
    private final ByteBuffer buffer = ByteBuffer.allocate(8192);
    private final String digestAlgorithm = "SHA-1";
    private final AtomicLong position = new AtomicLong(0L);
    private final Set<Socket> fetchSockets = Collections.synchronizedSet(new HashSet());
    private final ReadWriteLock closeLock = new ReentrantReadWriteLock();
    private volatile boolean closing = false;

    public WarcWriter(WritableByteChannel channel, WarcCompression compression) throws IOException {
        this.compression = compression;
        this.channel = compression == WarcCompression.GZIP ? new GzipChannel(channel) : channel;
        if (channel instanceof SeekableByteChannel) {
            this.position.set(((SeekableByteChannel)channel).position());
        }
    }

    public WarcWriter(WritableByteChannel channel) throws IOException {
        this(channel, WarcCompression.NONE);
    }

    public WarcWriter(OutputStream stream) throws IOException {
        this(Channels.newChannel(stream));
    }

    public WarcWriter(Path path) throws IOException {
        this(FileChannel.open(path, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING), WarcCompression.forPath(path));
    }

    public synchronized void write(WarcRecord record) throws IOException {
        this.position.addAndGet(this.channel.write(ByteBuffer.wrap(record.serializeHeader())));
        MessageBody body = record.body();
        while (body.read(this.buffer) >= 0) {
            this.buffer.flip();
            this.position.addAndGet(this.channel.write(this.buffer));
            this.buffer.compact();
        }
        this.position.addAndGet(this.channel.write(ByteBuffer.wrap(TRAILER)));
        if (this.compression == WarcCompression.GZIP) {
            ((GzipChannel)this.channel).finish();
            this.position.set(((GzipChannel)this.channel).outputPosition());
        }
    }

    public FetchResult fetch(URI uri) throws IOException {
        return this.fetch(uri, new FetchOptions());
    }

    public FetchResult fetch(URI uri, FetchOptions options) throws IOException {
        HttpRequest httpRequest = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)new HttpRequest.Builder("GET", uri).version(MessageVersion.HTTP_1_0)).addHeader("User-Agent", options.userAgent)).addHeader("Connection", "close")).build();
        return this.fetch(uri, httpRequest, options);
    }

    public FetchResult fetch(URI uri, HttpRequest httpRequest, OutputStream copyTo) throws IOException {
        return this.fetch(uri, httpRequest, new FetchOptions().copyTo(copyTo));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FetchResult fetch(URI uri, HttpRequest httpRequest, FetchOptions options) throws IOException {
        SocketException exception = null;
        Path tempPath = Files.createTempFile("jwarc", ".tmp", new FileAttribute[0]);
        this.closeLock.readLock().lock();
        try {
            FetchResult fetchResult;
            block33: {
                FileChannel tempFile = FileChannel.open(tempPath, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.DELETE_ON_CLOSE, StandardOpenOption.TRUNCATE_EXISTING);
                try {
                    WarcTruncationReason truncationReason;
                    Instant date;
                    InetAddress ip;
                    MessageDigest responseBlockDigest;
                    MessageDigest requestBlockDigest;
                    block32: {
                        byte[] httpRequestBytes = httpRequest.serializeHeader();
                        requestBlockDigest = MessageDigest.getInstance("SHA-1");
                        requestBlockDigest.update(httpRequestBytes);
                        responseBlockDigest = MessageDigest.getInstance("SHA-1");
                        ip = null;
                        date = Instant.now();
                        long startMillis = date.toEpochMilli();
                        truncationReason = null;
                        long totalLength = 0L;
                        try (Socket socket = IOUtils.connect(uri.getScheme(), uri.getHost(), uri.getPort());){
                            this.fetchSockets.add(socket);
                            try {
                                if (this.closing) {
                                    throw new IOException("WarcWriter closed");
                                }
                                socket.setTcpNoDelay(true);
                                socket.setSoTimeout(options.readTimeout);
                                ip = ((InetSocketAddress)socket.getRemoteSocketAddress()).getAddress();
                                socket.getOutputStream().write(httpRequestBytes);
                                InputStream inputStream = socket.getInputStream();
                                byte[] buf = new byte[8192];
                                do {
                                    int len;
                                    int n;
                                    if ((n = inputStream.read(buf, 0, len = options.maxLength > 0L && options.maxLength - totalLength < (long)buf.length ? (int)(options.maxLength - totalLength) : buf.length)) < 0) {
                                        break block32;
                                    }
                                    totalLength += (long)n;
                                    tempFile.write(ByteBuffer.wrap(buf, 0, n));
                                    responseBlockDigest.update(buf, 0, n);
                                    try {
                                        if (options.copyTo != null) {
                                            options.copyTo.write(buf, 0, n);
                                        }
                                    }
                                    catch (IOException iOException) {
                                        // empty catch block
                                    }
                                    if (options.maxTime <= 0L || System.currentTimeMillis() - startMillis <= options.maxTime) continue;
                                    truncationReason = WarcTruncationReason.TIME;
                                    break block32;
                                } while (options.maxLength <= 0L || totalLength < options.maxLength);
                                truncationReason = WarcTruncationReason.LENGTH;
                            }
                            catch (SocketException e) {
                                if (!this.closing || totalLength == 0L) {
                                    throw e;
                                }
                                truncationReason = WarcTruncationReason.UNSPECIFIED;
                                exception = e;
                            }
                            finally {
                                this.fetchSockets.remove(socket);
                            }
                        }
                    }
                    tempFile.position(0L);
                    MessageDigest responsePayloadDigest = this.tryCalculatingPayloadDigest(tempFile);
                    tempFile.position(0L);
                    WarcResponse.Builder responseBuilder = (WarcResponse.Builder)((WarcResponse.Builder)((WarcResponse.Builder)new WarcResponse.Builder(uri).blockDigest(new WarcDigest(responseBlockDigest))).date(date)).body(MediaType.HTTP_RESPONSE, tempFile, tempFile.size());
                    if (ip != null) {
                        responseBuilder.ipAddress(ip);
                    }
                    if (responsePayloadDigest != null) {
                        responseBuilder.payloadDigest(new WarcDigest(responsePayloadDigest));
                    }
                    if (truncationReason != null) {
                        responseBuilder.truncated(truncationReason);
                    }
                    WarcResponse response = responseBuilder.build();
                    response.http();
                    this.write(response);
                    WarcRequest request = ((WarcRequest.Builder)((WarcRequest.Builder)((WarcRequest.Builder)new WarcRequest.Builder(uri).blockDigest(new WarcDigest(requestBlockDigest))).date(date)).body(httpRequest).concurrentTo(response.id())).build();
                    request.http();
                    this.write(request);
                    fetchResult = new FetchResult(request, response, exception);
                    if (tempFile == null) break block33;
                }
                catch (Throwable throwable) {
                    try {
                        if (tempFile != null) {
                            try {
                                tempFile.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (NoSuchAlgorithmException e) {
                        throw new IOException(e);
                    }
                }
                tempFile.close();
            }
            return fetchResult;
        }
        finally {
            this.closeLock.readLock().unlock();
        }
    }

    private MessageDigest tryCalculatingPayloadDigest(FileChannel channel) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("SHA-1");
        try {
            int n;
            HttpResponse httpResponse = HttpResponse.parse(channel);
            byte[] buffer = new byte[8192];
            InputStream steam = httpResponse.body().stream();
            long payloadLength = 0L;
            while ((n = steam.read(buffer)) >= 0) {
                digest.update(buffer, 0, n);
                payloadLength += (long)n;
            }
            if (payloadLength == 0L) {
                return null;
            }
        }
        catch (Exception e) {
            return null;
        }
        return digest;
    }

    public long position() {
        return this.position.get();
    }

    @Override
    public void close() throws IOException {
        this.closing = true;
        for (Socket socket : this.fetchSockets) {
            socket.close();
        }
        this.closeLock.writeLock().lock();
        try {
            this.channel.close();
        }
        finally {
            this.closeLock.writeLock().unlock();
        }
    }
}

