/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft;

import java.awt.Point;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.ddf.EscherBSERecord;
import org.apache.poi.ddf.EscherBlipRecord;
import org.apache.poi.ddf.EscherRecord;
import org.apache.poi.hssf.eventusermodel.FormatTrackingHSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFEventFactory;
import org.apache.poi.hssf.eventusermodel.HSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFRequest;
import org.apache.poi.hssf.extractor.OldExcelExtractor;
import org.apache.poi.hssf.model.InternalWorkbook;
import org.apache.poi.hssf.record.BOFRecord;
import org.apache.poi.hssf.record.BoundSheetRecord;
import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.hssf.record.ColumnInfoRecord;
import org.apache.poi.hssf.record.DrawingGroupRecord;
import org.apache.poi.hssf.record.FooterRecord;
import org.apache.poi.hssf.record.FormulaRecord;
import org.apache.poi.hssf.record.HeaderRecord;
import org.apache.poi.hssf.record.HyperlinkRecord;
import org.apache.poi.hssf.record.LabelRecord;
import org.apache.poi.hssf.record.LabelSSTRecord;
import org.apache.poi.hssf.record.NoteRecord;
import org.apache.poi.hssf.record.NumberRecord;
import org.apache.poi.hssf.record.ProtectRecord;
import org.apache.poi.hssf.record.RKRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RowRecord;
import org.apache.poi.hssf.record.SSTRecord;
import org.apache.poi.hssf.record.StringRecord;
import org.apache.poi.hssf.record.TextObjectRecord;
import org.apache.poi.hssf.record.chart.SeriesTextRecord;
import org.apache.poi.hssf.record.common.UnicodeString;
import org.apache.poi.hssf.record.crypto.Biff8EncryptionKey;
import org.apache.poi.hssf.usermodel.HSSFPictureData;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Office;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.microsoft.AbstractPOIFSExtractor;
import org.apache.tika.parser.microsoft.Cell;
import org.apache.tika.parser.microsoft.LinkedCell;
import org.apache.tika.parser.microsoft.NumberCell;
import org.apache.tika.parser.microsoft.OfficeParserConfig;
import org.apache.tika.parser.microsoft.OldExcelParser;
import org.apache.tika.parser.microsoft.TextCell;
import org.apache.tika.parser.microsoft.TikaExcelDataFormatter;
import org.apache.tika.sax.XHTMLContentHandler;
import org.apache.tika.utils.StringUtils;
import org.xml.sax.SAXException;

public class ExcelExtractor
extends AbstractPOIFSExtractor {
    private static final String BOOK_ENTRY = "Book";
    private boolean listenForAllRecords = false;

    public ExcelExtractor(ParseContext context, Metadata metadata) {
        super(context, metadata);
    }

    private static String findWorkbookEntry(DirectoryNode root) {
        for (String workbookDirEntryName : InternalWorkbook.WORKBOOK_DIR_ENTRY_NAMES) {
            if (!root.hasEntry(workbookDirEntryName)) continue;
            return workbookDirEntryName;
        }
        return null;
    }

    public boolean isListenForAllRecords() {
        return this.listenForAllRecords;
    }

    public void setListenForAllRecords(boolean listenForAllRecords) {
        this.listenForAllRecords = listenForAllRecords;
    }

    protected void parse(POIFSFileSystem filesystem, XHTMLContentHandler xhtml, Locale locale) throws IOException, SAXException, TikaException {
        this.parse(filesystem.getRoot(), xhtml, locale);
    }

    protected void parse(DirectoryNode root, XHTMLContentHandler xhtml, Locale locale) throws IOException, SAXException, TikaException {
        String workbookEntryName = ExcelExtractor.findWorkbookEntry(root);
        if (workbookEntryName == null) {
            if (root.hasEntry(BOOK_ENTRY)) {
                OldExcelExtractor extractor = new OldExcelExtractor(root);
                OldExcelParser.parse(extractor, xhtml);
                return;
            }
            throw new TikaException("Couldn't find workbook entry");
        }
        Biff8EncryptionKey.setCurrentUserPassword(this.getPassword());
        TikaHSSFListener listener = new TikaHSSFListener(workbookEntryName, xhtml, locale, this, this.officeParserConfig);
        listener.processFile(root, this.isListenForAllRecords());
        listener.throwStoredException();
        this.updateMetadata(listener);
        for (Entry entry : root) {
            if (!entry.getName().startsWith("MBD") || !(entry instanceof DirectoryEntry)) continue;
            try {
                this.handleEmbeddedOfficeDoc((DirectoryEntry)entry, xhtml, true);
            }
            catch (TikaException tikaException) {}
        }
    }

    private void updateMetadata(TikaHSSFListener listener) {
        if (listener.hasProtectedSheet) {
            this.parentMetadata.set(Office.PROTECTED_WORKSHEET, true);
        }
        if (listener.hasHiddenColumn) {
            this.parentMetadata.set(Office.HAS_HIDDEN_COLUMNS, true);
        }
        if (listener.hasHiddenRow) {
            this.parentMetadata.set(Office.HAS_HIDDEN_ROWS, true);
        }
        if (!listener.commentAuthors.isEmpty()) {
            for (String author : listener.commentAuthors) {
                this.parentMetadata.add(Office.COMMENT_PERSONS, author);
            }
            this.parentMetadata.set(Office.HAS_COMMENTS, true);
        }
        if (!listener.hiddenSheets.isEmpty()) {
            for (String sheetName : listener.hiddenSheets) {
                this.parentMetadata.add(Office.HIDDEN_SHEET_NAMES, sheetName);
            }
            this.parentMetadata.set(Office.HAS_HIDDEN_SHEETS, true);
        }
        if (!listener.veryHiddenSheets.isEmpty()) {
            for (String sheetName : listener.veryHiddenSheets) {
                this.parentMetadata.add(Office.VERY_HIDDEN_SHEET_NAMES, sheetName);
            }
            this.parentMetadata.set(Office.HAS_VERY_HIDDEN_SHEETS, true);
        }
    }

    private static class PointComparator
    implements Comparator<Point> {
        private PointComparator() {
        }

        @Override
        public int compare(Point a, Point b) {
            int diff = a.y - b.y;
            if (diff == 0) {
                diff = a.x - b.x;
            }
            return diff;
        }
    }

    private static class TikaHSSFListener
    implements HSSFListener {
        private final XHTMLContentHandler handler;
        private final AbstractPOIFSExtractor extractor;
        private final NumberFormat format;
        private final OfficeParserConfig officeParserConfig;
        private final TikaExcelDataFormatter tikaExcelDataFormatter;
        private final String workbookEntryName;
        private Exception exception = null;
        private SSTRecord sstRecord;
        private FormulaRecord stringFormulaRecord;
        private short previousSid;
        private FormatTrackingHSSFListener formatListener;
        private List<String> sheetNames = new ArrayList<String>();
        private short currentSheetIndex;
        private SortedMap<Point, Cell> currentSheet = null;
        private List<Cell> extraTextCells = new ArrayList<Cell>();
        private final List<DrawingGroupRecord> drawingGroups = new ArrayList<DrawingGroupRecord>();
        private final List<String> hiddenSheets = new ArrayList<String>();
        private final List<String> veryHiddenSheets = new ArrayList<String>();
        private final Set<String> commentAuthors = new TreeSet<String>();
        private boolean hasHiddenColumn = false;
        private boolean hasHiddenRow = false;
        private boolean hasProtectedSheet = false;

        private TikaHSSFListener(String workbookEntryName, XHTMLContentHandler handler, Locale locale, AbstractPOIFSExtractor extractor, OfficeParserConfig officeParserConfig) {
            this.workbookEntryName = workbookEntryName;
            this.handler = handler;
            this.extractor = extractor;
            this.format = NumberFormat.getInstance(locale);
            this.formatListener = new TikaFormatTrackingHSSFListener(this, locale);
            this.tikaExcelDataFormatter = new TikaExcelDataFormatter(locale);
            this.officeParserConfig = officeParserConfig;
            this.tikaExcelDataFormatter.setDateFormatOverride(officeParserConfig.getDateFormatOverride());
        }

        public void processFile(POIFSFileSystem filesystem, boolean listenForAllRecords) throws IOException, SAXException, TikaException {
            this.processFile(filesystem.getRoot(), listenForAllRecords);
        }

        public void processFile(DirectoryNode root, boolean listenForAllRecords) throws IOException, SAXException, TikaException {
            HSSFRequest hssfRequest = new HSSFRequest();
            if (listenForAllRecords) {
                hssfRequest.addListenerForAllRecords(this.formatListener);
            } else {
                hssfRequest.addListener(this.formatListener, (short)2057);
                hssfRequest.addListener(this.formatListener, (short)10);
                hssfRequest.addListener(this.formatListener, (short)34);
                hssfRequest.addListener(this.formatListener, (short)140);
                hssfRequest.addListener(this.formatListener, (short)133);
                hssfRequest.addListener(this.formatListener, (short)252);
                hssfRequest.addListener(this.formatListener, (short)6);
                hssfRequest.addListener(this.formatListener, (short)516);
                hssfRequest.addListener(this.formatListener, (short)253);
                hssfRequest.addListener(this.formatListener, (short)515);
                hssfRequest.addListener(this.formatListener, (short)638);
                hssfRequest.addListener(this.formatListener, (short)519);
                hssfRequest.addListener(this.formatListener, (short)440);
                hssfRequest.addListener(this.formatListener, (short)438);
                hssfRequest.addListener(this.formatListener, (short)4109);
                hssfRequest.addListener(this.formatListener, (short)1054);
                hssfRequest.addListener(this.formatListener, (short)224);
                hssfRequest.addListener(this.formatListener, (short)235);
                hssfRequest.addListener(this.formatListener, (short)18);
                hssfRequest.addListener(this.formatListener, (short)125);
                hssfRequest.addListener(this.formatListener, (short)520);
                hssfRequest.addListener(this.formatListener, (short)28);
                if (this.extractor.officeParserConfig.isIncludeHeadersAndFooters()) {
                    hssfRequest.addListener(this.formatListener, (short)20);
                    hssfRequest.addListener(this.formatListener, (short)21);
                }
            }
            DocumentInputStream documentInputStream = root.createDocumentInputStream(this.workbookEntryName);
            HSSFEventFactory eventFactory = new HSSFEventFactory();
            try {
                eventFactory.processEvents(hssfRequest, documentInputStream);
            }
            catch (EncryptedDocumentException e) {
                throw new org.apache.tika.exception.EncryptedDocumentException(e);
            }
            this.processExtraText();
            for (DrawingGroupRecord dgr : this.drawingGroups) {
                dgr.decode();
                this.findPictures(dgr.getEscherRecords());
            }
        }

        @Override
        public void processRecord(Record record) {
            if (this.exception == null) {
                try {
                    this.internalProcessRecord(record);
                }
                catch (IOException | TikaException | SAXException e) {
                    this.exception = e;
                }
            }
        }

        public void throwStoredException() throws TikaException, SAXException, IOException {
            if (this.exception != null) {
                if (this.exception instanceof IOException) {
                    throw (IOException)this.exception;
                }
                if (this.exception instanceof SAXException) {
                    throw (SAXException)this.exception;
                }
                if (this.exception instanceof TikaException) {
                    throw (TikaException)this.exception;
                }
                throw new TikaException(this.exception.getMessage());
            }
        }

        private void internalProcessRecord(Record record) throws SAXException, TikaException, IOException {
            switch (record.getSid()) {
                case 2057: {
                    BOFRecord bof = (BOFRecord)record;
                    if (bof.getType() == 5) {
                        this.currentSheetIndex = (short)-1;
                        break;
                    }
                    if (bof.getType() == 32) {
                        if (this.previousSid == 10) {
                            this.newSheet();
                            break;
                        }
                        if (this.currentSheet == null) break;
                        this.processSheet();
                        this.currentSheetIndex = (short)(this.currentSheetIndex - 1);
                        this.newSheet();
                        break;
                    }
                    if (bof.getType() != 16) break;
                    this.newSheet();
                    break;
                }
                case 10: {
                    if (this.currentSheet != null) {
                        this.processSheet();
                    }
                    this.currentSheet = null;
                    break;
                }
                case 133: {
                    BoundSheetRecord boundSheetRecord = (BoundSheetRecord)record;
                    if (boundSheetRecord.isHidden()) {
                        this.hiddenSheets.add(boundSheetRecord.getSheetname());
                    }
                    if (boundSheetRecord.isVeryHidden()) {
                        this.veryHiddenSheets.add(boundSheetRecord.getSheetname());
                    }
                    this.sheetNames.add(boundSheetRecord.getSheetname());
                    break;
                }
                case 252: {
                    this.sstRecord = (SSTRecord)record;
                    break;
                }
                case 6: {
                    FormulaRecord formula = (FormulaRecord)record;
                    if (formula.hasCachedResultString()) {
                        this.stringFormulaRecord = formula;
                        break;
                    }
                    this.addTextCell(record, this.formatListener.formatNumberDateCell(formula));
                    break;
                }
                case 519: {
                    if (this.previousSid != 6) break;
                    StringRecord sr = (StringRecord)record;
                    this.addTextCell(this.stringFormulaRecord, sr.getString());
                    break;
                }
                case 516: {
                    LabelRecord label = (LabelRecord)record;
                    this.addTextCell(record, label.getValue());
                    break;
                }
                case 253: {
                    LabelSSTRecord sst = (LabelSSTRecord)record;
                    UnicodeString unicode = this.sstRecord.getString(sst.getSSTIndex());
                    Object cellString = null;
                    if (this.officeParserConfig.isConcatenatePhoneticRuns()) {
                        String phonetic = unicode != null && unicode.getExtendedRst() != null && unicode.getExtendedRst().getPhoneticText() != null && !unicode.getExtendedRst().getPhoneticText().isBlank() ? unicode.getExtendedRst().getPhoneticText() : "";
                        cellString = unicode.getString() + " " + phonetic;
                    } else {
                        cellString = unicode.getString();
                    }
                    this.addTextCell(record, (String)cellString);
                    break;
                }
                case 515: {
                    NumberRecord number = (NumberRecord)record;
                    this.addTextCell(record, this.formatListener.formatNumberDateCell(number));
                    break;
                }
                case 638: {
                    RKRecord rk = (RKRecord)record;
                    this.addCell(record, new NumberCell(rk.getRKNumber(), this.format));
                    break;
                }
                case 440: {
                    HyperlinkRecord link;
                    Point point;
                    Cell cell;
                    if (this.currentSheet == null || (cell = (Cell)this.currentSheet.get(point = new Point((link = (HyperlinkRecord)record).getFirstColumn(), link.getFirstRow()))) == null) break;
                    String address = link.getAddress();
                    if (address != null) {
                        this.addCell(record, new LinkedCell(cell, address));
                        break;
                    }
                    this.addCell(record, cell);
                    break;
                }
                case 438: {
                    if (!this.extractor.officeParserConfig.isIncludeShapeBasedContent()) break;
                    TextObjectRecord tor = (TextObjectRecord)record;
                    this.addTextCell(record, tor.getStr().getString());
                    break;
                }
                case 4109: {
                    SeriesTextRecord str = (SeriesTextRecord)record;
                    this.addTextCell(record, str.getText());
                    break;
                }
                case 235: {
                    this.drawingGroups.add((DrawingGroupRecord)record);
                    break;
                }
                case 20: {
                    if (!this.extractor.officeParserConfig.isIncludeHeadersAndFooters()) break;
                    HeaderRecord headerRecord = (HeaderRecord)record;
                    this.addTextCell(record, headerRecord.getText());
                    break;
                }
                case 21: {
                    if (!this.extractor.officeParserConfig.isIncludeHeadersAndFooters()) break;
                    FooterRecord footerRecord = (FooterRecord)record;
                    this.addTextCell(record, footerRecord.getText());
                    break;
                }
                case 18: {
                    if (!((ProtectRecord)record).getProtect()) break;
                    this.hasProtectedSheet = true;
                    break;
                }
                case 125: {
                    if (!((ColumnInfoRecord)record).getHidden()) break;
                    this.hasHiddenColumn = true;
                    break;
                }
                case 28: {
                    String author = ((NoteRecord)record).getAuthor();
                    if (StringUtils.isBlank(author)) break;
                    this.commentAuthors.add(author);
                    break;
                }
                case 520: {
                    if (!((RowRecord)record).getZeroHeight()) break;
                    this.hasHiddenRow = true;
                }
            }
            this.previousSid = record.getSid();
            if (this.stringFormulaRecord != record) {
                this.stringFormulaRecord = null;
            }
        }

        private void processExtraText() throws SAXException {
            if (this.extraTextCells.size() > 0) {
                for (Cell cell : this.extraTextCells) {
                    this.handler.startElement("div", "class", "outside");
                    cell.render(this.handler);
                    this.handler.endElement("div");
                }
                this.extraTextCells.clear();
            }
        }

        private void addCell(Record record, Cell cell) throws SAXException {
            if (cell != null) {
                if (this.currentSheet != null && record instanceof CellValueRecordInterface) {
                    CellValueRecordInterface value = (CellValueRecordInterface)((Object)record);
                    Point point = new Point(value.getColumn(), value.getRow());
                    if (this.currentSheet.containsKey(point)) {
                        this.extraTextCells.add(cell);
                    } else {
                        this.currentSheet.put(point, cell);
                    }
                } else {
                    this.extraTextCells.add(cell);
                }
            }
        }

        private void addTextCell(Record record, String text) throws SAXException {
            if (text != null && (text = text.trim()).length() > 0) {
                this.addCell(record, new TextCell(text));
            }
        }

        private void newSheet() {
            this.currentSheetIndex = (short)(this.currentSheetIndex + 1);
            this.currentSheet = new TreeMap<Point, Cell>(new PointComparator());
        }

        private void processSheet() throws SAXException {
            this.handler.startElement("div", "class", "page");
            if (this.currentSheetIndex < this.sheetNames.size()) {
                this.handler.element("h1", this.sheetNames.get(this.currentSheetIndex));
            }
            this.handler.startElement("table");
            this.handler.startElement("tbody");
            int currentRow = 0;
            int currentColumn = 0;
            this.handler.startElement("tr");
            this.handler.startElement("td");
            for (Map.Entry<Point, Cell> entry : this.currentSheet.entrySet()) {
                if (currentRow != entry.getKey().y) {
                    do {
                        this.handler.endElement("td");
                        this.handler.endElement("tr");
                        this.handler.startElement("tr");
                        this.handler.startElement("td");
                    } while (this.officeParserConfig.isIncludeMissingRows() && ++currentRow < entry.getKey().y);
                    currentRow = entry.getKey().y;
                    currentColumn = 0;
                }
                while (currentColumn < entry.getKey().x) {
                    this.handler.endElement("td");
                    this.handler.startElement("td");
                    ++currentColumn;
                }
                entry.getValue().render(this.handler);
            }
            this.handler.endElement("td");
            this.handler.endElement("tr");
            this.handler.endElement("tbody");
            this.handler.endElement("table");
            this.processExtraText();
            this.handler.endElement("div");
        }

        private void findPictures(List<EscherRecord> records) throws IOException, SAXException, TikaException {
            for (EscherRecord escherRecord : records) {
                EscherBlipRecord blip;
                if (escherRecord instanceof EscherBSERecord && (blip = ((EscherBSERecord)escherRecord).getBlipRecord()) != null) {
                    HSSFPictureData picture = new HSSFPictureData(blip);
                    String mimeType = picture.getMimeType();
                    TikaInputStream stream = TikaInputStream.get(picture.getData());
                    this.extractor.handleEmbeddedResource(stream, null, null, mimeType, this.handler, true);
                }
                this.findPictures(escherRecord.getChildRecords());
            }
        }

        private class TikaFormatTrackingHSSFListener
        extends FormatTrackingHSSFListener {
            public TikaFormatTrackingHSSFListener(HSSFListener childListener, Locale locale) {
                super(childListener, locale);
            }

            @Override
            public void processRecord(Record record) {
                super.processRecord(record);
            }

            @Override
            public String formatNumberDateCell(CellValueRecordInterface cell) {
                double value;
                String formatString = this.getFormatString(cell);
                if (cell instanceof NumberRecord) {
                    value = ((NumberRecord)cell).getValue();
                } else {
                    if (!(cell instanceof FormulaRecord)) {
                        throw new IllegalArgumentException("Unsupported CellValue Record passed in " + cell);
                    }
                    value = ((FormulaRecord)cell).getValue();
                }
                if (DateUtil.isADateFormat(this.getFormatIndex(cell), formatString)) {
                    return TikaHSSFListener.this.tikaExcelDataFormatter.formatRawCellContents(value, this.getFormatIndex(cell), formatString, false);
                }
                if ("general".equalsIgnoreCase(formatString)) {
                    return TikaHSSFListener.this.tikaExcelDataFormatter.formatRawCellContents(value, this.getFormatIndex(cell), formatString, false);
                }
                return super.formatNumberDateCell(cell);
            }
        }
    }
}

