/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.point;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.StationObsDataset;
import ucar.nc2.dt.TypedDatasetFactory;
import ucar.nc2.ncml.NcMLWriter;
import ucar.nc2.units.DateFormatter;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.Station;
import ucar.unidata.util.Parameter;

public class StationObsDatasetInfo {
    private StationObsDataset sobs;
    private String path;

    public StationObsDatasetInfo(StationObsDataset sobs, String path) {
        this.sobs = sobs;
        this.path = path;
    }

    public String writeStationObsDatasetXML() {
        XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
        return fmt.outputString(this.makeStationObsDatasetDocument());
    }

    public void writeStationObsDatasetXML(OutputStream os) throws IOException {
        XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
        fmt.output(this.makeStationObsDatasetDocument(), os);
    }

    public String writeStationCollectionXML() throws IOException {
        XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
        return fmt.outputString(this.makeStationCollectionDocument());
    }

    public void writeStationCollectionXML(OutputStream os) throws IOException {
        XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
        fmt.output(this.makeStationCollectionDocument(), os);
    }

    public Document makeStationCollectionDocument() throws IOException {
        Element rootElem = new Element("stationCollection");
        Document doc = new Document(rootElem);
        List<Station> stns = this.sobs.getStations();
        System.out.println("nstns = " + stns.size());
        for (int i = 0; i < stns.size(); ++i) {
            Station s = stns.get(i);
            Element sElem = new Element("station");
            sElem.setAttribute("name", s.getName());
            if (s.getWmoId() != null) {
                sElem.setAttribute("wmo_id", s.getWmoId());
            }
            if (s.getDescription() != null) {
                sElem.addContent(new Element("description").addContent(s.getDescription()));
            }
            sElem.addContent(new Element("longitude").addContent(ucar.unidata.util.Format.d(s.getLongitude(), 6)));
            sElem.addContent(new Element("latitide").addContent(ucar.unidata.util.Format.d(s.getLatitude(), 6)));
            if (!Double.isNaN(s.getAltitude())) {
                sElem.addContent(new Element("altitude").addContent(ucar.unidata.util.Format.d(s.getAltitude(), 6)));
            }
            rootElem.addContent(sElem);
        }
        return doc;
    }

    public Document makeStationObsDatasetDocument() {
        Element rootElem = new Element("stationObsDataset");
        Document doc = new Document(rootElem);
        rootElem.setAttribute("location", this.sobs.getLocationURI());
        if (null != this.path) {
            rootElem.setAttribute("path", this.path);
        }
        List<VariableSimpleIF> vars = this.sobs.getDataVariables();
        Collections.sort(vars);
        for (int i = 0; i < vars.size(); ++i) {
            VariableSimpleIF v = vars.get(i);
            rootElem.addContent(this.writeVariable(v));
        }
        LatLonRect bb = this.sobs.getBoundingBox();
        if (bb != null) {
            rootElem.addContent(this.writeBoundingBox(bb));
        }
        Date start = this.sobs.getStartDate();
        Date end = this.sobs.getEndDate();
        if (start != null && end != null) {
            DateFormatter format = new DateFormatter();
            Element dateRange = new Element("TimeSpan");
            dateRange.addContent(new Element("begin").addContent(format.toDateTimeStringISO(start)));
            dateRange.addContent(new Element("end").addContent(format.toDateTimeStringISO(end)));
            rootElem.addContent(dateRange);
        }
        Element elem = new Element("AcceptList");
        elem.addContent(new Element("accept").addContent("raw"));
        elem.addContent(new Element("accept").addContent("xml"));
        elem.addContent(new Element("accept").addContent("csv"));
        elem.addContent(new Element("accept").addContent("netcdf"));
        elem.addContent(new Element("accept").addContent("netcdfStream"));
        rootElem.addContent(elem);
        return doc;
    }

    private Element writeBoundingBox(LatLonRect bb) {
        Element bbElem = new Element("LatLonBox");
        bbElem.addContent(new Element("west").addContent(ucar.unidata.util.Format.dfrac(bb.getLonMin(), 4)));
        bbElem.addContent(new Element("east").addContent(ucar.unidata.util.Format.dfrac(bb.getLonMax(), 4)));
        bbElem.addContent(new Element("south").addContent(ucar.unidata.util.Format.dfrac(bb.getLatMin(), 4)));
        bbElem.addContent(new Element("north").addContent(ucar.unidata.util.Format.dfrac(bb.getLatMax(), 4)));
        return bbElem;
    }

    private Element writeCoordSys(GridCoordSystem cs) {
        Element csElem = new Element("coordSys");
        csElem.setAttribute("name", cs.getName());
        List<CoordinateAxis> axes = cs.getCoordinateAxes();
        for (int i = 0; i < axes.size(); ++i) {
            CoordinateAxis axis = axes.get(i);
            Element axisElem = new Element("axisRef");
            axisElem.setAttribute("name", axis.getFullName());
            csElem.addContent(axisElem);
        }
        List<CoordinateTransform> cts = cs.getCoordinateTransforms();
        for (int j = 0; j < cts.size(); ++j) {
            CoordinateTransform ct = cts.get(j);
            Element elem = new Element("coordTransRef");
            elem.setAttribute("name", ct.getName());
            csElem.addContent(elem);
        }
        return csElem;
    }

    private Element writeCoordTransform(CoordinateTransform ct) {
        Element ctElem = new Element("coordTransform");
        ctElem.setAttribute("name", ct.getName());
        ctElem.setAttribute("transformType", ct.getTransformType().toString());
        List<Parameter> params = ct.getParameters();
        for (int i = 0; i < params.size(); ++i) {
            Parameter param = params.get(i);
            Element pElem = new Element("parameter");
            pElem.setAttribute("name", param.getName());
            pElem.setAttribute("value", param.getStringValue());
            ctElem.addContent(pElem);
        }
        return ctElem;
    }

    private Element writeVariable(VariableSimpleIF v) {
        Element varElem = new Element("variable");
        varElem.setAttribute("name", v.getShortName());
        DataType dt = v.getDataType();
        if (dt != null) {
            varElem.setAttribute("type", dt.toString());
        }
        for (Attribute att : v.getAttributes()) {
            varElem.addContent(NcMLWriter.writeAttribute(att, "attribute", null));
        }
        return varElem;
    }

    public static void main(String[] args) throws IOException {
        String url = "C:/data/metars/Surface_METAR_20060326_0000.nc";
        StationObsDataset ncd = (StationObsDataset)TypedDatasetFactory.open(FeatureType.STATION, url, null, new StringBuilder());
        StationObsDatasetInfo info = new StationObsDatasetInfo(ncd, null);
        FileOutputStream fos2 = new FileOutputStream("C:/TEMP/stationCollection.xml");
        GZIPOutputStream zout = new GZIPOutputStream(fos2);
        info.writeStationObsDatasetXML(System.out);
        info.writeStationCollectionXML(zout);
        zout.close();
        File f = new File("C:/TEMP/stationCollection.xml");
        System.out.println(" size=" + f.length());
    }
}

