/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.aggregate;

import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Stream;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.math.DecimalFunctions;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.aggregate.ConcatenatedGridResource;
import org.apache.sis.storage.aggregate.DimensionSelector;
import org.apache.sis.storage.aggregate.GridSlice;
import org.apache.sis.storage.aggregate.GridSliceLocator;
import org.apache.sis.storage.aggregate.Group;
import org.apache.sis.storage.aggregate.GroupAggregate;
import org.apache.sis.storage.aggregate.MergeStrategy;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;

final class GroupByTransform
extends Group<GridSlice> {
    private final GridGeometry geometry;
    private final MathTransform gridToCRS;
    MergeStrategy strategy;

    GroupByTransform(GridGeometry gridGeometry, MathTransform mathTransform, MergeStrategy mergeStrategy) {
        this.geometry = gridGeometry;
        this.gridToCRS = mathTransform;
        this.strategy = mergeStrategy;
    }

    @Override
    final String createName(Locale locale) {
        Vocabulary vocabulary = Vocabulary.getResources(locale);
        StringBuffer stringBuffer = new StringBuffer(vocabulary.getLabel((short)172));
        NumberFormat numberFormat = NumberFormat.getIntegerInstance(vocabulary.getLocale());
        FieldPosition fieldPosition = new FieldPosition(0);
        String string = "";
        for (double d : this.geometry.getResolution(true)) {
            numberFormat.setMaximumFractionDigits(Math.max(DecimalFunctions.fractionDigitsForDelta(d / 100.0, false), 0));
            numberFormat.format(d, stringBuffer.append(string), fieldPosition);
            string = " \u00d7 ";
        }
        return stringBuffer.toString();
    }

    final Matrix linearTransform(MathTransform mathTransform) {
        if (this.gridToCRS.getTargetDimensions() == mathTransform.getSourceDimensions()) {
            return MathTransforms.getMatrix(MathTransforms.concatenate(this.gridToCRS, mathTransform));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] findConcatenatedDimensions() {
        int n;
        Object[] objectArray;
        int n2;
        Object object = this.members;
        synchronized (object) {
            n2 = this.members.size();
            objectArray = new DimensionSelector[this.geometry.getDimension()];
            n = objectArray.length;
            while (--n >= 0) {
                objectArray[n] = new DimensionSelector(n, n2);
            }
            while (--n2 >= 0) {
                ((GridSlice)this.members.get(n2)).getGridExtent(n2, (DimensionSelector[])objectArray);
            }
        }
        ((Stream)Arrays.stream(objectArray).parallel()).forEach(DimensionSelector::finish);
        Arrays.sort(objectArray);
        object = new int[objectArray.length];
        n2 = 0;
        n = objectArray.length;
        while (--n >= 0 && !((DimensionSelector)objectArray[n]).isConstantPosition) {
            object[n2++] = ((DimensionSelector)objectArray[n]).dimension;
        }
        return ArraysExt.resize((int[])object, n2);
    }

    final Resource createResource(StoreListeners storeListeners, List<SampleDimension> list) {
        int n = this.members.size();
        if (n == 1) {
            return ((GridSlice)this.members.get((int)0)).resource;
        }
        GridCoverageResource[] gridCoverageResourceArray = new GridCoverageResource[n];
        String string = this.getName(storeListeners);
        int[] nArray = this.findConcatenatedDimensions();
        if (nArray.length == 0) {
            for (int i = 0; i < n; ++i) {
                gridCoverageResourceArray[i] = ((GridSlice)this.members.get((int)i)).resource;
            }
            return new GroupAggregate(storeListeners, string, gridCoverageResourceArray, list);
        }
        GridSliceLocator gridSliceLocator = new GridSliceLocator(this.members, nArray[0], gridCoverageResourceArray);
        GridGeometry gridGeometry = gridSliceLocator.union(this.geometry, this.members, GridSlice::getGridExtent);
        return new ConcatenatedGridResource(string, storeListeners, gridGeometry, list, gridCoverageResourceArray, gridSliceLocator, this.strategy);
    }
}

