/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import javax.measure.Unit;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Length;
import org.apache.sis.internal.referencing.provider.FranceGeocentricInterpolation;
import org.apache.sis.internal.referencing.provider.Molodensky;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.referencing.datum.DatumShiftGrid;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.apache.sis.referencing.operation.transform.DatumShiftTransform;
import org.apache.sis.referencing.operation.transform.EllipsoidToCentricTransform;
import org.apache.sis.referencing.operation.transform.InterpolatedGeocentricTransform2D;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class InterpolatedGeocentricTransform
extends DatumShiftTransform {
    private static final long serialVersionUID = 5503722845441653093L;
    static final ParameterDescriptorGroup DESCRIPTOR;
    private static final ParameterDescriptorGroup INVERSE;
    final double semiMajor;
    final double scale;
    final AbstractMathTransform ellipsoidToCentric;
    final AbstractMathTransform centricToEllipsoid;
    private final InterpolatedGeocentricTransform inverse;

    InterpolatedGeocentricTransform(InterpolatedGeocentricTransform interpolatedGeocentricTransform, Ellipsoid ellipsoid, Ellipsoid ellipsoid2) {
        this(ellipsoid2, interpolatedGeocentricTransform.getTargetDimensions() > 2, ellipsoid, interpolatedGeocentricTransform.getSourceDimensions() > 2, interpolatedGeocentricTransform.grid, interpolatedGeocentricTransform);
    }

    protected InterpolatedGeocentricTransform(Ellipsoid ellipsoid, boolean bl, Ellipsoid ellipsoid2, boolean bl2, DatumShiftGrid<Angle, Length> datumShiftGrid) {
        this(ellipsoid, bl, ellipsoid2, bl2, datumShiftGrid, null);
    }

    private InterpolatedGeocentricTransform(Ellipsoid ellipsoid, boolean bl, Ellipsoid ellipsoid2, boolean bl2, DatumShiftGrid<?, ?> datumShiftGrid, InterpolatedGeocentricTransform interpolatedGeocentricTransform) {
        super(interpolatedGeocentricTransform != null ? INVERSE : DESCRIPTOR, bl, bl2, datumShiftGrid);
        ArgumentChecks.ensureNonNull("source", ellipsoid);
        ArgumentChecks.ensureNonNull("target", ellipsoid2);
        ArgumentChecks.ensureNonNull("grid", datumShiftGrid);
        Unit<Length> unit = ellipsoid.getAxisUnit();
        InterpolatedGeocentricTransform.ensureGeocentricTranslation(datumShiftGrid, unit);
        this.semiMajor = ellipsoid.getSemiMajorAxis();
        double d = ellipsoid.getSemiMinorAxis();
        this.setContextParameters(this.semiMajor, d, unit, ellipsoid2);
        this.context.getOrCreate(Molodensky.DIMENSION).setValue(bl ? 3 : 2);
        datumShiftGrid.getParameterValues(this.context);
        this.scale = this.semiMajor / this.context.doubleValue(Molodensky.TGT_SEMI_MAJOR);
        if (interpolatedGeocentricTransform == null) {
            this.ellipsoidToCentric = new EllipsoidToCentricTransform(this.semiMajor, d, unit, bl, EllipsoidToCentricTransform.TargetType.CARTESIAN);
            this.centricToEllipsoid = (AbstractMathTransform)new EllipsoidToCentricTransform(ellipsoid2.getSemiMajorAxis(), ellipsoid2.getSemiMinorAxis(), ellipsoid2.getAxisUnit(), bl2, EllipsoidToCentricTransform.TargetType.CARTESIAN).inverse();
        } else {
            try {
                this.ellipsoidToCentric = (AbstractMathTransform)interpolatedGeocentricTransform.centricToEllipsoid.inverse();
                this.centricToEllipsoid = (AbstractMathTransform)interpolatedGeocentricTransform.ellipsoidToCentric.inverse();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                throw new IllegalArgumentException(noninvertibleTransformException);
            }
        }
        this.context.getMatrix(ContextualParameters.MatrixRole.NORMALIZATION).setMatrix(this.ellipsoidToCentric.getContextualParameters().getMatrix(ContextualParameters.MatrixRole.NORMALIZATION));
        this.context.getMatrix(ContextualParameters.MatrixRole.DENORMALIZATION).setMatrix(this.centricToEllipsoid.getContextualParameters().getMatrix(ContextualParameters.MatrixRole.DENORMALIZATION));
        if (interpolatedGeocentricTransform == null) {
            interpolatedGeocentricTransform = bl || bl2 ? new Inverse(this, ellipsoid, ellipsoid2) : new InterpolatedGeocentricTransform2D.Inverse(this, ellipsoid, ellipsoid2);
        }
        this.inverse = interpolatedGeocentricTransform;
    }

    private MathTransform completeTransform(MathTransformFactory mathTransformFactory, boolean bl) throws FactoryException {
        this.ellipsoidToCentric.getContextualParameters().completeTransform(mathTransformFactory, null);
        this.centricToEllipsoid.getContextualParameters().completeTransform(mathTransformFactory, null);
        return this.context.completeTransform(mathTransformFactory, bl ? this : null);
    }

    public static MathTransform createGeodeticTransformation(MathTransformFactory mathTransformFactory, Ellipsoid ellipsoid, boolean bl, Ellipsoid ellipsoid2, boolean bl2, DatumShiftGrid<Angle, Length> datumShiftGrid) throws FactoryException {
        InterpolatedGeocentricTransform interpolatedGeocentricTransform = bl || bl2 ? new InterpolatedGeocentricTransform(ellipsoid, bl, ellipsoid2, bl2, datumShiftGrid) : new InterpolatedGeocentricTransform2D(ellipsoid, ellipsoid2, datumShiftGrid);
        interpolatedGeocentricTransform.inverse.completeTransform(mathTransformFactory, false);
        return super.completeTransform(mathTransformFactory, true);
    }

    @Override
    public int getSourceDimensions() {
        return this.ellipsoidToCentric.getSourceDimensions();
    }

    @Override
    public int getTargetDimensions() {
        return this.centricToEllipsoid.getTargetDimensions();
    }

    @Override
    public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) throws TransformException {
        double[] dArray3 = new double[3];
        this.grid.interpolateInCell(this.normalizedToGridX(dArray[n]), this.normalizedToGridY(dArray[n + 1]), dArray3);
        double d = dArray3[0] / this.semiMajor;
        double d2 = dArray3[1] / this.semiMajor;
        double d3 = dArray3[2] / this.semiMajor;
        Matrix matrix = this.ellipsoidToCentric.transform(dArray, n, dArray3, 0, bl);
        dArray3[0] = (dArray3[0] + d) * this.scale;
        dArray3[1] = (dArray3[1] + d2) * this.scale;
        dArray3[2] = (dArray3[2] + d3) * this.scale;
        Matrix matrix2 = this.centricToEllipsoid.transform(dArray3, 0, dArray2, n2, bl);
        if (matrix == null || matrix2 == null) {
            return null;
        }
        return this.concatenate(matrix, matrix2);
    }

    final Matrix concatenate(Matrix matrix, Matrix matrix2) {
        int n = matrix.getNumCol();
        while (--n >= 0) {
            int n2 = 3;
            while (--n2 >= 0) {
                matrix.setElement(n2, n, matrix.getElement(n2, n) * this.scale);
            }
        }
        return Matrices.multiply(matrix2, matrix);
    }

    @Override
    public MathTransform inverse() {
        return this.inverse;
    }

    static {
        ParameterBuilder parameterBuilder = (ParameterBuilder)new ParameterBuilder().setRequired(true).setCodeSpace(Citations.SIS, "SIS");
        GeneralParameterDescriptor[] generalParameterDescriptorArray = new ParameterDescriptor[]{Molodensky.DIMENSION, Molodensky.SRC_SEMI_MAJOR, Molodensky.SRC_SEMI_MINOR, Molodensky.TGT_SEMI_MAJOR, Molodensky.TGT_SEMI_MINOR, FranceGeocentricInterpolation.FILE};
        DESCRIPTOR = ((ParameterBuilder)parameterBuilder.addName("Geocentric interpolation")).createGroup(generalParameterDescriptorArray);
        INVERSE = ((ParameterBuilder)parameterBuilder.addName("Geocentric inverse interpolation")).createGroup(generalParameterDescriptorArray);
    }

    static class Inverse
    extends InterpolatedGeocentricTransform {
        private static final long serialVersionUID = -3481207454803064521L;
        private final double tX;
        private final double tY;
        private final double tZ;

        Inverse(InterpolatedGeocentricTransform interpolatedGeocentricTransform, Ellipsoid ellipsoid, Ellipsoid ellipsoid2) {
            super(interpolatedGeocentricTransform, ellipsoid, ellipsoid2);
            this.tX = this.grid.getCellMean(0) / this.semiMajor;
            this.tY = this.grid.getCellMean(1) / this.semiMajor;
            this.tZ = this.grid.getCellMean(2) / this.semiMajor;
        }

        @Override
        public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) throws TransformException {
            double[] dArray3 = new double[3];
            Matrix matrix = this.ellipsoidToCentric.transform(dArray, n, dArray3, 0, bl);
            double d = dArray3[0];
            double d2 = dArray3[1];
            double d3 = dArray3[2];
            dArray3[0] = d - this.tX;
            dArray3[1] = d2 - this.tY;
            dArray3[2] = d3 - this.tZ;
            this.centricToEllipsoid.transform(dArray3, 0, dArray3, 0, bl);
            this.grid.interpolateInCell(this.normalizedToGridX(dArray3[0]), this.normalizedToGridY(dArray3[1]), dArray3);
            dArray3[0] = (d - dArray3[0] / this.semiMajor) * this.scale;
            dArray3[1] = (d2 - dArray3[1] / this.semiMajor) * this.scale;
            dArray3[2] = (d3 - dArray3[2] / this.semiMajor) * this.scale;
            Matrix matrix2 = this.centricToEllipsoid.transform(dArray3, 0, dArray2, n2, bl);
            if (matrix == null || matrix2 == null) {
                return null;
            }
            return this.concatenate(matrix, matrix2);
        }
    }
}

