/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.projection;

import java.util.EnumMap;
import java.util.regex.Pattern;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.matrix.Matrix2;
import org.apache.sis.referencing.operation.projection.Initializer;
import org.apache.sis.referencing.operation.projection.MeridianArcBased;
import org.apache.sis.referencing.operation.projection.NormalizedProjection;
import org.apache.sis.referencing.operation.projection.ProjectionException;
import org.apache.sis.referencing.operation.projection.ProjectionVariant;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class Sinusoidal
extends MeridianArcBased {
    private static final long serialVersionUID = 7908925241331303236L;
    private final Variant variant;

    private static Initializer initializer(OperationMethod operationMethod, Parameters parameters) {
        Variant variant = (Variant)Sinusoidal.variant((OperationMethod)operationMethod, (ProjectionVariant[])Variant.values(), null);
        EnumMap<NormalizedProjection.ParameterRole, ParameterDescriptor<Double>> enumMap = new EnumMap<NormalizedProjection.ParameterRole, ParameterDescriptor<Double>>(NormalizedProjection.ParameterRole.class);
        enumMap.put(NormalizedProjection.ParameterRole.CENTRAL_MERIDIAN, org.apache.sis.internal.referencing.provider.Sinusoidal.CENTRAL_MERIDIAN);
        enumMap.put(NormalizedProjection.ParameterRole.FALSE_EASTING, org.apache.sis.internal.referencing.provider.Sinusoidal.FALSE_EASTING);
        enumMap.put(NormalizedProjection.ParameterRole.FALSE_NORTHING, org.apache.sis.internal.referencing.provider.Sinusoidal.FALSE_NORTHING);
        return new Initializer(operationMethod, parameters, enumMap, variant);
    }

    public Sinusoidal(OperationMethod operationMethod, Parameters parameters) {
        this(Sinusoidal.initializer(operationMethod, parameters));
    }

    private Sinusoidal(Initializer initializer) {
        super(initializer);
        this.variant = (Variant)initializer.variant;
    }

    Sinusoidal(Sinusoidal sinusoidal) {
        super(sinusoidal);
        this.variant = sinusoidal.variant;
    }

    @Override
    public MathTransform createMapProjection(MathTransformFactory mathTransformFactory) throws FactoryException {
        Sinusoidal sinusoidal = this;
        if (this.eccentricity == 0.0 && this.getClass() == Sinusoidal.class || this.variant == Variant.PSEUDO) {
            sinusoidal = new Spherical(this);
        }
        return this.context.completeTransform(mathTransformFactory, sinusoidal);
    }

    @Override
    public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) throws ProjectionException {
        double d = dArray[n];
        double d2 = dArray[n + 1];
        double d3 = Math.cos(d2);
        double d4 = Math.sin(d2);
        double d5 = d4 * d4;
        double d6 = 1.0 - this.eccentricitySquared * d5;
        double d7 = Math.sqrt(d6);
        double d8 = d3 / d7;
        if (dArray2 != null) {
            dArray2[n2] = d8 * d;
            dArray2[n2 + 1] = this.distance(d2, d4, d3);
        }
        if (!bl) {
            return null;
        }
        double d9 = d * d4 * (this.eccentricitySquared * (d3 * d3) / d6 - 1.0) / d7;
        return new Matrix2(d8, d9, 0.0, this.dM_d\u03c6(d5));
    }

    @Override
    protected void inverseTransform(double[] dArray, int n, double[] dArray2, int n2) {
        double d = dArray[n];
        double d2 = dArray[n + 1];
        double d3 = this.latitude(d2);
        double d4 = Math.sin(d3);
        dArray2[n2] = d * Math.sqrt(1.0 - this.eccentricitySquared * (d4 * d4)) / Math.cos(d3);
        dArray2[n2 + 1] = d3;
    }

    private static enum Variant implements ProjectionVariant
    {
        PSEUDO(".*\\bPseudo.*");

        private final Pattern operationName;

        private Variant(String string2) {
            this.operationName = Pattern.compile(string2, 2);
        }

        @Override
        public Pattern getOperationNamePattern() {
            return this.operationName;
        }

        @Override
        public String getIdentifier() {
            return null;
        }
    }

    private static final class Spherical
    extends Sinusoidal {
        private static final long serialVersionUID = -5843301120207230310L;

        Spherical(Sinusoidal sinusoidal) {
            super(sinusoidal);
        }

        @Override
        public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) {
            double d = dArray[n];
            double d2 = dArray[n + 1];
            double d3 = Math.cos(d2);
            if (dArray2 != null) {
                dArray2[n2] = d * d3;
                dArray2[n2 + 1] = d2;
            }
            return bl ? new Matrix2(d3, -d * Math.sin(d2), 0.0, 1.0) : null;
        }

        @Override
        public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) throws TransformException {
            if (dArray != dArray2 || n != n2) {
                super.transform(dArray, n, dArray2, n2, n3);
            } else {
                while (--n3 >= 0) {
                    int n4 = n2;
                    dArray2[n4] = dArray2[n4] * Math.cos(dArray2[n2 + 1]);
                    n2 += 2;
                }
            }
        }

        @Override
        protected void inverseTransform(double[] dArray, int n, double[] dArray2, int n2) {
            double d = dArray[n];
            double d2 = dArray[n + 1];
            dArray2[n2] = d / Math.cos(d2);
            dArray2[n2 + 1] = d2;
        }
    }
}

