/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.measure.IncommensurableException;
import javax.measure.Unit;
import javax.measure.quantity.Time;
import org.apache.sis.internal.referencing.AnnotatedMatrix;
import org.apache.sis.internal.referencing.AxisDirections;
import org.apache.sis.internal.referencing.CoordinateOperations;
import org.apache.sis.internal.referencing.EllipsoidalHeightCombiner;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.internal.referencing.provider.Affine;
import org.apache.sis.internal.referencing.provider.DatumShiftMethod;
import org.apache.sis.internal.referencing.provider.GeocentricAffine;
import org.apache.sis.internal.referencing.provider.GeocentricToGeographic;
import org.apache.sis.internal.referencing.provider.Geographic2Dto3D;
import org.apache.sis.internal.referencing.provider.Geographic3Dto2D;
import org.apache.sis.internal.referencing.provider.GeographicToGeocentric;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.metadata.iso.extent.Extents;
import org.apache.sis.parameter.TensorParameters;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.NamedIdentifier;
import org.apache.sis.referencing.cs.CoordinateSystems;
import org.apache.sis.referencing.datum.DefaultGeodeticDatum;
import org.apache.sis.referencing.operation.CRSPair;
import org.apache.sis.referencing.operation.CoordinateOperationContext;
import org.apache.sis.referencing.operation.CoordinateOperationRegistry;
import org.apache.sis.referencing.operation.DefaultOperationMethod;
import org.apache.sis.referencing.operation.DefaultPassThroughOperation;
import org.apache.sis.referencing.operation.LooselyDefinedMethod;
import org.apache.sis.referencing.operation.MathTransformContext;
import org.apache.sis.referencing.operation.SubOperationInfo;
import org.apache.sis.referencing.operation.SubTypes;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.DefaultMathTransformFactory;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.metadata.quality.PositionalAccuracy;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.crs.GeodeticCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.operation.ConcatenatedOperation;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.OperationNotFoundException;
import org.opengis.referencing.operation.SingleOperation;
import org.opengis.referencing.operation.TransformException;
import org.opengis.referencing.operation.Transformation;
import org.opengis.util.FactoryException;
import org.opengis.util.GenericName;

public class CoordinateOperationFinder
extends CoordinateOperationRegistry {
    private final Map<Identifier, Object> identifierOfStepCRS = new HashMap<Identifier, Object>(8);
    private final Map<CRSPair, Boolean> previousSearches = new HashMap<CRSPair, Boolean>(8);
    private final boolean useCache;

    public CoordinateOperationFinder(CoordinateOperationAuthorityFactory coordinateOperationAuthorityFactory, CoordinateOperationFactory coordinateOperationFactory, CoordinateOperationContext coordinateOperationContext) throws FactoryException {
        super(coordinateOperationAuthorityFactory, coordinateOperationFactory, coordinateOperationContext);
        this.useCache = coordinateOperationContext == null && coordinateOperationFactory == this.factorySIS;
    }

    public CoordinateOperation createOperation(CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2) throws OperationNotFoundException, FactoryException {
        boolean bl = this.stopAtFirst;
        this.stopAtFirst = true;
        List<CoordinateOperation> list = this.createOperations(coordinateReferenceSystem, coordinateReferenceSystem2);
        this.stopAtFirst = bl;
        if (!list.isEmpty()) {
            return list.get(0);
        }
        throw new OperationNotFoundException(CoordinateOperationFinder.notFoundMessage(coordinateReferenceSystem, coordinateReferenceSystem2));
    }

    @Override
    public List<CoordinateOperation> createOperations(CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2) throws FactoryException {
        Datum datum;
        Object object;
        Object object2;
        ArgumentChecks.ensureNonNull("sourceCRS", coordinateReferenceSystem);
        ArgumentChecks.ensureNonNull("targetCRS", coordinateReferenceSystem2);
        if (Utilities.equalsIgnoreMetadata(coordinateReferenceSystem, coordinateReferenceSystem2)) {
            try {
                return CoordinateOperationFinder.asList(this.createFromAffineTransform(AXIS_CHANGES, coordinateReferenceSystem, coordinateReferenceSystem2, CoordinateSystems.swapAndScaleAxes(coordinateReferenceSystem.getCoordinateSystem(), coordinateReferenceSystem2.getCoordinateSystem())));
            }
            catch (IllegalArgumentException | IncommensurableException exception) {
                throw new FactoryException(Resources.format((short)5, new CRSPair(coordinateReferenceSystem, coordinateReferenceSystem2)), exception);
            }
        }
        CRSPair cRSPair = new CRSPair(coordinateReferenceSystem, coordinateReferenceSystem2);
        if (this.useCache && this.stopAtFirst && !this.previousSearches.isEmpty() && (object2 = this.factorySIS.cache.peek(cRSPair)) != null) {
            return CoordinateOperationFinder.asList((CoordinateOperation)object2);
        }
        if (this.previousSearches.put(cRSPair, Boolean.TRUE) != null) {
            throw new FactoryException(Resources.format((short)62, CoordinateOperation.class, cRSPair));
        }
        object2 = Extents.getGeographicBoundingBox(this.areaOfInterest);
        if (object2 == null) {
            object2 = Extents.intersection(CRS.getGeographicBoundingBox(coordinateReferenceSystem), CRS.getGeographicBoundingBox(coordinateReferenceSystem2));
            this.areaOfInterest = CoordinateOperationContext.setGeographicBoundingBox(this.areaOfInterest, (GeographicBoundingBox)object2);
        }
        if (this.registry != null && !(object = super.createOperations(coordinateReferenceSystem, coordinateReferenceSystem2)).isEmpty()) {
            return object;
        }
        if (coordinateReferenceSystem instanceof GeneralDerivedCRS) {
            object = (GeneralDerivedCRS)coordinateReferenceSystem;
            if (coordinateReferenceSystem2 instanceof GeneralDerivedCRS) {
                return this.createOperationStep((GeneralDerivedCRS)object, (GeneralDerivedCRS)coordinateReferenceSystem2);
            }
            if (coordinateReferenceSystem2 instanceof SingleCRS) {
                return this.createOperationStep((GeneralDerivedCRS)object, (SingleCRS)coordinateReferenceSystem2);
            }
        }
        if (coordinateReferenceSystem2 instanceof GeneralDerivedCRS) {
            object = (GeneralDerivedCRS)coordinateReferenceSystem2;
            if (coordinateReferenceSystem instanceof SingleCRS) {
                return this.createOperationStep((SingleCRS)coordinateReferenceSystem, (GeneralDerivedCRS)object);
            }
        }
        if (coordinateReferenceSystem instanceof GeodeticCRS) {
            object = (GeodeticCRS)coordinateReferenceSystem;
            if (coordinateReferenceSystem2 instanceof GeodeticCRS) {
                return this.createOperationStep((GeodeticCRS)object, (GeodeticCRS)coordinateReferenceSystem2);
            }
            if (coordinateReferenceSystem2 instanceof VerticalCRS) {
                return this.createOperationStep((GeodeticCRS)object, (VerticalCRS)coordinateReferenceSystem2);
            }
        }
        if (coordinateReferenceSystem instanceof VerticalCRS) {
            object = (VerticalCRS)coordinateReferenceSystem;
            if (coordinateReferenceSystem2 instanceof VerticalCRS) {
                return this.createOperationStep((VerticalCRS)object, (VerticalCRS)coordinateReferenceSystem2);
            }
        }
        if (coordinateReferenceSystem instanceof TemporalCRS) {
            object = (TemporalCRS)coordinateReferenceSystem;
            if (coordinateReferenceSystem2 instanceof TemporalCRS) {
                return this.createOperationStep((TemporalCRS)object, (TemporalCRS)coordinateReferenceSystem2);
            }
        }
        if (coordinateReferenceSystem instanceof SingleCRS && coordinateReferenceSystem2 instanceof SingleCRS && Utilities.equalsIgnoreMetadata(object = ((SingleCRS)coordinateReferenceSystem).getDatum(), datum = ((SingleCRS)coordinateReferenceSystem2).getDatum())) {
            try {
                return CoordinateOperationFinder.asList(this.createFromAffineTransform(AXIS_CHANGES, coordinateReferenceSystem, coordinateReferenceSystem2, CoordinateSystems.swapAndScaleAxes(coordinateReferenceSystem.getCoordinateSystem(), coordinateReferenceSystem2.getCoordinateSystem())));
            }
            catch (IllegalArgumentException | IncommensurableException exception) {
                throw new FactoryException(CoordinateOperationFinder.notFoundMessage(coordinateReferenceSystem, coordinateReferenceSystem2), exception);
            }
        }
        if (coordinateReferenceSystem instanceof CompoundCRS || coordinateReferenceSystem2 instanceof CompoundCRS) {
            return this.createOperationStep(coordinateReferenceSystem, CRS.getSingleComponents(coordinateReferenceSystem), coordinateReferenceSystem2, CRS.getSingleComponents(coordinateReferenceSystem2));
        }
        throw new OperationNotFoundException(CoordinateOperationFinder.notFoundMessage(coordinateReferenceSystem, coordinateReferenceSystem2));
    }

    protected List<CoordinateOperation> createOperationStep(SingleCRS singleCRS, GeneralDerivedCRS generalDerivedCRS) throws FactoryException {
        List<CoordinateOperation> list = this.createOperations(singleCRS, generalDerivedCRS.getBaseCRS());
        ListIterator<CoordinateOperation> listIterator = list.listIterator();
        if (listIterator.hasNext()) {
            Conversion conversion = generalDerivedCRS.getConversionFromBase();
            do {
                CoordinateOperation coordinateOperation = listIterator.next();
                listIterator.set(this.concatenate(coordinateOperation, conversion));
            } while (listIterator.hasNext());
        }
        return list;
    }

    protected List<CoordinateOperation> createOperationStep(GeneralDerivedCRS generalDerivedCRS, SingleCRS singleCRS) throws FactoryException {
        List<CoordinateOperation> list = this.createOperations(generalDerivedCRS.getBaseCRS(), singleCRS);
        ListIterator<CoordinateOperation> listIterator = list.listIterator();
        if (listIterator.hasNext()) {
            CoordinateOperation coordinateOperation;
            try {
                coordinateOperation = this.inverse(generalDerivedCRS.getConversionFromBase());
            }
            catch (OperationNotFoundException operationNotFoundException) {
                throw operationNotFoundException;
            }
            catch (NoninvertibleTransformException | FactoryException exception) {
                throw new OperationNotFoundException(CoordinateOperationFinder.canNotInvert(generalDerivedCRS), exception);
            }
            do {
                CoordinateOperation coordinateOperation2 = listIterator.next();
                listIterator.set(this.concatenate(coordinateOperation, coordinateOperation2));
            } while (listIterator.hasNext());
        }
        return list;
    }

    protected List<CoordinateOperation> createOperationStep(GeneralDerivedCRS generalDerivedCRS, GeneralDerivedCRS generalDerivedCRS2) throws FactoryException {
        List<CoordinateOperation> list = this.createOperations(generalDerivedCRS.getBaseCRS(), generalDerivedCRS2.getBaseCRS());
        ListIterator<CoordinateOperation> listIterator = list.listIterator();
        if (listIterator.hasNext()) {
            CoordinateOperation coordinateOperation;
            Conversion conversion = generalDerivedCRS2.getConversionFromBase();
            try {
                coordinateOperation = this.inverse(generalDerivedCRS.getConversionFromBase());
            }
            catch (OperationNotFoundException operationNotFoundException) {
                throw operationNotFoundException;
            }
            catch (NoninvertibleTransformException | FactoryException exception) {
                throw new OperationNotFoundException(CoordinateOperationFinder.canNotInvert(generalDerivedCRS), exception);
            }
            do {
                CoordinateOperation coordinateOperation2 = listIterator.next();
                listIterator.set(this.concatenate(coordinateOperation, coordinateOperation2, conversion));
            } while (listIterator.hasNext());
        }
        return list;
    }

    protected List<CoordinateOperation> createOperationStep(GeodeticCRS geodeticCRS, GeodeticCRS geodeticCRS2) throws FactoryException {
        ParameterValueGroup parameterValueGroup;
        Identifier identifier;
        GeodeticDatum geodeticDatum = geodeticCRS.getDatum();
        GeodeticDatum geodeticDatum2 = geodeticCRS2.getDatum();
        Matrix matrix = null;
        MathTransformContext mathTransformContext = new MathTransformContext(geodeticDatum, geodeticDatum2);
        mathTransformContext.setSource(geodeticCRS);
        mathTransformContext.setTarget(geodeticCRS2);
        boolean bl = false;
        CoordinateSystem coordinateSystem = mathTransformContext.getSourceCS();
        CoordinateSystem coordinateSystem2 = mathTransformContext.getTargetCS();
        if (Utilities.equalsIgnoreMetadata(geodeticDatum, geodeticDatum2)) {
            boolean bl2;
            bl = coordinateSystem instanceof EllipsoidalCS && coordinateSystem2 instanceof CartesianCS;
            boolean bl3 = bl2 = coordinateSystem instanceof CartesianCS && coordinateSystem2 instanceof EllipsoidalCS;
            identifier = bl2 ^ bl ? GEOCENTRIC_CONVERSION : AXIS_CHANGES;
        } else {
            identifier = ELLIPSOID_CHANGE;
            if (geodeticDatum instanceof DefaultGeodeticDatum && (matrix = ((DefaultGeodeticDatum)geodeticDatum).getPositionVectorTransformation(geodeticDatum2, this.areaOfInterest)) != null) {
                identifier = DATUM_SHIFT;
            }
        }
        DefaultMathTransformFactory defaultMathTransformFactory = this.factorySIS.getDefaultMathTransformFactory();
        MathTransform mathTransform = null;
        MathTransform mathTransform2 = null;
        OperationMethod operationMethod = null;
        if (identifier == DATUM_SHIFT || identifier == ELLIPSOID_CHANGE) {
            parameterValueGroup = GeocentricAffine.createParameters(coordinateSystem, coordinateSystem2, matrix, DatumShiftMethod.forAccuracy(this.desiredAccuracy));
            if (parameterValueGroup == null) {
                parameterValueGroup = matrix != null ? TensorParameters.WKT1.createValueGroup(CoordinateOperationFinder.properties("Affine"), matrix) : Affine.identity(3);
                CoordinateSystem coordinateSystem3 = CommonCRS.WGS84.geocentric().getCoordinateSystem();
                mathTransform = defaultMathTransformFactory.createCoordinateSystemChange(coordinateSystem, coordinateSystem3, geodeticDatum.getEllipsoid());
                mathTransform2 = defaultMathTransformFactory.createCoordinateSystemChange(coordinateSystem3, coordinateSystem2, geodeticDatum2.getEllipsoid());
                mathTransformContext.setSource(coordinateSystem3);
                mathTransformContext.setTarget(coordinateSystem3);
                if (!mathTransform.isIdentity() || !mathTransform2.isIdentity()) {
                    operationMethod = LooselyDefinedMethod.AFFINE_GEOCENTRIC;
                }
            }
        } else if (identifier == GEOCENTRIC_CONVERSION) {
            ParameterDescriptorGroup parameterDescriptorGroup;
            GeodeticCRS geodeticCRS3;
            if (bl) {
                geodeticCRS3 = geodeticCRS;
                parameterDescriptorGroup = GeographicToGeocentric.PARAMETERS;
            } else {
                geodeticCRS3 = geodeticCRS2;
                parameterDescriptorGroup = GeocentricToGeographic.PARAMETERS;
            }
            parameterValueGroup = parameterDescriptorGroup.createValue();
            parameterValueGroup.parameter("dim").setValue(geodeticCRS3.getCoordinateSystem().getDimension());
        } else {
            int n = coordinateSystem.getDimension();
            int n2 = coordinateSystem2.getDimension();
            if (n == 2 && n2 == 3 && coordinateSystem instanceof EllipsoidalCS) {
                parameterValueGroup = Geographic2Dto3D.PARAMETERS.createValue();
            } else if (n == 3 && n2 == 2 && coordinateSystem2 instanceof EllipsoidalCS) {
                parameterValueGroup = Geographic3Dto2D.PARAMETERS.createValue();
            } else {
                parameterValueGroup = Affine.identity(n2);
                mathTransform = defaultMathTransformFactory.createCoordinateSystemChange(coordinateSystem, coordinateSystem2, (coordinateSystem instanceof EllipsoidalCS ? geodeticDatum : geodeticDatum2).getEllipsoid());
                mathTransformContext.setSource(coordinateSystem2);
                operationMethod = defaultMathTransformFactory.getLastMethodUsed();
            }
        }
        MathTransform mathTransform3 = defaultMathTransformFactory.createParameterizedTransform(parameterValueGroup, mathTransformContext);
        if (operationMethod == null) {
            operationMethod = mathTransformContext.getMethodUsed();
        }
        if (mathTransform != null) {
            parameterValueGroup = null;
            mathTransform3 = defaultMathTransformFactory.createConcatenatedTransform(mathTransform, mathTransform3);
            if (mathTransform2 != null) {
                mathTransform3 = defaultMathTransformFactory.createConcatenatedTransform(mathTransform3, mathTransform2);
            }
        }
        Map<String, Object> map = CoordinateOperationFinder.properties(identifier);
        if (matrix instanceof AnnotatedMatrix) {
            map.put("coordinateOperationAccuracy", new PositionalAccuracy[]{((AnnotatedMatrix)matrix).accuracy});
        }
        return CoordinateOperationFinder.asList(this.createFromMathTransform(map, geodeticCRS, geodeticCRS2, mathTransform3, operationMethod, parameterValueGroup, null));
    }

    protected List<CoordinateOperation> createOperationStep(GeodeticCRS geodeticCRS, VerticalCRS verticalCRS) throws FactoryException {
        boolean bl;
        int n;
        IdentifiedObject identifiedObject;
        EllipsoidalCS ellipsoidalCS;
        CoordinateOperation coordinateOperation = null;
        CoordinateOperation coordinateOperation2 = null;
        CoordinateReferenceSystem coordinateReferenceSystem = geodeticCRS;
        CoordinateSystem coordinateSystem = coordinateReferenceSystem.getCoordinateSystem();
        if (!(coordinateSystem instanceof EllipsoidalCS) && !Utilities.equalsIgnoreMetadata(coordinateSystem, ellipsoidalCS = CommonCRS.WGS84.geographic3D().getCoordinateSystem())) {
            identifiedObject = this.factorySIS.getCRSFactory().createGeographicCRS(this.derivedFrom(geodeticCRS), geodeticCRS.getDatum(), ellipsoidalCS);
            coordinateOperation = this.createOperation(geodeticCRS, (CoordinateReferenceSystem)((Object)this.toAuthorityDefinition(GeographicCRS.class, identifiedObject)));
            coordinateReferenceSystem = coordinateOperation.getTargetCRS();
            coordinateSystem = coordinateReferenceSystem.getCoordinateSystem();
        }
        if ((n = AxisDirections.indexOfColinear(coordinateSystem, AxisDirection.UP)) < 0) {
            throw new OperationNotFoundException(CoordinateOperationFinder.notFoundMessage(geodeticCRS, verticalCRS));
        }
        identifiedObject = coordinateSystem.getAxis(n);
        VerticalCRS verticalCRS2 = verticalCRS;
        VerticalCS verticalCS = verticalCRS2.getCoordinateSystem();
        if (Utilities.equalsIgnoreMetadata(verticalCS.getAxis(0), identifiedObject)) {
            bl = ReferencingUtilities.isEllipsoidalHeight(verticalCRS2.getDatum());
        } else {
            verticalCRS2 = CommonCRS.Vertical.ELLIPSOIDAL.crs();
            verticalCS = verticalCRS2.getCoordinateSystem();
            bl = Utilities.equalsIgnoreMetadata(verticalCS.getAxis(0), identifiedObject);
            if (!bl) {
                verticalCS = this.toAuthorityDefinition(VerticalCS.class, this.factorySIS.getCSFactory().createVerticalCS(this.derivedFrom(verticalCS), (CoordinateSystemAxis)identifiedObject));
            }
        }
        if (!bl) {
            verticalCRS2 = this.toAuthorityDefinition(VerticalCRS.class, this.factorySIS.getCRSFactory().createVerticalCRS(this.derivedFrom(verticalCRS2), CommonCRS.Vertical.ELLIPSOIDAL.datum(), verticalCS));
        }
        if (verticalCRS2 != verticalCRS) {
            coordinateOperation2 = this.createOperation(verticalCRS2, verticalCRS);
            verticalCRS2 = (VerticalCRS)coordinateOperation2.getSourceCRS();
            verticalCS = verticalCRS2.getCoordinateSystem();
        }
        int n2 = coordinateSystem.getDimension();
        int n3 = verticalCS.getDimension();
        MatrixSIS matrixSIS = Matrices.createZero(n3 + 1, n2 + 1);
        matrixSIS.setElement(0, n, 1.0);
        matrixSIS.setElement(n3, n2, 1.0);
        CoordinateOperation coordinateOperation3 = this.createFromAffineTransform(AXIS_CHANGES, coordinateReferenceSystem, verticalCRS2, matrixSIS);
        return CoordinateOperationFinder.asList(this.concatenate(coordinateOperation, coordinateOperation3, coordinateOperation2));
    }

    protected List<CoordinateOperation> createOperationStep(VerticalCRS verticalCRS, VerticalCRS verticalCRS2) throws FactoryException {
        Matrix matrix;
        VerticalDatum verticalDatum;
        VerticalDatum verticalDatum2 = verticalCRS.getDatum();
        if (!Utilities.equalsIgnoreMetadata(verticalDatum2, verticalDatum = verticalCRS2.getDatum())) {
            throw new OperationNotFoundException(CoordinateOperationFinder.notFoundMessage(verticalDatum2, verticalDatum));
        }
        VerticalCS verticalCS = verticalCRS.getCoordinateSystem();
        VerticalCS verticalCS2 = verticalCRS2.getCoordinateSystem();
        try {
            matrix = CoordinateSystems.swapAndScaleAxes(verticalCS, verticalCS2);
        }
        catch (IllegalArgumentException | IncommensurableException exception) {
            throw new OperationNotFoundException(CoordinateOperationFinder.notFoundMessage(verticalCRS, verticalCRS2), exception);
        }
        return CoordinateOperationFinder.asList(this.createFromAffineTransform(AXIS_CHANGES, verticalCRS, verticalCRS2, matrix));
    }

    protected List<CoordinateOperation> createOperationStep(TemporalCRS temporalCRS, TemporalCRS temporalCRS2) throws FactoryException {
        Matrix matrix;
        TemporalDatum temporalDatum = temporalCRS.getDatum();
        TemporalDatum temporalDatum2 = temporalCRS2.getDatum();
        TimeCS timeCS = temporalCRS.getCoordinateSystem();
        TimeCS timeCS2 = temporalCRS2.getCoordinateSystem();
        Unit<Time> unit = timeCS2.getAxis(0).getUnit().asType(Time.class);
        double d = temporalDatum.getOrigin().getTime() - temporalDatum2.getOrigin().getTime();
        d = Units.MILLISECOND.getConverterTo(unit).convert(d);
        try {
            matrix = CoordinateSystems.swapAndScaleAxes(timeCS, timeCS2);
        }
        catch (IllegalArgumentException | IncommensurableException exception) {
            throw new OperationNotFoundException(CoordinateOperationFinder.notFoundMessage(temporalCRS, temporalCRS2), exception);
        }
        int n = matrix.getNumCol() - 1;
        double d2 = matrix.getElement(0, n);
        matrix.setElement(0, n, d2 + d);
        return CoordinateOperationFinder.asList(this.createFromAffineTransform(AXIS_CHANGES, temporalCRS, temporalCRS2, matrix));
    }

    protected List<CoordinateOperation> createOperationStep(CoordinateReferenceSystem coordinateReferenceSystem, List<? extends SingleCRS> list, CoordinateReferenceSystem coordinateReferenceSystem2, List<? extends SingleCRS> list2) throws FactoryException {
        CoordinateOperation coordinateOperation;
        CoordinateReferenceSystem coordinateReferenceSystem3;
        SubOperationInfo[] subOperationInfoArray;
        try {
            subOperationInfoArray = SubOperationInfo.createSteps(this, list, list2);
        }
        catch (TransformException transformException) {
            throw new FactoryException(CoordinateOperationFinder.notFoundMessage(coordinateReferenceSystem, coordinateReferenceSystem2), transformException);
        }
        if (subOperationInfoArray == null) {
            throw new OperationNotFoundException(CoordinateOperationFinder.notFoundMessage(coordinateReferenceSystem, coordinateReferenceSystem2));
        }
        CoordinateReferenceSystem[] coordinateReferenceSystemArray = SubOperationInfo.getSourceCRS(subOperationInfoArray);
        MatrixSIS matrixSIS = SubOperationInfo.sourceToSelected(coordinateReferenceSystem.getCoordinateSystem().getDimension(), subOperationInfoArray);
        if (matrixSIS.isIdentity()) {
            coordinateReferenceSystem3 = coordinateReferenceSystem;
            coordinateOperation = null;
        } else {
            if (coordinateReferenceSystemArray.length == 1) {
                coordinateReferenceSystem3 = coordinateReferenceSystemArray[0];
            } else {
                CompoundCRS compoundCRS = this.factorySIS.getCRSFactory().createCompoundCRS(this.derivedFrom(coordinateReferenceSystem), coordinateReferenceSystemArray);
                coordinateReferenceSystem3 = this.toAuthorityDefinition(CoordinateReferenceSystem.class, compoundCRS);
            }
            coordinateOperation = this.createFromAffineTransform(AXIS_CHANGES, coordinateReferenceSystem, coordinateReferenceSystem3, matrixSIS);
        }
        int n = 0;
        int n2 = matrixSIS.getNumRow() - 1;
        int n3 = SubOperationInfo.indexOfFinal(subOperationInfoArray);
        for (int i = 0; i < coordinateReferenceSystemArray.length; ++i) {
            CoordinateReferenceSystem coordinateReferenceSystem4;
            SubOperationInfo subOperationInfo = subOperationInfoArray[i];
            CoordinateReferenceSystem coordinateReferenceSystem5 = coordinateReferenceSystemArray[i];
            coordinateReferenceSystemArray[subOperationInfo.targetComponentIndex] = coordinateReferenceSystem4 = (CoordinateReferenceSystem)list2.get(subOperationInfo.targetComponentIndex);
            CoordinateReferenceSystem coordinateReferenceSystem6 = i >= n3 ? coordinateReferenceSystem2 : (subOperationInfo.isIdentity() ? coordinateReferenceSystem3 : (coordinateReferenceSystemArray.length == 1 ? coordinateReferenceSystem4 : this.createCompoundCRS(coordinateReferenceSystem4, coordinateReferenceSystemArray)));
            int n4 = coordinateReferenceSystem5.getCoordinateSystem().getDimension();
            int n5 = n;
            int n6 = n2 - (n += n4);
            CoordinateOperation coordinateOperation2 = subOperationInfo.operation;
            if ((n5 | n6) != 0) {
                SingleOperation singleOperation;
                Map<String, ?> map = IdentifiedObjects.getProperties(coordinateOperation2, new String[0]);
                if (SubTypes.isSingleOperation(coordinateOperation2)) {
                    singleOperation = (SingleOperation)coordinateOperation2;
                } else {
                    MathTransform mathTransform = coordinateOperation2.getMathTransform();
                    singleOperation = this.factorySIS.createSingleOperation(map, coordinateOperation2.getSourceCRS(), coordinateOperation2.getTargetCRS(), null, new DefaultOperationMethod(mathTransform), mathTransform);
                }
                coordinateOperation2 = new DefaultPassThroughOperation(map, coordinateReferenceSystem3, coordinateReferenceSystem6, singleOperation, n5, n6);
            }
            coordinateOperation = this.concatenate(coordinateOperation, coordinateOperation2);
            coordinateReferenceSystem3 = coordinateReferenceSystem6;
            n -= (n4 -= coordinateReferenceSystem4.getCoordinateSystem().getDimension());
            n2 -= n4;
        }
        if (coordinateReferenceSystemArray.length < subOperationInfoArray.length) {
            MatrixSIS matrixSIS2 = SubOperationInfo.createConstantOperation(subOperationInfoArray, coordinateReferenceSystemArray.length, coordinateReferenceSystem3.getCoordinateSystem().getDimension(), coordinateReferenceSystem2.getCoordinateSystem().getDimension());
            coordinateOperation = this.concatenate(coordinateOperation, this.createFromAffineTransform(CONSTANTS, coordinateReferenceSystem3, coordinateReferenceSystem2, matrixSIS2));
        }
        return CoordinateOperationFinder.asList(coordinateOperation);
    }

    private CoordinateOperation createFromAffineTransform(Identifier identifier, CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, Matrix matrix) throws FactoryException {
        MathTransform mathTransform = this.factorySIS.getMathTransformFactory().createAffineTransform(matrix);
        return this.createFromMathTransform(CoordinateOperationFinder.properties(identifier), coordinateReferenceSystem, coordinateReferenceSystem2, mathTransform, null, null, null);
    }

    private CoordinateReferenceSystem createCompoundCRS(CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem[] coordinateReferenceSystemArray) throws FactoryException {
        EllipsoidalHeightCombiner ellipsoidalHeightCombiner = new EllipsoidalHeightCombiner(this.factorySIS.getCRSFactory(), this.factorySIS.getCSFactory(), this.factory);
        CoordinateReferenceSystem coordinateReferenceSystem2 = ellipsoidalHeightCombiner.createCompoundCRS(this.derivedFrom(coordinateReferenceSystem), coordinateReferenceSystemArray);
        return this.toAuthorityDefinition(CoordinateReferenceSystem.class, coordinateReferenceSystem2);
    }

    private CoordinateOperation concatenate(CoordinateOperation coordinateOperation, CoordinateOperation coordinateOperation2) throws FactoryException {
        Object object;
        if (CoordinateOperationFinder.isIdentity(coordinateOperation)) {
            return coordinateOperation2;
        }
        if (CoordinateOperationFinder.isIdentity(coordinateOperation2)) {
            return coordinateOperation;
        }
        MathTransform mathTransform = coordinateOperation.getMathTransform();
        MathTransform mathTransform2 = coordinateOperation2.getMathTransform();
        CoordinateReferenceSystem coordinateReferenceSystem = coordinateOperation.getSourceCRS();
        CoordinateReferenceSystem coordinateReferenceSystem2 = coordinateOperation2.getTargetCRS();
        CoordinateOperation coordinateOperation3 = null;
        boolean bl = CoordinateOperationFinder.canHide(coordinateOperation.getName());
        boolean bl2 = CoordinateOperationFinder.canHide(coordinateOperation2.getName());
        if (bl && bl2 && CoordinateOperationFinder.isAffine(coordinateOperation) && CoordinateOperationFinder.isAffine(coordinateOperation2)) {
            coordinateOperation3 = coordinateOperation2;
            if (coordinateOperation3.getName() == IDENTITY && coordinateOperation.getName() != IDENTITY) {
                coordinateOperation3 = coordinateOperation;
            }
        } else {
            if (bl && mathTransform.getSourceDimensions() == mathTransform.getTargetDimensions()) {
                coordinateOperation3 = coordinateOperation2;
            }
            if (bl2 && mathTransform2.getSourceDimensions() == mathTransform2.getTargetDimensions()) {
                coordinateOperation3 = coordinateOperation;
            }
        }
        if (SubTypes.isSingleOperation(coordinateOperation3)) {
            object = (SingleOperation)coordinateOperation3;
            MathTransform mathTransform3 = this.factorySIS.getMathTransformFactory().createConcatenatedTransform(mathTransform, mathTransform2);
            coordinateOperation3 = this.createFromMathTransform(new HashMap<String, Object>(IdentifiedObjects.getProperties(coordinateOperation3, new String[0])), coordinateReferenceSystem, coordinateReferenceSystem2, mathTransform3, object.getMethod(), object.getParameterValues(), coordinateOperation3 instanceof Transformation ? Transformation.class : (coordinateOperation3 instanceof Conversion ? Conversion.class : SingleOperation.class));
        } else {
            coordinateOperation3 = this.factory.createConcatenatedOperation(CoordinateOperationFinder.defaultName(coordinateReferenceSystem, coordinateReferenceSystem2), coordinateOperation, coordinateOperation2);
        }
        if (coordinateOperation3 instanceof ConcatenatedOperation && coordinateOperation3.getMathTransform().isIdentity()) {
            object = null;
            for (CoordinateOperation coordinateOperation4 : ((ConcatenatedOperation)coordinateOperation3).getOperations()) {
                if (!(coordinateOperation4 instanceof Transformation)) continue;
                object = Transformation.class;
                break;
            }
            coordinateOperation3 = this.createFromMathTransform(new HashMap<String, Object>(IdentifiedObjects.getProperties(coordinateOperation3, new String[0])), coordinateOperation3.getSourceCRS(), coordinateOperation3.getTargetCRS(), coordinateOperation3.getMathTransform(), null, null, (Class<? extends CoordinateOperation>)object);
        }
        return coordinateOperation3;
    }

    private CoordinateOperation concatenate(CoordinateOperation coordinateOperation, CoordinateOperation coordinateOperation2, CoordinateOperation coordinateOperation3) throws FactoryException {
        if (CoordinateOperationFinder.isIdentity(coordinateOperation)) {
            return this.concatenate(coordinateOperation2, coordinateOperation3);
        }
        if (CoordinateOperationFinder.isIdentity(coordinateOperation2)) {
            return this.concatenate(coordinateOperation, coordinateOperation3);
        }
        if (CoordinateOperationFinder.isIdentity(coordinateOperation3)) {
            return this.concatenate(coordinateOperation, coordinateOperation2);
        }
        if (CoordinateOperationFinder.canHide(coordinateOperation.getName())) {
            return this.concatenate(this.concatenate(coordinateOperation, coordinateOperation2), coordinateOperation3);
        }
        if (CoordinateOperationFinder.canHide(coordinateOperation3.getName())) {
            return this.concatenate(coordinateOperation, this.concatenate(coordinateOperation2, coordinateOperation3));
        }
        Map<String, ?> map = CoordinateOperationFinder.defaultName(coordinateOperation.getSourceCRS(), coordinateOperation3.getTargetCRS());
        return this.factory.createConcatenatedOperation(map, coordinateOperation, coordinateOperation2, coordinateOperation3);
    }

    private static boolean isAffine(CoordinateOperation coordinateOperation) {
        return coordinateOperation instanceof SingleOperation && IdentifiedObjects.isHeuristicMatchForName(((SingleOperation)coordinateOperation).getMethod(), "Affine");
    }

    private static boolean isIdentity(CoordinateOperation coordinateOperation) {
        if (coordinateOperation == null) {
            return true;
        }
        if (coordinateOperation instanceof Conversion && coordinateOperation.getMathTransform().isIdentity()) {
            return CoordinateOperations.wrapAroundChanges(coordinateOperation).isEmpty();
        }
        return false;
    }

    private static boolean canHide(Identifier identifier) {
        return identifier == AXIS_CHANGES || identifier == IDENTITY;
    }

    private static Map<String, ?> properties(String string) {
        return Collections.singletonMap("name", string);
    }

    private Map<String, ?> derivedFrom(IdentifiedObject identifiedObject) {
        Identifier identifier = identifiedObject.getName();
        Object object = this.identifierOfStepCRS.get(identifier);
        if (object instanceof Identifier) {
            identifier = (Identifier)object;
            object = this.identifierOfStepCRS.get(identifier);
        }
        int n = object != null ? (Integer)object + 1 : 1;
        NamedIdentifier namedIdentifier = new NamedIdentifier(Citations.SIS, identifier.getCode() + " (step " + n + ')');
        this.identifierOfStepCRS.put(namedIdentifier, identifier);
        this.identifierOfStepCRS.put(identifier, n);
        HashMap<String, Comparable<GenericName>> hashMap = new HashMap<String, Comparable<GenericName>>(4);
        hashMap.put("name", namedIdentifier);
        hashMap.put("remarks", Vocabulary.formatInternational((short)58, (Object)CRSPair.label(identifiedObject)));
        return hashMap;
    }

    private static Map<String, ?> defaultName(CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2) {
        return CoordinateOperationFinder.properties(new CRSPair(coordinateReferenceSystem, coordinateReferenceSystem2).toString());
    }

    private static List<CoordinateOperation> asList(CoordinateOperation coordinateOperation) {
        ArrayList<CoordinateOperation> arrayList = new ArrayList<CoordinateOperation>(1);
        arrayList.add(coordinateOperation);
        return arrayList;
    }

    private static String notFoundMessage(IdentifiedObject identifiedObject, IdentifiedObject identifiedObject2) {
        return Resources.format((short)13, CRSPair.label(identifiedObject), CRSPair.label(identifiedObject2));
    }

    private static String canNotInvert(GeneralDerivedCRS generalDerivedCRS) {
        return Resources.format((short)52, generalDerivedCRS.getConversionFromBase().getName().getCode());
    }
}

