/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.crs;

import java.util.Map;
import javax.measure.Unit;
import javax.measure.quantity.Angle;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.referencing.AxisDirections;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.internal.referencing.WKTUtilities;
import org.apache.sis.io.wkt.Convention;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.referencing.crs.AbstractCRS;
import org.apache.sis.referencing.crs.AbstractDerivedCRS;
import org.apache.sis.referencing.crs.ExplicitParameters;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.util.ComparisonMode;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.Projection;

@XmlType(name="ProjectedCRSType", propOrder={"baseCRS", "coordinateSystem"})
@XmlRootElement(name="ProjectedCRS")
public class DefaultProjectedCRS
extends AbstractDerivedCRS<Projection>
implements ProjectedCRS {
    private static final long serialVersionUID = -4502680112031773028L;

    public DefaultProjectedCRS(Map<String, ?> map, GeographicCRS geographicCRS, Conversion conversion, CartesianCS cartesianCS) throws MismatchedDimensionException {
        super(map, geographicCRS, conversion, cartesianCS);
    }

    protected DefaultProjectedCRS(ProjectedCRS projectedCRS) {
        super(projectedCRS);
    }

    public static DefaultProjectedCRS castOrCopy(ProjectedCRS projectedCRS) {
        return projectedCRS == null || projectedCRS instanceof DefaultProjectedCRS ? (DefaultProjectedCRS)projectedCRS : new DefaultProjectedCRS(projectedCRS);
    }

    @Override
    final Class<Projection> getConversionType() {
        return Projection.class;
    }

    @Override
    public Class<? extends ProjectedCRS> getInterface() {
        return ProjectedCRS.class;
    }

    @Override
    public GeodeticDatum getDatum() {
        return this.getBaseCRS().getDatum();
    }

    @Override
    @XmlElement(name="baseGeodeticCRS", required=true)
    public GeographicCRS getBaseCRS() {
        Projection projection = (Projection)super.getConversionFromBase();
        return projection != null ? (GeographicCRS)projection.getSourceCRS() : null;
    }

    @Override
    public Projection getConversionFromBase() {
        return (Projection)super.getConversionFromBase();
    }

    @Override
    @XmlElement(name="cartesianCS", required=true)
    public final CartesianCS getCoordinateSystem() {
        return (CartesianCS)super.getCoordinateSystem();
    }

    @Override
    public DefaultProjectedCRS forConvention(AxesConvention axesConvention) {
        return (DefaultProjectedCRS)super.forConvention(axesConvention);
    }

    @Override
    final AbstractCRS createSameType(Map<String, ?> map, CoordinateSystem coordinateSystem) {
        Projection projection = (Projection)super.getConversionFromBase();
        return new DefaultProjectedCRS(map, (GeographicCRS)projection.getSourceCRS(), (Conversion)projection, (CartesianCS)coordinateSystem);
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        return super.equals(object, comparisonMode);
    }

    @Override
    protected long computeHashCode() {
        return super.computeHashCode();
    }

    @Override
    protected String formatTo(Formatter formatter) {
        boolean bl;
        if (super.getConversionFromBase() == null) {
            return super.formatTo(formatter);
        }
        WKTUtilities.appendName(this, formatter, null);
        Convention convention = formatter.getConvention();
        boolean bl2 = convention.majorVersion() == 1;
        CartesianCS cartesianCS = this.getCoordinateSystem();
        GeographicCRS geographicCRS = this.getBaseCRS();
        Unit<?> unit = ReferencingUtilities.getUnit(cartesianCS);
        Unit<Angle> unit2 = AxisDirections.getAngularUnit(geographicCRS.getCoordinateSystem(), null);
        Unit<Angle> unit3 = formatter.addContextualUnit(unit2);
        Unit<?> unit4 = formatter.addContextualUnit(unit);
        formatter.newLine();
        formatter.append(WKTUtilities.toFormattable(geographicCRS));
        formatter.newLine();
        ExplicitParameters explicitParameters = new ExplicitParameters(this, "Conversion");
        if (bl2) {
            explicitParameters.append(formatter);
            bl = false;
        } else {
            formatter.append(explicitParameters);
            bl = DefaultProjectedCRS.isBaseCRS(formatter);
        }
        if (!bl || convention == Convention.INTERNAL) {
            this.formatCS(formatter, cartesianCS, unit, bl2);
        }
        formatter.restoreContextualUnit(unit, unit4);
        formatter.restoreContextualUnit(unit2, unit3);
        return bl2 ? "ProjCS" : (bl ? "BaseProjCRS" : formatter.shortOrLong("ProjCRS", "ProjectedCRS"));
    }

    private DefaultProjectedCRS() {
    }

    private void setBaseCRS(GeographicCRS geographicCRS) {
        this.setBaseCRS("baseGeodeticCRS", geographicCRS);
    }

    private void setCoordinateSystem(CartesianCS cartesianCS) {
        this.setCoordinateSystem("cartesianCS", cartesianCS);
    }
}

