/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.measure;

import java.util.Objects;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.measure.Range;
import org.apache.sis.measure.ValueRange;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.collection.WeakHashSet;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.TransformException;

public class NumberRange<E extends Number>
extends Range<E> {
    private static final long serialVersionUID = -3198281191274903617L;
    private static final WeakHashSet<NumberRange<?>> POOL = new WeakHashSet<NumberRange>(NumberRange.class);

    static <E extends Number, T extends NumberRange<E>> T unique(T t) {
        if (!t.isEmpty()) {
            t = POOL.unique(t);
        }
        return t;
    }

    static boolean isCacheable(Number number) {
        if (number == null) {
            return true;
        }
        if (number instanceof Double) {
            double d = (Double)number;
            return !Double.isNaN(d) || Double.doubleToRawLongBits(d) == 9221120237041090560L;
        }
        if (number instanceof Float) {
            float f = ((Float)number).floatValue();
            return !Float.isNaN(f) || Float.floatToRawIntBits(f) == 2143289344;
        }
        return Numbers.getEnumConstant(number.getClass()) != 0;
    }

    public static <N extends Number> NumberRange<N> create(Class<N> clazz, N n) {
        NumberRange<N> numberRange = new NumberRange<N>(clazz, n, true, n, true);
        if (NumberRange.isCacheable(n)) {
            numberRange = NumberRange.unique(numberRange);
        }
        return numberRange;
    }

    public static NumberRange<Byte> create(byte by, boolean bl, byte by2, boolean bl2) {
        return NumberRange.unique(new NumberRange<Byte>(Byte.class, by, bl, by2, bl2));
    }

    public static NumberRange<Short> create(short s, boolean bl, short s2, boolean bl2) {
        Short s3 = s;
        Short s4 = s == s2 ? s3 : s2;
        return NumberRange.unique(new NumberRange<Short>(Short.class, s3, bl, s4, bl2));
    }

    public static NumberRange<Integer> create(int n, boolean bl, int n2, boolean bl2) {
        Integer n3 = n;
        Integer n4 = n == n2 ? n3 : n2;
        return NumberRange.unique(new NumberRange<Integer>(Integer.class, n3, bl, n4, bl2));
    }

    public static NumberRange<Long> create(long l, boolean bl, long l2, boolean bl2) {
        Long l3 = l;
        Long l4 = l == l2 ? l3 : l2;
        return NumberRange.unique(new NumberRange<Long>(Long.class, l3, bl, l4, bl2));
    }

    public static NumberRange<Float> create(float f, boolean bl, float f2, boolean bl2) {
        Float f3;
        Float f4;
        return NumberRange.unique(new NumberRange<Float>(Float.class, f4, bl, Objects.equals(f4 = NumberRange.valueOf("minValue", f, Float.NEGATIVE_INFINITY), f3 = NumberRange.valueOf("maxValue", f2, Float.POSITIVE_INFINITY)) ? f4 : f3, bl2));
    }

    static Float valueOf(String string, float f, float f2) {
        if (Float.isNaN(f)) {
            throw new IllegalArgumentException(Errors.format((short)110, string));
        }
        return f != f2 ? Float.valueOf(f) : null;
    }

    public static NumberRange<Double> create(double d, boolean bl, double d2, boolean bl2) {
        Double d3;
        Double d4;
        return NumberRange.unique(new NumberRange<Double>(Double.class, d4, bl, Objects.equals(d4 = NumberRange.valueOf("minValue", d, Double.NEGATIVE_INFINITY), d3 = NumberRange.valueOf("maxValue", d2, Double.POSITIVE_INFINITY)) ? d4 : d3, bl2));
    }

    static Double valueOf(String string, double d, double d2) {
        if (Double.isNaN(d)) {
            throw new IllegalArgumentException(Errors.format((short)110, string));
        }
        return d != d2 ? Numerics.valueOf(d) : null;
    }

    public static NumberRange<?> createBestFit(Number number, boolean bl, Number number2, boolean bl2) {
        return NumberRange.createBestFit(false, number, bl, number2, bl2);
    }

    public static NumberRange<?> createBestFit(boolean bl, Number number, boolean bl2, Number number2, boolean bl3) {
        boolean bl4;
        Class<? extends Number> clazz;
        if (bl) {
            if (number == null && number2 == null) {
                return null;
            }
            clazz = NumberRange.isFloat(number) && NumberRange.isFloat(number2) ? Float.class : Double.class;
        } else {
            clazz = Numbers.widestClass(Numbers.narrowestClass(number), Numbers.narrowestClass(number2));
            if (clazz == null) {
                return null;
            }
        }
        Number number3 = Numbers.cast(number, clazz);
        Number number4 = Numbers.cast(number2, clazz);
        boolean bl5 = bl4 = NumberRange.isCacheable(number3) && NumberRange.isCacheable(number4);
        if (bl4 && Objects.equals(number3, number4)) {
            number4 = number3;
        }
        NumberRange<Number> numberRange = new NumberRange<Number>(clazz, number3, bl2, number4, bl3);
        if (bl4) {
            numberRange = NumberRange.unique(numberRange);
        }
        return numberRange;
    }

    private static boolean isFloat(Number number) {
        return number == null || Double.doubleToRawLongBits(number.floatValue()) == Double.doubleToRawLongBits(number.doubleValue());
    }

    public static NumberRange<Integer> createLeftBounded(int n, boolean bl) {
        return POOL.unique(new NumberRange<Object>((Class<Object>)Integer.class, n, bl, null, false));
    }

    public static <N extends Number> NumberRange<N> castOrCopy(Range<N> range) {
        if (range instanceof NumberRange) {
            return (NumberRange)range;
        }
        return new NumberRange<N>(range);
    }

    public NumberRange(Range<E> range) {
        super(range);
    }

    public NumberRange(Class<E> clazz, ValueRange valueRange) throws IllegalArgumentException {
        super(clazz, Numbers.cast(NumberRange.valueOf("minimum", valueRange.minimum(), Double.NEGATIVE_INFINITY), clazz), valueRange.isMinIncluded(), Numbers.cast(NumberRange.valueOf("maximum", valueRange.maximum(), Double.POSITIVE_INFINITY), clazz), valueRange.isMaxIncluded());
    }

    public NumberRange(Class<E> clazz, E e, boolean bl, E e2, boolean bl2) {
        super(clazz, e, bl, e2, bl2);
    }

    NumberRange(Class<E> clazz, Range<? extends Number> range) throws IllegalArgumentException {
        super(clazz, Numbers.cast((Number)range.minValue, clazz), range.isMinIncluded, Numbers.cast((Number)range.maxValue, clazz), range.isMaxIncluded);
    }

    @Override
    Range<E> create(E e, boolean bl, E e2, boolean bl2) {
        return new NumberRange<E>(this.elementType, e, bl, e2, bl2);
    }

    <N extends Number> NumberRange<N> convertAndCast(NumberRange<?> numberRange, Class<N> clazz) throws IllegalArgumentException {
        if (numberRange.elementType == clazz) {
            return numberRange;
        }
        return new NumberRange<N>(clazz, numberRange);
    }

    public <N extends Number> NumberRange<N> castTo(Class<N> clazz) throws IllegalArgumentException {
        if (this.elementType == clazz) {
            return this;
        }
        return new NumberRange<N>(clazz, this);
    }

    @Override
    Range<E>[] newArray(int n) {
        return new NumberRange[n];
    }

    public double getMinDouble() {
        Number number = (Number)this.getMinValue();
        return number != null ? number.doubleValue() : Double.NEGATIVE_INFINITY;
    }

    public double getMinDouble(boolean bl) {
        double d = this.getMinDouble();
        if (bl != this.isMinIncluded()) {
            d = NumberRange.next(this.getElementType(), d, bl);
        }
        return d;
    }

    public double getMaxDouble() {
        Number number = (Number)this.getMaxValue();
        return number != null ? number.doubleValue() : Double.POSITIVE_INFINITY;
    }

    public double getMaxDouble(boolean bl) {
        double d = this.getMaxDouble();
        if (bl != this.isMaxIncluded()) {
            d = NumberRange.next(this.getElementType(), d, !bl);
        }
        return d;
    }

    public double getMedian() {
        return this.medianOrSpan(true);
    }

    public double getSpan() {
        return this.medianOrSpan(false);
    }

    private double medianOrSpan(boolean bl) {
        if (this.minValue == null) {
            if (bl) {
                return this.maxValue == null ? Double.NaN : Double.NEGATIVE_INFINITY;
            }
            return Double.POSITIVE_INFINITY;
        }
        if (this.maxValue == null) {
            return Double.POSITIVE_INFINITY;
        }
        if (Numbers.isInteger(this.getElementType())) {
            long l = ((Number)((Object)this.minValue)).longValue();
            long l2 = ((Number)((Object)this.maxValue)).longValue();
            if (!this.isMinIncluded) {
                ++l;
            }
            if (!this.isMaxIncluded) {
                --l2;
            }
            if (l <= l2) {
                return bl ? MathFunctions.average(l, l2) : Numerics.toUnsignedDouble(l2 - l);
            }
        } else {
            double d;
            double d2 = ((Number)((Object)this.minValue)).doubleValue();
            if (d2 <= (d = ((Number)((Object)this.maxValue)).doubleValue())) {
                return bl ? (d2 + d) * 0.5 : d - d2;
            }
            if (Double.isNaN(d2) && (this.isMinIncluded || !Double.isNaN(d))) {
                return d2;
            }
            if (Double.isNaN(d)) {
                return d;
            }
        }
        return bl ? Double.NaN : 0.0;
    }

    private static double next(Class<?> clazz, double d, boolean bl) {
        if (Numbers.isInteger(clazz)) {
            d = bl ? (d += 1.0) : (d -= 1.0);
        } else if (clazz.equals(Float.class)) {
            float f = (float)d;
            d = bl ? (double)Math.nextUp(f) : (double)Math.nextDown(f);
        } else if (clazz.equals(Double.class)) {
            d = bl ? Math.nextUp(d) : Math.nextDown(d);
        } else {
            throw new IllegalStateException(Errors.format((short)111, clazz));
        }
        return d;
    }

    public boolean containsAny(Number number) throws IllegalArgumentException {
        int n;
        if (number == null) {
            return false;
        }
        Class<? extends Number> clazz = Numbers.widestClass(this.elementType, number.getClass());
        number = Numbers.cast(number, clazz);
        if (this.minValue != null) {
            n = ((Comparable)((Object)Numbers.cast((Number)((Object)this.minValue), clazz))).compareTo(number);
            if (this.isMinIncluded ? n > 0 : n >= 0) {
                return false;
            }
        }
        if (this.maxValue != null) {
            n = ((Comparable)((Object)Numbers.cast((Number)((Object)this.maxValue), clazz))).compareTo(number);
            if (this.isMaxIncluded ? n < 0 : n <= 0) {
                return false;
            }
        }
        return true;
    }

    public boolean containsAny(NumberRange<?> numberRange) throws IllegalArgumentException {
        Class<? extends Number> clazz = Numbers.widestClass(this.elementType, numberRange.elementType);
        return this.castTo(clazz).contains(this.convertAndCast(numberRange, clazz));
    }

    public boolean intersectsAny(NumberRange<?> numberRange) throws IllegalArgumentException {
        Class<? extends Number> clazz = Numbers.widestClass(this.elementType, numberRange.elementType);
        return this.castTo(clazz).intersects(this.convertAndCast(numberRange, clazz));
    }

    public NumberRange<?> intersectAny(NumberRange<?> numberRange) throws IllegalArgumentException {
        Class<? extends Number> clazz = Numbers.widestClass(this.elementType, numberRange.elementType);
        NumberRange<? extends Number> numberRange2 = NumberRange.castOrCopy(this.castTo(clazz).intersect(this.convertAndCast(numberRange, clazz)));
        clazz = Numbers.narrowestClass(this.elementType, numberRange.elementType);
        clazz = Numbers.widestClass(clazz, Numbers.narrowestClass((Number)((Object)numberRange2.minValue)));
        clazz = Numbers.widestClass(clazz, Numbers.narrowestClass((Number)((Object)numberRange2.maxValue)));
        return numberRange2.castTo(clazz);
    }

    public NumberRange<?> unionAny(NumberRange<?> numberRange) throws IllegalArgumentException {
        Class<? extends Number> clazz = Numbers.widestClass(this.elementType, numberRange.elementType);
        return NumberRange.castOrCopy(this.castTo(clazz).union(this.convertAndCast(numberRange, clazz)));
    }

    public NumberRange<?>[] subtractAny(NumberRange<?> numberRange) throws IllegalArgumentException {
        Class<? extends Number> clazz = Numbers.widestClass(this.elementType, numberRange.elementType);
        return (NumberRange[])this.castTo(clazz).subtract(this.convertAndCast(numberRange, clazz));
    }

    public NumberRange<?> transform(MathTransform1D mathTransform1D) throws TransformException {
        double d = this.getMinDouble();
        double d2 = this.getMaxDouble();
        double d3 = mathTransform1D.transform(d);
        double d4 = mathTransform1D.transform(d2);
        if (Double.doubleToLongBits(d3) != Double.doubleToLongBits(d) || Double.doubleToLongBits(d4) != Double.doubleToLongBits(d2)) {
            if (d3 > d4) {
                return NumberRange.create(d4, this.isMaxIncluded, d3, this.isMinIncluded);
            }
            return NumberRange.create(d3, this.isMinIncluded, d4, this.isMaxIncluded);
        }
        return this;
    }
}

