/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image;

import java.awt.Shape;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.DoubleUnaryOperator;
import org.apache.sis.coverage.Category;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.image.ImageAdapter;
import org.apache.sis.image.ImageProcessor;
import org.apache.sis.internal.coverage.j2d.ColorModelFactory;
import org.apache.sis.internal.coverage.j2d.ImageUtilities;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.math.Statistics;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.resources.Errors;

final class RecoloredImage
extends ImageAdapter {
    private final ColorModel colors;
    final double minimum;
    final double maximum;

    private RecoloredImage(RenderedImage renderedImage, ColorModel colorModel, double d, double d2) {
        super(renderedImage);
        this.colors = colorModel;
        this.minimum = d;
        this.maximum = d2;
    }

    static RenderedImage applySameColors(RenderedImage renderedImage, RenderedImage renderedImage2) {
        RecoloredImage recoloredImage;
        ColorModel colorModel = renderedImage2.getColorModel();
        if (colorModel == null) {
            return renderedImage;
        }
        RecoloredImage recoloredImage2 = null;
        while (renderedImage2 instanceof ImageAdapter) {
            if (renderedImage2 instanceof RecoloredImage) {
                recoloredImage2 = (RecoloredImage)renderedImage2;
                break;
            }
            renderedImage2 = ((ImageAdapter)renderedImage2).source;
        }
        while (true) {
            if (colorModel.equals(renderedImage.getColorModel())) {
                if (recoloredImage2 != null && renderedImage instanceof RecoloredImage) {
                    recoloredImage = (RecoloredImage)renderedImage;
                    if (!Numerics.equals(recoloredImage2.minimum, recoloredImage.minimum) || !Numerics.equals(recoloredImage2.maximum, recoloredImage.maximum)) continue;
                }
                return renderedImage;
            }
            if (!(renderedImage instanceof RecoloredImage)) break;
            renderedImage = ((RecoloredImage)renderedImage).source;
        }
        recoloredImage = recoloredImage2 != null ? new RecoloredImage(renderedImage, colorModel, recoloredImage2.minimum, recoloredImage2.maximum) : new RecoloredImage(renderedImage, colorModel, Double.NaN, Double.NaN);
        return ImageProcessor.unique(recoloredImage);
    }

    static RenderedImage stretchColorRamp(ImageProcessor imageProcessor, RenderedImage renderedImage, Map<String, ?> map) {
        ColorModel colorModel;
        Object object;
        DoubleUnaryOperator[] doubleUnaryOperatorArray;
        int n = ImageUtilities.getVisibleBand(renderedImage);
        if (n < 0) {
            return renderedImage;
        }
        RenderedImage renderedImage2 = renderedImage;
        Statistics[] statisticsArray = null;
        Statistics statistics = null;
        Shape shape = null;
        Number[] numberArray = null;
        SampleDimension sampleDimension = null;
        double d = Double.NaN;
        double d2 = Double.NaN;
        double d3 = Double.POSITIVE_INFINITY;
        if (map != null) {
            doubleUnaryOperatorArray = Containers.property(map, "minimum", Number.class);
            object = Containers.property(map, "maximum", Number.class);
            if (doubleUnaryOperatorArray != null) {
                d = doubleUnaryOperatorArray.doubleValue();
            }
            if (object != null) {
                d2 = ((Number)object).doubleValue();
            }
            if (d >= d2) {
                throw new IllegalArgumentException(Errors.format((short)60, doubleUnaryOperatorArray, object));
            }
            Number number = Containers.property(map, "multStdDev", Number.class);
            if (number != null) {
                d3 = number.doubleValue();
                ArgumentChecks.ensureStrictlyPositive("multStdDev", d3);
            }
            shape = Containers.property(map, "areaOfInterest", Shape.class);
            number = map.get("nodataValues");
            if (number != null) {
                if (number instanceof Number) {
                    numberArray = new Number[]{number};
                } else if (number instanceof Number[]) {
                    numberArray = (Number[])number;
                } else {
                    throw RecoloredImage.illegalPropertyType(map, "nodataValues", number);
                }
            }
            if ((number = map.get("statistics")) != null) {
                if (number instanceof RenderedImage) {
                    renderedImage2 = (RenderedImage)((Object)number);
                } else if (number instanceof Statistics) {
                    statistics = (Statistics)((Object)number);
                } else if (number instanceof Statistics[]) {
                    statisticsArray = (Statistics[])number;
                } else {
                    throw RecoloredImage.illegalPropertyType(map, "statistics", number);
                }
            }
            if ((number = map.get("sampleDimensions")) != null) {
                List list;
                if (number instanceof List && n < (list = (List)((Object)number)).size()) {
                    number = list.get(n);
                }
                if (number != null) {
                    if (number instanceof SampleDimension) {
                        sampleDimension = (SampleDimension)((Object)number);
                    } else {
                        throw RecoloredImage.illegalPropertyType(map, "sampleDimensions", number);
                    }
                }
            }
        }
        if (Double.isNaN(d) || Double.isNaN(d2)) {
            if (statistics == null) {
                if (statisticsArray == null) {
                    doubleUnaryOperatorArray = new DoubleUnaryOperator[n + 1];
                    doubleUnaryOperatorArray[n] = imageProcessor.filterNodataValues(numberArray);
                    statisticsArray = imageProcessor.valueOfStatistics(renderedImage2, shape, doubleUnaryOperatorArray);
                }
                if (statisticsArray != null && n < statisticsArray.length) {
                    statistics = statisticsArray[n];
                }
            }
            if (statistics != null) {
                d3 *= statistics.standardDeviation(true);
                double d4 = statistics.mean();
                if (Double.isNaN(d)) {
                    d = Math.max(statistics.minimum(), d4 - d3);
                }
                if (Double.isNaN(d2)) {
                    d2 = Math.min(statistics.maximum(), d4 + d3);
                }
            }
        }
        if (!(d < d2)) {
            return renderedImage;
        }
        if (renderedImage.getColorModel() instanceof IndexColorModel) {
            object = (IndexColorModel)renderedImage.getColorModel();
            int n2 = ((IndexColorModel)object).getMapSize();
            int n3 = 0;
            int n4 = n2 - 1;
            if (sampleDimension != null) {
                double d5 = 0.0;
                for (Category category : sampleDimension.getCategories()) {
                    if (!category.isQuantitative()) continue;
                    NumberRange<?> numberRange = category.getSampleRange();
                    double d6 = Math.max(numberRange.getMinDouble(true), 0.0);
                    double d7 = Math.min(numberRange.getMaxDouble(true), (double)(n2 - 1));
                    double d8 = Math.min(d7, d2) - Math.max(d6, d);
                    if (!(d8 > d5)) continue;
                    n3 = (int)d6;
                    n4 = (int)d7;
                    d5 = d8;
                }
            }
            int n5 = Math.max((int)d, n3);
            int n6 = Math.min((int)d2, n4);
            Object object2 = new int[n2];
            ((IndexColorModel)object).getRGBs((int[])object2);
            Arrays.fill((int[])object2, n3, n5, ((IndexColorModel)object).getRGB(n3));
            Arrays.fill((int[])object2, n6 + 1, n4 + 1, ((IndexColorModel)object).getRGB(n4));
            float f = (float)((double)(n4 - n3) / (d2 - d));
            for (int i = n5; i <= n6; ++i) {
                float f2 = (float)(i - n5) * f + (float)n3;
                object2[i] = ((IndexColorModel)object).getRGB(Math.round(f2));
            }
            SampleModel sampleModel = renderedImage.getSampleModel();
            colorModel = ColorModelFactory.createIndexColorModel(sampleModel.getNumBands(), n, (int[])object2, ((ColorModel)object).hasAlpha(), ((IndexColorModel)object).getTransparentPixel());
        } else {
            object = renderedImage.getSampleModel();
            colorModel = ColorModelFactory.createGrayScale(((SampleModel)object).getDataType(), ((SampleModel)object).getNumBands(), n, d, d2);
        }
        while (true) {
            if (colorModel.equals(renderedImage.getColorModel())) {
                if (renderedImage instanceof RecoloredImage) {
                    object = (RecoloredImage)renderedImage;
                    if (((RecoloredImage)object).minimum != d || ((RecoloredImage)object).maximum != d2) continue;
                }
                return renderedImage;
            }
            if (!(renderedImage instanceof RecoloredImage)) break;
            renderedImage = ((RecoloredImage)renderedImage).source;
        }
        return ImageProcessor.unique(new RecoloredImage(renderedImage, colorModel, d, d2));
    }

    private static IllegalArgumentException illegalPropertyType(Map<String, ?> map, String string, Object object) {
        return new IllegalArgumentException(Errors.getResources(map).getString((short)58, string, object.getClass()));
    }

    @Override
    public ColorModel getColorModel() {
        return this.colors;
    }

    @Override
    public boolean equals(Object object) {
        if (super.equals(object)) {
            RecoloredImage recoloredImage = (RecoloredImage)object;
            return Numerics.equals(this.minimum, recoloredImage.minimum) && Numerics.equals(this.maximum, recoloredImage.maximum) && this.colors.equals(recoloredImage.colors);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + 37 * this.colors.hashCode();
    }

    final Class<RecoloredImage> appendStringContent(StringBuilder stringBuilder) {
        stringBuilder.append(this.colors.getColorSpace());
        return RecoloredImage.class;
    }
}

