/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RasterFormatException;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.util.Objects;
import java.util.Vector;
import org.apache.sis.image.ErrorHandler;
import org.apache.sis.image.ImageProcessor;
import org.apache.sis.image.PlanarImage;
import org.apache.sis.internal.coverage.j2d.ImageUtilities;
import org.apache.sis.internal.coverage.j2d.TileErrorHandler;
import org.apache.sis.internal.coverage.j2d.TileOpExecutor;
import org.apache.sis.internal.coverage.j2d.TilePlaceholder;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Disposable;
import org.apache.sis.util.resources.Errors;

final class PrefetchedImage
extends PlanarImage
implements TileErrorHandler.Executor {
    final RenderedImage source;
    private final int minTileX;
    private final int minTileY;
    private final int numXTiles;
    private final int numYTiles;
    private final Raster[] tiles;
    private volatile TilePlaceholder placeholderPixels;
    private ErrorHandler.Report errorReport;

    PrefetchedImage(RenderedImage renderedImage, Rectangle rectangle, ErrorHandler errorHandler, boolean bl) {
        this.source = renderedImage;
        if (rectangle != null) {
            rectangle = new Rectangle(rectangle);
            ImageUtilities.clipBounds(renderedImage, rectangle);
            if (rectangle.isEmpty()) {
                this.minTileX = 0;
                this.minTileY = 0;
                this.numXTiles = 0;
                this.numYTiles = 0;
                this.tiles = null;
                return;
            }
        }
        Worker worker = new Worker(renderedImage, rectangle);
        Rectangle rectangle2 = worker.getTileIndices();
        this.minTileX = rectangle2.x;
        this.minTileY = rectangle2.y;
        this.numXTiles = rectangle2.width;
        this.numYTiles = rectangle2.height;
        this.tiles = new Raster[Math.multiplyExact(this.numYTiles, this.numXTiles)];
        worker.setErrorHandler(errorHandler, ImageProcessor.class, "prefetch");
        Disposable disposable = renderedImage instanceof PlanarImage ? ((PlanarImage)renderedImage).prefetch(rectangle2) : null;
        try {
            if (bl) {
                worker.parallelReadFrom(renderedImage);
            } else {
                worker.readFrom(renderedImage);
            }
        }
        finally {
            if (disposable != null) {
                disposable.dispose();
            }
        }
        for (int i = 0; i < this.tiles.length; ++i) {
            if (this.tiles[i] != null) continue;
            int n = i % this.numXTiles + this.minTileX;
            int n2 = i / this.numXTiles + this.minTileY;
            this.tiles[i] = this.createPlaceholder(n, n2);
        }
    }

    final boolean isEmpty() {
        return (this.numXTiles | this.numYTiles) == 0;
    }

    @Override
    public Vector<RenderedImage> getSources() {
        Vector<RenderedImage> vector = new Vector<RenderedImage>(1);
        vector.add(this.source);
        return vector;
    }

    @Override
    public Object getProperty(String string) {
        return this.source.getProperty(string);
    }

    @Override
    public String[] getPropertyNames() {
        return this.source.getPropertyNames();
    }

    @Override
    public ColorModel getColorModel() {
        return this.source.getColorModel();
    }

    @Override
    public SampleModel getSampleModel() {
        return this.source.getSampleModel();
    }

    @Override
    public int getWidth() {
        return this.source.getWidth();
    }

    @Override
    public int getHeight() {
        return this.source.getHeight();
    }

    @Override
    public int getMinX() {
        return this.source.getMinX();
    }

    @Override
    public int getMinY() {
        return this.source.getMinY();
    }

    @Override
    public int getNumXTiles() {
        return this.source.getNumXTiles();
    }

    @Override
    public int getNumYTiles() {
        return this.source.getNumYTiles();
    }

    @Override
    public int getMinTileX() {
        return this.source.getMinTileX();
    }

    @Override
    public int getMinTileY() {
        return this.source.getMinTileY();
    }

    @Override
    public int getTileWidth() {
        return this.source.getTileWidth();
    }

    @Override
    public int getTileHeight() {
        return this.source.getTileHeight();
    }

    @Override
    public int getTileGridXOffset() {
        return this.source.getTileGridXOffset();
    }

    @Override
    public int getTileGridYOffset() {
        return this.source.getTileGridYOffset();
    }

    @Override
    public Raster getTile(int n, int n2) {
        int n3;
        int n4 = Math.subtractExact(n, this.minTileX);
        if (n4 >= 0 && n < this.numXTiles && (n3 = Math.subtractExact(n2, this.minTileY)) >= 0 && n2 < this.numYTiles) {
            return this.tiles[n4 + n3 * this.numXTiles];
        }
        try {
            return this.source.getTile(n, n2);
        }
        catch (RuntimeException runtimeException) {
            ErrorHandler.Report report = this.errorReport;
            if (report == null) {
                throw runtimeException;
            }
            report.add(new Point(n, n2), runtimeException, null);
            assert (Thread.holdsLock(this));
            return this.createPlaceholder(n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void execute(Runnable runnable, TileErrorHandler tileErrorHandler) {
        ArgumentChecks.ensureNonNull("action", runnable);
        ArgumentChecks.ensureNonNull("errorHandler", tileErrorHandler);
        this.errorReport = new ErrorHandler.Report();
        try {
            runnable.run();
        }
        finally {
            ErrorHandler.Report report = this.errorReport;
            this.errorReport = null;
            tileErrorHandler.publish(report);
        }
    }

    private Raster createPlaceholder(int n, int n2) {
        TilePlaceholder tilePlaceholder = this.placeholderPixels;
        if (tilePlaceholder == null) {
            this.placeholderPixels = tilePlaceholder = TilePlaceholder.withCross(this.source);
        }
        return tilePlaceholder.create(new Point(ImageUtilities.tileToPixelX(this.source, n), ImageUtilities.tileToPixelY(this.source, n2)));
    }

    public int hashCode() {
        return Objects.hash(this.source, this.minTileX, this.minTileY, this.numXTiles, this.numYTiles);
    }

    public boolean equals(Object object) {
        if (object instanceof PrefetchedImage) {
            PrefetchedImage prefetchedImage = (PrefetchedImage)object;
            return this.source.equals(prefetchedImage.source) && this.minTileX == prefetchedImage.minTileX && this.minTileY == prefetchedImage.minTileY && this.numXTiles == prefetchedImage.numXTiles && this.numYTiles == prefetchedImage.numYTiles;
        }
        return false;
    }

    private final class Worker
    extends TileOpExecutor {
        private final long tileWidth;
        private final long tileHeight;
        private final long tileGridXOffset;
        private final long tileGridYOffset;

        Worker(RenderedImage renderedImage, Rectangle rectangle) {
            super(renderedImage, rectangle);
            this.tileWidth = renderedImage.getTileWidth();
            this.tileHeight = renderedImage.getTileHeight();
            this.tileGridXOffset = renderedImage.getTileGridXOffset();
            this.tileGridYOffset = renderedImage.getTileGridYOffset();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void readFrom(Raster raster) {
            long l = Math.floorDiv((long)raster.getMinX() - this.tileGridXOffset, this.tileWidth) - (long)PrefetchedImage.this.minTileX;
            long l2 = Math.floorDiv((long)raster.getMinY() - this.tileGridYOffset, this.tileHeight) - (long)PrefetchedImage.this.minTileY;
            assert (l >= 0L && l < (long)PrefetchedImage.this.numXTiles) : l;
            assert (l2 >= 0L && l2 < (long)PrefetchedImage.this.numYTiles) : l2;
            int n = Math.toIntExact(l + l2 * (long)PrefetchedImage.this.numXTiles);
            Raster[] rasterArray = PrefetchedImage.this.tiles;
            synchronized (rasterArray) {
                if (PrefetchedImage.this.tiles[n] != null) {
                    throw new RasterFormatException(Errors.format((short)24, "Tile[" + l + ", " + l2 + ']'));
                }
                ((PrefetchedImage)PrefetchedImage.this).tiles[n] = raster;
            }
        }
    }
}

