/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.services.pageload;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.apache.tapestry5.commons.services.PlasticProxyFactory;
import org.apache.tapestry5.internal.plastic.PlasticClassLoader;
import org.apache.tapestry5.plastic.PlasticManager;
import org.apache.tapestry5.plastic.PlasticUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageClassLoaderContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(PageClassLoaderContext.class);
    private final String name;
    private final PageClassLoaderContext parent;
    private final Set<String> classNames = new HashSet<String>();
    private final Set<PageClassLoaderContext> children;
    private final PlasticManager plasticManager;
    private final PlasticProxyFactory proxyFactory;
    private PageClassLoaderContext root;
    private final Function<String, PageClassLoaderContext> provider;
    public static final String UNKOWN_CONTEXT_NAME = "unknown";

    public PageClassLoaderContext(String name, PageClassLoaderContext parent, Set<String> classNames, PlasticProxyFactory plasticProxyFactory, Function<String, PageClassLoaderContext> provider) {
        this.name = name;
        this.parent = parent;
        this.classNames.addAll(classNames);
        this.plasticManager = plasticProxyFactory.getPlasticManager();
        this.proxyFactory = plasticProxyFactory;
        this.provider = provider;
        this.children = new HashSet<PageClassLoaderContext>();
        if (plasticProxyFactory.getClassLoader() instanceof PlasticClassLoader) {
            PlasticClassLoader plasticClassLoader = (PlasticClassLoader)this.plasticManager.getClassLoader();
            plasticClassLoader.setTag(name);
            plasticClassLoader.setFilter(this::filter);
            plasticClassLoader.setAlternativeClassloading(this::alternativeClassLoading);
            if (parent != null) {
                this.getPlasticManager().getPool().setParent(parent.getPlasticManager().getPool());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> alternativeClassLoading(String className) {
        Class clasz;
        block8: {
            clasz = null;
            this.setRootFieldIfNeeded();
            PageClassLoaderContext context = this.root.findByClassName(PlasticUtils.getEnclosingClassName((String)className));
            if (this.isRoot() && context == null) {
                context = this;
            }
            if (context != null) {
                try {
                    PlasticClassLoader classLoader;
                    PlasticClassLoader plasticClassLoader = classLoader = (PlasticClassLoader)context.getClassLoader();
                    synchronized (plasticClassLoader) {
                        classLoader.setAlternativeClassloading(null);
                        clasz = classLoader.loadClass(className);
                        classLoader.setAlternativeClassloading(this::alternativeClassLoading);
                        break block8;
                    }
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            if (this.root.getPlasticManager().shouldInterceptClassLoading(className)) {
                context = this.provider.apply(className);
            }
        }
        return clasz;
    }

    private void setRootFieldIfNeeded() {
        if (this.root == null) {
            if (this.isRoot()) {
                this.root = this;
            } else {
                this.root = this;
                while (!this.root.isRoot()) {
                    this.root = this.root.getParent();
                }
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public PageClassLoaderContext getParent() {
        return this.parent;
    }

    public Set<String> getClassNames() {
        return this.classNames;
    }

    public Set<PageClassLoaderContext> getChildren() {
        return this.children;
    }

    public PlasticManager getPlasticManager() {
        return this.plasticManager;
    }

    public PlasticProxyFactory getProxyFactory() {
        return this.proxyFactory;
    }

    public void addClass(String className) {
        this.classNames.add(className);
    }

    public void addChild(PageClassLoaderContext context) {
        this.children.add(context);
    }

    public void removeChild(PageClassLoaderContext context) {
        this.children.remove(context);
    }

    public PageClassLoaderContext findByClassName(String className) {
        PageClassLoaderContext context = null;
        if (this.classNames.contains(className)) {
            context = this;
        } else {
            PageClassLoaderContext child;
            Iterator<PageClassLoaderContext> iterator = this.children.iterator();
            while (iterator.hasNext() && (context = (child = iterator.next()).findByClassName(className)) == null) {
            }
        }
        return context;
    }

    public ClassLoader getClassLoader() {
        return this.proxyFactory.getClassLoader();
    }

    public void invalidate() {
        for (PageClassLoaderContext child : new ArrayList<PageClassLoaderContext>(this.children)) {
            child.invalidate();
        }
        LOGGER.debug("Invalidating page classloader context '{}' (class loader {}, classes : {})", new Object[]{this.name, this.proxyFactory.getClassLoader(), this.classNames});
        this.parent.getChildren().remove(this);
        this.proxyFactory.clearCache();
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public boolean isUnknown() {
        return this.name.equals(UNKOWN_CONTEXT_NAME);
    }

    public Set<PageClassLoaderContext> getDescendents() {
        Set<PageClassLoaderContext> descendents;
        if (this.children.isEmpty()) {
            descendents = Collections.emptySet();
        } else {
            descendents = new HashSet<PageClassLoaderContext>(this.children);
            for (PageClassLoaderContext child : this.children) {
                descendents.addAll(child.getDescendents());
            }
        }
        return descendents;
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PageClassLoaderContext)) {
            return false;
        }
        PageClassLoaderContext other = (PageClassLoaderContext)obj;
        return Objects.equals(this.name, other.name);
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeClassNames) {
        PlasticClassLoader classLoader = (PlasticClassLoader)this.proxyFactory.getClassLoader();
        return "PageClassloaderContext [name=" + this.name + ", parent=" + (this.parent != null ? this.parent.getName() : "null") + ", classLoader=" + PageClassLoaderContext.afterAt(classLoader.getClassLoaderId()) + (this.isRoot() || !includeClassNames ? "" : ", classNames=" + this.classNames) + "]";
    }

    public String toRecursiveString() {
        return this.toRecursiveString(true);
    }

    public String toRecursiveString(boolean outputClasses) {
        StringBuilder builder = new StringBuilder();
        this.toRecursiveString(builder, "", outputClasses);
        return builder.toString();
    }

    public final boolean isEqualOrAncestor(PageClassLoaderContext dependencyContext) {
        boolean equalOrAncestor = this.equals(dependencyContext);
        if (!equalOrAncestor) {
            for (PageClassLoaderContext parent = this.getParent(); parent != null && !equalOrAncestor && !(equalOrAncestor = parent.equals(dependencyContext)); parent = parent.getParent()) {
            }
        }
        return equalOrAncestor;
    }

    private void toRecursiveString(StringBuilder builder, String tabs, boolean outputClasses) {
        builder.append(tabs);
        builder.append(this.name);
        builder.append(" : ");
        builder.append(PageClassLoaderContext.afterAt(this.proxyFactory.getClassLoader().toString()));
        if (outputClasses) {
            builder.append(" : ");
            builder.append(this.classNames);
        }
        builder.append("\n");
        for (PageClassLoaderContext child : this.children) {
            child.toRecursiveString(builder, tabs + "\t", outputClasses);
        }
    }

    private static String afterAt(String string) {
        int index = string.indexOf(64);
        if (index > 0) {
            string = string.substring(index + 1);
        }
        return string;
    }

    private boolean filter(String className) {
        int index = className.indexOf("$");
        if (index > 0) {
            className = className.substring(0, index);
        }
        return this.classNames.contains(className) || className.contains(".base.") || this.isUnknown();
    }
}

