/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services.ajax;

import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.ValidationTracker;
import org.apache.tapestry5.ValidationTrackerImpl;
import org.apache.tapestry5.corelib.internal.ComponentActionSink;
import org.apache.tapestry5.corelib.internal.HiddenFieldPositioner;
import org.apache.tapestry5.corelib.internal.InternalFormSupport;
import org.apache.tapestry5.internal.services.ajax.AjaxFormUpdateController;
import org.apache.tapestry5.internal.util.CaptureResultCallback;
import org.apache.tapestry5.ioc.annotations.Scope;
import org.apache.tapestry5.ioc.util.IdAllocator;
import org.apache.tapestry5.runtime.Component;
import org.apache.tapestry5.services.ClientDataEncoder;
import org.apache.tapestry5.services.ComponentSource;
import org.apache.tapestry5.services.Environment;
import org.apache.tapestry5.services.FormSupport;
import org.apache.tapestry5.services.Heartbeat;
import org.apache.tapestry5.services.HiddenFieldLocationRules;
import org.slf4j.Logger;

@Scope(value="perthread")
public class AjaxFormUpdateControllerImpl
implements AjaxFormUpdateController {
    private final ComponentSource componentSource;
    private final HiddenFieldLocationRules rules;
    private final Environment environment;
    private final Heartbeat heartbeat;
    private final ClientDataEncoder clientDataEncoder;
    private final Logger logger;
    private String formComponentId;
    private String formClientId;
    private HiddenFieldPositioner hiddenFieldPositioner;
    private ComponentActionSink actionSink;
    private InternalFormSupport formSupport;

    public AjaxFormUpdateControllerImpl(ComponentSource componentSource, HiddenFieldLocationRules rules, Environment environment, Heartbeat heartbeat, ClientDataEncoder clientDataEncoder, Logger logger) {
        this.componentSource = componentSource;
        this.rules = rules;
        this.environment = environment;
        this.heartbeat = heartbeat;
        this.clientDataEncoder = clientDataEncoder;
        this.logger = logger;
    }

    @Override
    public void initializeForForm(String formComponentId, String formClientId) {
        this.formComponentId = formComponentId;
        this.formClientId = formClientId;
    }

    @Override
    public void setupBeforePartialZoneRender(MarkupWriter writer) {
        if (this.formComponentId == null) {
            return;
        }
        this.hiddenFieldPositioner = new HiddenFieldPositioner(writer, this.rules);
        this.actionSink = new ComponentActionSink(this.logger, this.clientDataEncoder);
        this.formSupport = this.createInternalFormSupport(this.formClientId, this.formComponentId, this.actionSink);
        this.environment.push(FormSupport.class, this.formSupport);
        this.environment.push(ValidationTracker.class, new ValidationTrackerImpl());
        this.heartbeat.begin();
    }

    @Override
    public void cleanupAfterPartialZoneRender() {
        if (this.formComponentId == null) {
            return;
        }
        this.heartbeat.end();
        this.formSupport.executeDeferred();
        this.environment.pop(ValidationTracker.class);
        this.environment.pop(FormSupport.class);
        if (this.actionSink.isEmpty()) {
            this.hiddenFieldPositioner.discard();
            return;
        }
        this.hiddenFieldPositioner.getElement().attributes("type", "hidden", "name", "t:formdata", "value", this.actionSink.getClientData());
    }

    private InternalFormSupport createInternalFormSupport(String formClientId, String formComponentId, ComponentActionSink actionSink) {
        String uid = Long.toHexString(System.nanoTime());
        IdAllocator idAllocator = new IdAllocator("_" + uid);
        Component formComponent = this.componentSource.getComponent(formComponentId);
        CaptureResultCallback callback = CaptureResultCallback.create();
        formComponent.getComponentResources().triggerEvent("internalCreateRenderTimeFormSupport", new Object[]{formClientId, actionSink, idAllocator}, callback);
        return (InternalFormSupport)callback.getResult();
    }
}

