/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.hibernate;

import java.lang.reflect.Method;
import org.apache.tapestry5.hibernate.HibernateSessionManager;
import org.apache.tapestry5.hibernate.HibernateTransactionAdvisor;
import org.apache.tapestry5.hibernate.annotations.CommitAfter;
import org.apache.tapestry5.ioc.MethodAdviceReceiver;
import org.apache.tapestry5.plastic.MethodAdvice;
import org.apache.tapestry5.plastic.MethodInvocation;

public class HibernateTransactionAdvisorImpl
implements HibernateTransactionAdvisor {
    private final HibernateSessionManager manager;
    private final MethodAdvice advice = new MethodAdvice(){

        public void advise(MethodInvocation invocation) {
            try {
                invocation.proceed();
            }
            catch (RuntimeException ex) {
                HibernateTransactionAdvisorImpl.this.manager.abort();
                throw ex;
            }
            HibernateTransactionAdvisorImpl.this.manager.commit();
        }
    };

    public HibernateTransactionAdvisorImpl(HibernateSessionManager manager) {
        this.manager = manager;
    }

    @Override
    public void addTransactionCommitAdvice(MethodAdviceReceiver receiver) {
        for (Method m : receiver.getInterface().getMethods()) {
            if (m.getAnnotation(CommitAfter.class) == null) continue;
            receiver.adviseMethod(m, this.advice);
        }
    }
}

