/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import javax.servlet.http.HttpServletRequest;
import org.apache.tapestry5.ContentType;
import org.apache.tapestry5.internal.TapestryInternalUtils;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.services.ResponseCompressionAnalyzer;
import org.apache.tapestry5.services.assets.CompressionAnalyzer;

public class ResponseCompressionAnalyzerImpl
implements ResponseCompressionAnalyzer {
    private final HttpServletRequest request;
    private final boolean gzipCompressionEnabled;
    private final CompressionAnalyzer compressionAnalyzer;

    public ResponseCompressionAnalyzerImpl(HttpServletRequest request, @Symbol(value="tapestry.gzip-compression-enabled") boolean gzipCompressionEnabled, CompressionAnalyzer compressionAnalyzer) {
        this.request = request;
        this.gzipCompressionEnabled = gzipCompressionEnabled;
        this.compressionAnalyzer = compressionAnalyzer;
    }

    @Override
    public boolean isGZipSupported() {
        if (!this.gzipCompressionEnabled) {
            return false;
        }
        if (this.request.getProtocol() == "HTTP/1.0") {
            return false;
        }
        if (this.request.getAttribute("tapestry.supress-compression") != null) {
            return false;
        }
        String supportedEncodings = this.request.getHeader("Accept-Encoding");
        if (supportedEncodings == null) {
            return false;
        }
        for (String encoding : TapestryInternalUtils.splitAtCommas(supportedEncodings)) {
            if (!encoding.equalsIgnoreCase("gzip")) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isGZipEnabled(ContentType contentType) {
        return this.isGZipSupported() && this.compressionAnalyzer.isCompressable(contentType.getMimeType());
    }
}

