/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.protocolrecords.impl.pb;

import java.util.List;
import java.util.Map;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.hadoop.thirdparty.protobuf.MessageOrBuilder;
import org.apache.hadoop.thirdparty.protobuf.TextFormat;
import org.apache.hadoop.yarn.api.protocolrecords.NodePublishVolumeRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ValidateVolumeCapabilitiesRequest;
import org.apache.hadoop.yarn.api.records.impl.pb.ProtoUtils;
import org.apache.hadoop.yarn.proto.CsiAdaptorProtos;
import org.apache.hadoop.yarn.proto.YarnProtos;

public class NodePublishVolumeRequestPBImpl
extends NodePublishVolumeRequest {
    private CsiAdaptorProtos.NodePublishVolumeRequest.Builder builder;

    public NodePublishVolumeRequestPBImpl() {
        this.builder = CsiAdaptorProtos.NodePublishVolumeRequest.newBuilder();
    }

    public NodePublishVolumeRequestPBImpl(CsiAdaptorProtos.NodePublishVolumeRequest request) {
        this.builder = request.toBuilder();
    }

    public CsiAdaptorProtos.NodePublishVolumeRequest getProto() {
        Preconditions.checkNotNull((Object)this.builder);
        return this.builder.build();
    }

    public void setVolumeId(String volumeId) {
        Preconditions.checkNotNull((Object)this.builder);
        this.builder.setVolumeId(volumeId);
    }

    public String getVolumeId() {
        Preconditions.checkNotNull((Object)this.builder);
        return this.builder.getVolumeId();
    }

    public void setReadonly(boolean readonly) {
        Preconditions.checkNotNull((Object)this.builder);
        this.builder.setReadonly(readonly);
    }

    public boolean getReadOnly() {
        Preconditions.checkNotNull((Object)this.builder);
        return this.builder.getReadonly();
    }

    public void setSecrets(Map<String, String> secrets) {
        if (secrets != null) {
            Preconditions.checkNotNull((Object)this.builder);
            for (Map.Entry<String, String> entry : secrets.entrySet()) {
                YarnProtos.StringStringMapProto mapEntry = YarnProtos.StringStringMapProto.newBuilder().setKey(entry.getKey()).setValue(entry.getValue()).build();
                this.builder.addSecrets(mapEntry);
            }
        }
    }

    public Map<String, String> getSecrets() {
        Preconditions.checkNotNull((Object)this.builder);
        return this.builder.getSecretsCount() > 0 ? ProtoUtils.convertStringStringMapProtoListToMap(this.builder.getSecretsList()) : ImmutableMap.of();
    }

    public String getTargetPath() {
        Preconditions.checkNotNull((Object)this.builder);
        return this.builder.getTargetPath();
    }

    public void setStagingPath(String stagingPath) {
        Preconditions.checkNotNull((Object)this.builder);
        this.builder.setStagingTargetPath(stagingPath);
    }

    public String getStagingPath() {
        Preconditions.checkNotNull((Object)this.builder);
        return this.builder.getStagingTargetPath();
    }

    public void setPublishContext(Map<String, String> publishContext) {
        if (publishContext != null) {
            Preconditions.checkNotNull((Object)this.builder);
            for (Map.Entry<String, String> entry : publishContext.entrySet()) {
                YarnProtos.StringStringMapProto mapEntry = YarnProtos.StringStringMapProto.newBuilder().setKey(entry.getKey()).setValue(entry.getValue()).build();
                this.builder.addPublishContext(mapEntry);
            }
        }
    }

    public Map<String, String> getPublishContext() {
        Preconditions.checkNotNull((Object)this.builder);
        return this.builder.getPublishContextCount() > 0 ? ProtoUtils.convertStringStringMapProtoListToMap(this.builder.getPublishContextList()) : ImmutableMap.of();
    }

    public void setTargetPath(String targetPath) {
        if (targetPath != null) {
            Preconditions.checkNotNull((Object)this.builder);
            this.builder.setTargetPath(targetPath);
        }
    }

    public void setVolumeCapability(ValidateVolumeCapabilitiesRequest.VolumeCapability capability) {
        if (capability != null) {
            CsiAdaptorProtos.VolumeCapability vc = CsiAdaptorProtos.VolumeCapability.newBuilder().setAccessMode(CsiAdaptorProtos.VolumeCapability.AccessMode.forNumber((int)capability.getAccessMode().ordinal())).setVolumeType(CsiAdaptorProtos.VolumeCapability.VolumeType.forNumber((int)capability.getVolumeType().ordinal())).addAllMountFlags((Iterable)capability.getMountFlags()).build();
            this.builder.setVolumeCapability(vc);
        }
    }

    public ValidateVolumeCapabilitiesRequest.VolumeCapability getVolumeCapability() {
        CsiAdaptorProtos.VolumeCapability cap0 = this.builder.getVolumeCapability();
        if (this.builder.hasVolumeCapability()) {
            return new ValidateVolumeCapabilitiesRequest.VolumeCapability(ValidateVolumeCapabilitiesRequest.AccessMode.valueOf((String)cap0.getAccessMode().name()), ValidateVolumeCapabilitiesRequest.VolumeType.valueOf((String)cap0.getVolumeType().name()), (List)cap0.getMountFlagsList());
        }
        return null;
    }

    public String toString() {
        return TextFormat.shortDebugString((MessageOrBuilder)this.getProto());
    }

    public int hashCode() {
        return this.getProto().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(((Object)((Object)this)).getClass())) {
            return this.getProto().equals((Object)((NodePublishVolumeRequestPBImpl)((Object)((Object)((Object)this)).getClass().cast(other))).getProto());
        }
        return false;
    }
}

