/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.meta;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.EnumUtils;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.sysds.api.DMLScript;
import org.apache.sysds.common.Types;
import org.apache.sysds.parser.BooleanIdentifier;
import org.apache.sysds.parser.ConstIdentifier;
import org.apache.sysds.parser.DataExpression;
import org.apache.sysds.parser.DataIdentifier;
import org.apache.sysds.parser.DoubleIdentifier;
import org.apache.sysds.parser.Expression;
import org.apache.sysds.parser.LanguageException;
import org.apache.sysds.parser.ParseException;
import org.apache.sysds.parser.ParseInfo;
import org.apache.sysds.parser.StringIdentifier;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.caching.CacheableData;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.runtime.meta.DataCharacteristics;
import org.apache.sysds.runtime.meta.MatrixCharacteristics;
import org.apache.sysds.runtime.privacy.PrivacyConstraint;
import org.apache.sysds.runtime.privacy.propagation.PrivacyPropagator;
import org.apache.sysds.runtime.util.HDFSTool;
import org.apache.sysds.utils.JSONHelper;
import org.apache.wink.json4j.JSONArray;
import org.apache.wink.json4j.JSONException;
import org.apache.wink.json4j.JSONObject;

public class MetaDataAll
extends DataIdentifier {
    private JSONObject _metaObj;
    protected String _formatTypeString;
    protected String _fineGrainedPrivacy;
    protected String _schema;
    protected String _delim = ",";
    protected boolean _hasHeader = false;
    protected boolean _sparseDelim = false;

    public MetaDataAll() {
    }

    public MetaDataAll(String meta) {
        try {
            this._metaObj = new JSONObject(meta);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        this.setPrivacy(PrivacyConstraint.PrivacyLevel.None);
        this.parseMetaDataParams();
    }

    public MetaDataAll(BufferedReader br) {
        try {
            this._metaObj = JSONHelper.parse(br);
        }
        catch (Exception e) {
            throw new DMLRuntimeException(e);
        }
        this.setPrivacy(PrivacyConstraint.PrivacyLevel.None);
        this.parseMetaDataParams();
    }

    public MetaDataAll(String mtdFileName, boolean conditional, boolean parseMeta) {
        this.setFilename(mtdFileName);
        this._metaObj = this.readMetadataFile(mtdFileName, conditional);
        this.setPrivacy(PrivacyConstraint.PrivacyLevel.None);
        if (parseMeta) {
            this.parseMetaDataParams();
        }
    }

    public JSONObject readMetadataFile(String filename, boolean conditional) {
        boolean isDir;
        JSONObject retVal = new JSONObject();
        boolean exists = HDFSTool.existsFileOnHDFS(filename);
        boolean bl = isDir = exists ? HDFSTool.isDirectory(filename) : false;
        if (exists && isDir) {
            for (FileStatus stat : HDFSTool.getDirectoryListing(filename)) {
                Path childPath = stat.getPath();
                if (!childPath.getName().startsWith("part")) continue;
                try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)IOUtilFunctions.getFileSystem(childPath).open(childPath)));){
                    JSONObject childObj = JSONHelper.parse(br);
                    Iterator iterator = childObj.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry obj;
                        Map.Entry e = obj = iterator.next();
                        Object key = e.getKey();
                        Object val = e.getValue();
                        retVal.put(key, val);
                    }
                }
                catch (IOException e) {
                    this.raiseValidateError("for MTD file in directory, error parting part of MTD file with path " + childPath.toString() + ": " + e.getMessage(), conditional);
                }
            }
        } else if (exists) {
            Path path = new Path(filename);
            try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)IOUtilFunctions.getFileSystem(path).open(path)));){
                retVal = new JSONObject(br);
            }
            catch (Exception e) {
                this.raiseValidateError("error parsing MTD file with path " + filename + ": " + e.getMessage(), conditional);
            }
        }
        return retVal;
    }

    private void parseMetaDataParams() {
        Iterator iterator = this._metaObj.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry obj;
            Map.Entry e = obj = iterator.next();
            Object key = e.getKey();
            Object val = e.getValue();
            boolean isValidName = DataExpression.READ_VALID_MTD_PARAM_NAMES.contains(key);
            if (!isValidName) {
                this.raiseValidateError("MTD file contains invalid parameter name: " + key, false);
            }
            this.parseMetaDataParam(key, val);
        }
        if (this._format == null) {
            this.setFormatTypeString(null);
        }
    }

    private void parseMetaDataParam(Object key, Object val) {
        switch (key.toString()) {
            case "rows": {
                this._dim1 = val instanceof Long ? (Long)val : (long)((Integer)val).intValue();
                break;
            }
            case "cols": {
                this._dim2 = val instanceof Long ? (Long)val : (long)((Integer)val).intValue();
                break;
            }
            case "rows_in_block": {
                this.setBlocksize((Integer)val);
                break;
            }
            case "nnz": {
                this.setNnz(val instanceof Long ? (Long)val : (long)((Integer)val).intValue());
                break;
            }
            case "format": {
                this.setFormatTypeString((String)val);
                break;
            }
            case "data_type": {
                this.setDataType(Types.DataType.valueOf(((String)val).toUpperCase()));
                break;
            }
            case "value_type": {
                this.setValueType(Types.ValueType.fromExternalString((String)val));
                break;
            }
            case "privacy": {
                this.setPrivacy(PrivacyConstraint.PrivacyLevel.valueOf((String)val));
                break;
            }
            case "fine_grained_privacy": {
                this.setFineGrainedPrivacy(val.toString());
                break;
            }
            case "sep": {
                this.setDelim(val.toString());
                break;
            }
            case "schema": {
                this.setSchema(val.toString());
                break;
            }
            case "header": {
                if (val instanceof Boolean) {
                    boolean valB = (Boolean)val;
                    this.setHasHeader(valB);
                    break;
                }
                this.setHasHeader(false);
                break;
            }
            case "sparse": {
                this.setSparseDelim((Boolean)val);
            }
        }
    }

    public boolean mtdExists() {
        return this._metaObj != null && !this._metaObj.isEmpty();
    }

    public CacheableData<?> parseAndSetPrivacyConstraint(CacheableData<?> cd) throws JSONException {
        return (CacheableData)PrivacyPropagator.parseAndSetPrivacyConstraint(cd, this._metaObj);
    }

    public String getFormatTypeString() {
        return this._formatTypeString;
    }

    public String getFineGrainedPrivacy() {
        return this._fineGrainedPrivacy;
    }

    public String getDelim() {
        return this._delim;
    }

    public String getSchema() {
        return this._schema;
    }

    public boolean getHasHeader() {
        return this._hasHeader;
    }

    public boolean getSparseDelim() {
        return this._sparseDelim;
    }

    public void setSparseDelim(boolean sparseDelim) {
        this._sparseDelim = sparseDelim;
    }

    public void setHasHeader(boolean hasHeader) {
        this._hasHeader = hasHeader;
    }

    public void setFineGrainedPrivacy(String fineGrainedPrivacy) {
        this._fineGrainedPrivacy = fineGrainedPrivacy;
    }

    public void setSchema(String schema) {
        this._schema = schema;
    }

    public void setDelim(String delim) {
        if (delim.length() == 0) {
            throw new RuntimeException("Invalid metadata delim, cannot be empty string");
        }
        this._delim = delim;
    }

    public void setFormatTypeString(String format) {
        String string = this._formatTypeString = this._formatTypeString != null && format == null && this._metaObj != null ? (String)JSONHelper.get(this._metaObj, "format") : format;
        if (this._formatTypeString != null && EnumUtils.isValidEnum(Types.FileFormat.class, (String)this._formatTypeString.toUpperCase())) {
            this.setFileFormat(Types.FileFormat.safeValueOf(this._formatTypeString));
        }
    }

    public DataCharacteristics getDataCharacteristics() {
        return new MatrixCharacteristics(this.getDim1(), this.getDim2(), this.getBlocksize(), this.getNnz());
    }

    public HashMap<String, Expression> parseMetaDataFileParameters(String mtdFileName, boolean conditional, HashMap<String, Expression> varParams) {
        Iterator iterator = this._metaObj.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry obj;
            Map.Entry e = obj = iterator.next();
            Object key = e.getKey();
            Object val = e.getValue();
            boolean isValidName = DataExpression.READ_VALID_MTD_PARAM_NAMES.contains(key);
            if (!isValidName) {
                this.raiseValidateError("MTD file " + mtdFileName + " contains invalid parameter name: " + key, false);
            }
            this.parseMetaDataParam(key, val);
            if (varParams.get(key.toString()) != null && varParams.get(key.toString()) instanceof ConstIdentifier && !varParams.get(key.toString()).toString().equalsIgnoreCase(val.toString())) {
                this.raiseValidateError("Parameter '" + key.toString() + "' has conflicting values in metadata and read statement. MTD file value: '" + val.toString() + "'. Read statement value: '" + varParams.get(key.toString()) + "'.", conditional);
            } else if (!(varParams.get(key.toString()) != null || key.toString().equalsIgnoreCase("description") || key.toString().equalsIgnoreCase("author") || key.toString().equalsIgnoreCase("created"))) {
                StringIdentifier strId = new StringIdentifier(val.toString(), this);
                if (key.toString().equalsIgnoreCase("header") || key.toString().equalsIgnoreCase("fill") || key.toString().equalsIgnoreCase("sparse")) {
                    BooleanIdentifier boolId = null;
                    if (strId.toString().equalsIgnoreCase("true")) {
                        boolId = new BooleanIdentifier(true, this);
                    } else if (strId.toString().equalsIgnoreCase("false")) {
                        boolId = new BooleanIdentifier(false, this);
                    } else {
                        this.raiseValidateError("Invalid value provided for 'header' in metadata file '" + mtdFileName + "'. Must be either TRUE or FALSE.", conditional);
                    }
                    varParams.remove(key.toString());
                    this.addVarParam(key.toString(), boolId, varParams);
                    switch (key.toString().toUpperCase()) {
                        default: 
                    }
                } else if (key.toString().equalsIgnoreCase("default")) {
                    DoubleIdentifier doubleId = new DoubleIdentifier(Double.parseDouble(strId.toString()), (ParseInfo)this);
                    varParams.remove(key.toString());
                    this.addVarParam(key.toString(), doubleId, varParams);
                } else if (key.toString().equalsIgnoreCase("naStrings") || key.toString().equalsIgnoreCase("privacy") || key.toString().equalsIgnoreCase("fine_grained_privacy")) {
                    String naStrings = null;
                    if (val instanceof String) {
                        naStrings = val.toString();
                    } else if (val instanceof JSONArray) {
                        StringBuilder sb = new StringBuilder();
                        JSONArray valarr = (JSONArray)val;
                        for (int naid = 0; naid < valarr.size(); ++naid) {
                            sb.append((String)valarr.get(naid));
                            if (naid >= valarr.size() - 1) continue;
                            sb.append("\u00b7");
                        }
                        naStrings = sb.toString();
                    } else if (val instanceof JSONObject) {
                        JSONObject valJsonObject = (JSONObject)val;
                        naStrings = valJsonObject.toString();
                    } else {
                        throw new ParseException("Type of value " + val + " from metadata not recognized by parser.");
                    }
                    StringIdentifier sid = new StringIdentifier(naStrings, this);
                    varParams.remove(key.toString());
                    this.addVarParam(key.toString(), sid, varParams);
                } else {
                    this.addVarParam(key.toString(), strId, varParams);
                }
            }
            if (this._format != null) continue;
            this.setFormatTypeString(null);
        }
        return varParams;
    }

    public void addVarParam(String name, Expression value, HashMap<String, Expression> varParams) {
        if (DMLScript.VALIDATOR_IGNORE_ISSUES && value == null) {
            return;
        }
        varParams.put(name, value);
        this.setFilename(value.getFilename());
        if (this.getBeginLine() == 0) {
            this.setBeginLine(value.getBeginLine());
        }
        if (this.getBeginColumn() == 0) {
            this.setBeginColumn(value.getBeginColumn());
        }
        if (this.getEndLine() == 0) {
            this.setEndLine(value.getEndLine());
        }
        if (this.getEndColumn() == 0) {
            this.setEndColumn(value.getEndColumn());
        }
        if (this.getText() == null) {
            this.setText(value.getText());
        }
    }

    public static String checkHasDelimitedFormat(String filename, boolean conditional) {
        MetaDataAll mtdObject = new MetaDataAll(filename + ".mtd", conditional, false);
        if (mtdObject.mtdExists()) {
            try {
                mtdObject.setFormatTypeString((String)mtdObject._metaObj.get("format"));
                if (Types.FileFormat.isDelimitedFormat(mtdObject.getFormatTypeString())) {
                    return mtdObject.getFormatTypeString();
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static boolean checkHasMatrixMarketFormat(String inputFileName, String mtdFileName, boolean conditional) {
        MetaDataAll mtdObject = new MetaDataAll(mtdFileName, conditional, false);
        if (mtdObject.mtdExists()) {
            return false;
        }
        if (HDFSTool.existsFileOnHDFS(inputFileName) && !HDFSTool.isDirectory(inputFileName)) {
            boolean bl;
            Path path = new Path(inputFileName);
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)IOUtilFunctions.getFileSystem(path).open(path)));
            try {
                String headerLine = new String("");
                if (in.ready()) {
                    headerLine = in.readLine();
                }
                bl = headerLine != null && headerLine.startsWith("%%");
            }
            catch (Throwable throwable) {
                try {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    throw new LanguageException("Failed to read matrix market header.", ex);
                }
            }
            in.close();
            return bl;
        }
        return false;
    }

    @Override
    public String toString() {
        return "MetaDataAll\n" + this._metaObj + "\n" + super.toString();
    }
}

