/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.fed;

import org.apache.sysds.runtime.controlprogram.caching.CacheableData;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.instructions.Instruction;
import org.apache.sysds.runtime.instructions.cp.AggregateBinaryCPInstruction;
import org.apache.sysds.runtime.instructions.cp.AggregateTernaryCPInstruction;
import org.apache.sysds.runtime.instructions.cp.BinaryCPInstruction;
import org.apache.sysds.runtime.instructions.cp.CtableCPInstruction;
import org.apache.sysds.runtime.instructions.cp.Data;
import org.apache.sysds.runtime.instructions.cp.MMChainCPInstruction;
import org.apache.sysds.runtime.instructions.cp.MMTSJCPInstruction;
import org.apache.sysds.runtime.instructions.cp.MultiReturnParameterizedBuiltinCPInstruction;
import org.apache.sysds.runtime.instructions.cp.ParameterizedBuiltinCPInstruction;
import org.apache.sysds.runtime.instructions.cp.QuaternaryCPInstruction;
import org.apache.sysds.runtime.instructions.cp.SpoofCPInstruction;
import org.apache.sysds.runtime.instructions.cp.TernaryCPInstruction;
import org.apache.sysds.runtime.instructions.cp.UnaryCPInstruction;
import org.apache.sysds.runtime.instructions.cp.VariableCPInstruction;
import org.apache.sysds.runtime.instructions.fed.AggregateBinaryFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.AggregateTernaryFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.BinaryFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.CastFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.CtableFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.FEDInstruction;
import org.apache.sysds.runtime.instructions.fed.MMChainFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.MultiReturnParameterizedBuiltinFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.ParameterizedBuiltinFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.QuaternaryFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.SpoofFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.TernaryFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.TsmmFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.UnaryFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.VariableFEDInstruction;
import org.apache.sysds.runtime.instructions.spark.AggregateTernarySPInstruction;
import org.apache.sysds.runtime.instructions.spark.BinarySPInstruction;
import org.apache.sysds.runtime.instructions.spark.CastSPInstruction;
import org.apache.sysds.runtime.instructions.spark.CtableSPInstruction;
import org.apache.sysds.runtime.instructions.spark.MultiReturnParameterizedBuiltinSPInstruction;
import org.apache.sysds.runtime.instructions.spark.ParameterizedBuiltinSPInstruction;
import org.apache.sysds.runtime.instructions.spark.QuaternarySPInstruction;
import org.apache.sysds.runtime.instructions.spark.SpoofSPInstruction;
import org.apache.sysds.runtime.instructions.spark.TernarySPInstruction;
import org.apache.sysds.runtime.instructions.spark.UnarySPInstruction;
import org.apache.sysds.runtime.instructions.spark.WriteSPInstruction;

public class FEDInstructionUtils {
    public static boolean noFedRuntimeConversion = false;

    public static Instruction checkAndReplaceCP(Instruction inst, ExecutionContext ec) {
        if (noFedRuntimeConversion) {
            return inst;
        }
        FEDInstruction fedinst = null;
        if (inst instanceof AggregateBinaryCPInstruction) {
            fedinst = AggregateBinaryFEDInstruction.parseInstruction((AggregateBinaryCPInstruction)inst, ec);
        } else if (inst instanceof MMChainCPInstruction) {
            fedinst = MMChainFEDInstruction.parseInstruction((MMChainCPInstruction)inst, ec);
        } else if (inst instanceof MMTSJCPInstruction) {
            fedinst = TsmmFEDInstruction.parseInstruction((MMTSJCPInstruction)inst, ec);
        } else if (inst instanceof UnaryCPInstruction) {
            fedinst = UnaryFEDInstruction.parseInstruction((UnaryCPInstruction)inst, ec);
        } else if (inst instanceof BinaryCPInstruction) {
            fedinst = BinaryFEDInstruction.parseInstruction((BinaryCPInstruction)inst, ec);
        } else if (inst instanceof ParameterizedBuiltinCPInstruction) {
            fedinst = ParameterizedBuiltinFEDInstruction.parseInstruction((ParameterizedBuiltinCPInstruction)inst, ec);
        } else if (inst instanceof MultiReturnParameterizedBuiltinCPInstruction) {
            fedinst = MultiReturnParameterizedBuiltinFEDInstruction.parseInstruction((MultiReturnParameterizedBuiltinCPInstruction)inst, ec);
        } else if (inst instanceof TernaryCPInstruction) {
            fedinst = TernaryFEDInstruction.parseInstruction((TernaryCPInstruction)inst, ec);
        } else if (inst instanceof VariableCPInstruction) {
            fedinst = VariableFEDInstruction.parseInstruction((VariableCPInstruction)inst, ec);
        } else if (inst instanceof AggregateTernaryCPInstruction) {
            fedinst = AggregateTernaryFEDInstruction.parseInstruction((AggregateTernaryCPInstruction)inst, ec);
        } else if (inst instanceof QuaternaryCPInstruction) {
            fedinst = QuaternaryFEDInstruction.parseInstruction((QuaternaryCPInstruction)inst, ec);
        } else if (inst instanceof SpoofCPInstruction) {
            fedinst = SpoofFEDInstruction.parseInstruction((SpoofCPInstruction)inst, ec);
        } else if (inst instanceof CtableCPInstruction) {
            fedinst = CtableFEDInstruction.parseInstruction((CtableCPInstruction)inst, ec);
        }
        if (fedinst != null) {
            fedinst.setTID(ec.getTID());
            return fedinst;
        }
        return inst;
    }

    public static Instruction checkAndReplaceSP(Instruction inst, ExecutionContext ec) {
        if (noFedRuntimeConversion) {
            return inst;
        }
        FEDInstruction fedinst = null;
        if (inst instanceof CastSPInstruction) {
            fedinst = CastFEDInstruction.parseInstruction((CastSPInstruction)inst, ec);
        } else if (inst instanceof WriteSPInstruction) {
            WriteSPInstruction instruction = (WriteSPInstruction)inst;
            Data data = ec.getVariable(instruction.input1);
            if (data instanceof CacheableData && ((CacheableData)data).isFederated()) {
                return VariableCPInstruction.parseInstruction(instruction.getInstructionString());
            }
        } else if (inst instanceof QuaternarySPInstruction) {
            fedinst = QuaternaryFEDInstruction.parseInstruction((QuaternarySPInstruction)inst, ec);
        } else if (inst instanceof SpoofSPInstruction) {
            fedinst = SpoofFEDInstruction.parseInstruction((SpoofSPInstruction)inst, ec);
        } else if (inst instanceof UnarySPInstruction) {
            fedinst = UnaryFEDInstruction.parseInstruction((UnarySPInstruction)inst, ec);
        } else if (inst instanceof BinarySPInstruction) {
            fedinst = BinaryFEDInstruction.parseInstruction((BinarySPInstruction)inst, ec);
        } else if (inst instanceof ParameterizedBuiltinSPInstruction) {
            fedinst = ParameterizedBuiltinFEDInstruction.parseInstruction((ParameterizedBuiltinSPInstruction)inst, ec);
        } else if (inst instanceof MultiReturnParameterizedBuiltinSPInstruction) {
            fedinst = MultiReturnParameterizedBuiltinFEDInstruction.parseInstruction((MultiReturnParameterizedBuiltinSPInstruction)inst, ec);
        } else if (inst instanceof TernarySPInstruction) {
            fedinst = TernaryFEDInstruction.parseInstruction((TernarySPInstruction)inst, ec);
        } else if (inst instanceof AggregateTernarySPInstruction) {
            fedinst = AggregateTernaryFEDInstruction.parseInstruction((AggregateTernarySPInstruction)inst, ec);
        } else if (inst instanceof CtableSPInstruction) {
            fedinst = CtableFEDInstruction.parseInstruction((CtableSPInstruction)inst, ec);
        }
        if (fedinst != null) {
            fedinst.setTID(ec.getTID());
            return fedinst;
        }
        return inst;
    }
}

