/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.frame.data.columns;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.BitSet;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.frame.data.columns.Array;
import org.apache.sysds.runtime.frame.data.columns.ArrayFactory;
import org.apache.sysds.runtime.frame.data.columns.BitSetArray;
import org.apache.sysds.runtime.frame.data.columns.BooleanArray;
import org.apache.sysds.runtime.frame.data.columns.CharArray;
import org.apache.sysds.runtime.frame.data.columns.DoubleArray;
import org.apache.sysds.runtime.frame.data.columns.FloatArray;
import org.apache.sysds.runtime.frame.data.columns.HashLongArray;
import org.apache.sysds.runtime.frame.data.columns.LongArray;
import org.apache.sysds.runtime.frame.data.columns.OptionalArray;
import org.apache.sysds.runtime.frame.data.columns.StringArray;
import org.apache.sysds.runtime.matrix.data.Pair;
import org.apache.sysds.runtime.util.UtilFunctions;
import org.apache.sysds.utils.MemoryEstimates;

public class IntegerArray
extends Array<Integer> {
    private int[] _data;

    public IntegerArray(int[] data) {
        super(data.length);
        this._data = data;
    }

    public int[] get() {
        return this._data;
    }

    @Override
    public Integer get(int index) {
        return this._data[index];
    }

    @Override
    public void set(int index, Integer value) {
        this._data[index] = value != null ? value : 0;
    }

    @Override
    public void set(int index, double value) {
        this._data[index] = (int)value;
    }

    @Override
    public void set(int index, String value) {
        this.set(index, (double)IntegerArray.parseInt(value));
    }

    @Override
    public void set(int rl, int ru, Array<Integer> value) {
        this.set(rl, ru, value, 0);
    }

    @Override
    public void setFromOtherType(int rl, int ru, Array<?> value) {
        Types.ValueType vt = value.getValueType();
        for (int i = rl; i <= ru; ++i) {
            this._data[i] = UtilFunctions.objectToInteger(vt, value.get(i));
        }
    }

    @Override
    public void set(int rl, int ru, Array<Integer> value, int rlSrc) {
        try {
            System.arraycopy(value.get(), rlSrc, this._data, rl, ru - rl + 1);
        }
        catch (Exception e) {
            super.set(rl, ru, value, rlSrc);
        }
    }

    @Override
    public void setNz(int rl, int ru, Array<Integer> value) {
        int[] data2 = ((IntegerArray)value)._data;
        for (int i = rl; i <= ru; ++i) {
            if (data2[i] == 0) continue;
            this._data[i] = data2[i];
        }
    }

    @Override
    public void setFromOtherTypeNz(int rl, int ru, Array<?> value) {
        Types.ValueType vt = value.getValueType();
        for (int i = rl; i <= ru; ++i) {
            int v = UtilFunctions.objectToInteger(vt, value.get(i));
            if (v == 0) continue;
            this._data[i] = v;
        }
    }

    @Override
    public void append(String value) {
        this.append(IntegerArray.parseInt(value));
    }

    @Override
    public void append(Integer value) {
        if (this._data.length <= this._size) {
            this._data = Arrays.copyOf(this._data, this.newSize());
        }
        this._data[this._size++] = value != null ? value : 0;
    }

    @Override
    public Array<Integer> append(Array<Integer> other) {
        int endSize = this._size + other.size();
        int[] ret = new int[endSize];
        System.arraycopy(this._data, 0, ret, 0, this._size);
        System.arraycopy(other.get(), 0, ret, this._size, other.size());
        if (other instanceof OptionalArray) {
            return OptionalArray.appendOther((OptionalArray)other, new IntegerArray(ret));
        }
        return new IntegerArray(ret);
    }

    public void write(DataOutput out) throws IOException {
        out.writeByte(ArrayFactory.FrameArrayType.INT32.ordinal());
        for (int i = 0; i < this._size; ++i) {
            out.writeInt(this._data[i]);
        }
    }

    public void readFields(DataInput in) throws IOException {
        this._size = this._data.length;
        for (int i = 0; i < this._size; ++i) {
            this._data[i] = in.readInt();
        }
    }

    @Override
    public Array<Integer> clone() {
        return new IntegerArray(Arrays.copyOf(this._data, this._size));
    }

    @Override
    public Array<Integer> slice(int rl, int ru) {
        return new IntegerArray(Arrays.copyOfRange(this._data, rl, ru));
    }

    @Override
    public void reset(int size) {
        if (this._data.length < size || this._data.length > 2 * size) {
            this._data = new int[size];
        } else {
            for (int i = 0; i < size; ++i) {
                this._data[i] = 0;
            }
        }
        this._size = size;
    }

    @Override
    public byte[] getAsByteArray() {
        ByteBuffer intBuffer = ByteBuffer.allocate(4 * this._size);
        intBuffer.order(ByteOrder.LITTLE_ENDIAN);
        for (int i = 0; i < this._size; ++i) {
            intBuffer.putInt(this._data[i]);
        }
        return intBuffer.array();
    }

    @Override
    public Types.ValueType getValueType() {
        return Types.ValueType.INT32;
    }

    @Override
    public Pair<Types.ValueType, Boolean> analyzeValueType(int maxCells) {
        return new Pair<Types.ValueType, Boolean>(Types.ValueType.INT32, false);
    }

    @Override
    public ArrayFactory.FrameArrayType getFrameArrayType() {
        return ArrayFactory.FrameArrayType.INT32;
    }

    @Override
    public long getInMemorySize() {
        long size = super.getInMemorySize();
        size = (long)((double)size + MemoryEstimates.intArrayCost(this._data.length));
        return size;
    }

    @Override
    public long getExactSerializedSize() {
        return 1 + 4 * this._size;
    }

    @Override
    protected Array<Boolean> changeTypeBitSet() {
        BitSet ret = new BitSet(this.size());
        for (int i = 0; i < this.size(); ++i) {
            if (this._data[i] != 0 && this._data[i] != 1) {
                throw new DMLRuntimeException("Unable to change to Boolean from Integer array because of value:" + this._data[i]);
            }
            ret.set(i, this._data[i] != 0);
        }
        return new BitSetArray(ret, this.size());
    }

    @Override
    protected Array<Boolean> changeTypeBoolean() {
        boolean[] ret = new boolean[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            if (this._data[i] < 0 || this._data[i] > 1) {
                throw new DMLRuntimeException("Unable to change to Boolean from Integer array because of value:" + this._data[i]);
            }
            ret[i] = this._data[i] != 0;
        }
        return new BooleanArray(ret);
    }

    @Override
    protected Array<Double> changeTypeDouble() {
        double[] ret = new double[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            ret[i] = this._data[i];
        }
        return new DoubleArray(ret);
    }

    @Override
    protected Array<Float> changeTypeFloat() {
        float[] ret = new float[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            ret[i] = this._data[i];
        }
        return new FloatArray(ret);
    }

    @Override
    protected Array<Integer> changeTypeInteger() {
        return this;
    }

    @Override
    protected Array<Long> changeTypeLong() {
        long[] ret = new long[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            ret[i] = this._data[i];
        }
        return new LongArray(ret);
    }

    @Override
    protected Array<Object> changeTypeHash64() {
        long[] ret = new long[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            ret[i] = this._data[i];
        }
        return new HashLongArray(ret);
    }

    @Override
    protected Array<String> changeTypeString() {
        String[] ret = new String[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            ret[i] = this.get(i).toString();
        }
        return new StringArray(ret);
    }

    @Override
    public Array<Character> changeTypeCharacter() {
        char[] ret = new char[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            ret[i] = this.get(i).toString().charAt(0);
        }
        return new CharArray(ret);
    }

    @Override
    public void fill(String value) {
        this.fill(IntegerArray.parseInt(value));
    }

    @Override
    public void fill(Integer value) {
        value = value != null ? value : 0;
        Arrays.fill(this._data, value);
    }

    @Override
    public double getAsDouble(int i) {
        return this._data[i];
    }

    public static int parseInt(String s) {
        if (s == null || s.isEmpty()) {
            return 0;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            if (s.contains(".")) {
                return (int)Double.parseDouble(s);
            }
            throw e;
        }
    }

    @Override
    public boolean isShallowSerialize() {
        return true;
    }

    @Override
    public boolean isEmpty() {
        for (int i = 0; i < this._size; ++i) {
            if (this._data[i] == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public Array<Integer> select(int[] indices) {
        int[] ret = new int[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            ret[i] = this._data[indices[i]];
        }
        return new IntegerArray(ret);
    }

    @Override
    public Array<Integer> select(boolean[] select, int nTrue) {
        int[] ret = new int[nTrue];
        int k = 0;
        for (int i = 0; i < select.length; ++i) {
            if (!select[i]) continue;
            ret[k++] = this._data[i];
        }
        return new IntegerArray(ret);
    }

    @Override
    public final boolean isNotEmpty(int i) {
        return this._data[i] != 0;
    }

    @Override
    public double hashDouble(int idx) {
        return Integer.hashCode(this._data[idx]);
    }

    @Override
    public boolean equals(Array<Integer> other) {
        if (other instanceof IntegerArray) {
            return Arrays.equals(this._data, ((IntegerArray)other)._data);
        }
        return false;
    }

    @Override
    public boolean possiblyContainsNaN() {
        return false;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this._size * 5 + 2);
        sb.append(super.toString() + ":[");
        for (int i = 0; i < this._size - 1; ++i) {
            sb.append(this._data[i] + ",");
        }
        sb.append(this._data[this._size - 1]);
        sb.append("]");
        return sb.toString();
    }
}

