/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.DAGScheduler;
import org.apache.spark.scheduler.JobListener;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ma!\u0002\t\u0012\u0001MI\u0002\u0002C\u0016\u0001\u0005\u0003\u0005\u000b\u0011B\u0017\t\u0011A\u0002!Q1A\u0005\u0002EB\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\r\u0005\tm\u0001\u0011\t\u0011)A\u0005e!Aq\u0007\u0001B\u0001B\u0003%\u0001\bC\u0003J\u0001\u0011\u0005!\nC\u0004Q\u0001\t\u0007I\u0011B)\t\ry\u0003\u0001\u0015!\u0003S\u0011\u001dy\u0006A1A\u0005\n\u0001DaA\u001a\u0001!\u0002\u0013\t\u0007\"B4\u0001\t\u0003A\u0007\"\u00027\u0001\t\u0003i\u0007\"B9\u0001\t\u0003\u0011\b\"B:\u0001\t\u0003\"\b\"B=\u0001\t\u0003R(!\u0003&pE^\u000b\u0017\u000e^3s\u0015\t\u00112#A\u0005tG\",G-\u001e7fe*\u0011A#F\u0001\u0006gB\f'o\u001b\u0006\u0003-]\ta!\u00199bG\",'\"\u0001\r\u0002\u0007=\u0014x-\u0006\u0002\u001b{M!\u0001aG\u0011&!\tar$D\u0001\u001e\u0015\u0005q\u0012!B:dC2\f\u0017B\u0001\u0011\u001e\u0005\u0019\te.\u001f*fMB\u0011!eI\u0007\u0002#%\u0011A%\u0005\u0002\f\u0015>\u0014G*[:uK:,'\u000f\u0005\u0002'S5\tqE\u0003\u0002)'\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002+O\t9Aj\\4hS:<\u0017\u0001\u00043bON\u001b\u0007.\u001a3vY\u0016\u00148\u0001\u0001\t\u0003E9J!aL\t\u0003\u0019\u0011\u000buiU2iK\u0012,H.\u001a:\u0002\u000b)|'-\u00133\u0016\u0003I\u0002\"\u0001H\u001a\n\u0005Qj\"aA%oi\u00061!n\u001c2JI\u0002\n!\u0002^8uC2$\u0016m]6t\u00035\u0011Xm];mi\"\u000bg\u000e\u001a7feB)A$\u000f\u001a<\r&\u0011!(\b\u0002\n\rVt7\r^5p]J\u0002\"\u0001P\u001f\r\u0001\u0011)a\b\u0001b\u0001\u007f\t\tA+\u0005\u0002A\u0007B\u0011A$Q\u0005\u0003\u0005v\u0011qAT8uQ&tw\r\u0005\u0002\u001d\t&\u0011Q)\b\u0002\u0004\u0003:L\bC\u0001\u000fH\u0013\tAUD\u0001\u0003V]&$\u0018A\u0002\u001fj]&$h\bF\u0003L\u00196su\nE\u0002#\u0001mBQa\u000b\u0004A\u00025BQ\u0001\r\u0004A\u0002IBQA\u000e\u0004A\u0002IBQa\u000e\u0004A\u0002a\nQBZ5oSNDW\r\u001a+bg.\u001cX#\u0001*\u0011\u0005McV\"\u0001+\u000b\u0005U3\u0016AB1u_6L7M\u0003\u0002X1\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005eS\u0016\u0001B;uS2T\u0011aW\u0001\u0005U\u00064\u0018-\u0003\u0002^)\ni\u0011\t^8nS\u000eLe\u000e^3hKJ\faBZ5oSNDW\r\u001a+bg.\u001c\b%\u0001\u0006k_\n\u0004&o\\7jg\u0016,\u0012!\u0019\t\u0004E\u00124U\"A2\u000b\u0005]k\u0012BA3d\u0005\u001d\u0001&o\\7jg\u0016\f1B[8c!J|W.[:fA\u0005Y!n\u001c2GS:L7\u000f[3e+\u0005I\u0007C\u0001\u000fk\u0013\tYWDA\u0004C_>dW-\u00198\u0002!\r|W\u000e\u001d7fi&|gNR;ukJ,W#\u00018\u0011\u0007\t|g)\u0003\u0002qG\n1a)\u001e;ve\u0016\faaY1oG\u0016dG#\u0001$\u0002\u001bQ\f7o[*vG\u000e,W\rZ3e)\r1Uo\u001e\u0005\u0006m:\u0001\rAM\u0001\u0006S:$W\r\u001f\u0005\u0006q:\u0001\raQ\u0001\u0007e\u0016\u001cX\u000f\u001c;\u0002\u0013)|'MR1jY\u0016$GC\u0001$|\u0011\u0015ax\u00021\u0001~\u0003%)\u0007pY3qi&|g\u000eE\u0002\u007f\u0003\u001bq1a`A\u0005\u001d\u0011\t\t!a\u0002\u000e\u0005\u0005\r!bAA\u0003Y\u00051AH]8pizJ\u0011AH\u0005\u0004\u0003\u0017i\u0012a\u00029bG.\fw-Z\u0005\u0005\u0003\u001f\t\tBA\u0005Fq\u000e,\u0007\u000f^5p]*\u0019\u00111B\u000f")
public class JobWaiter<T>
implements JobListener,
Logging {
    private final DAGScheduler dagScheduler;
    private final int jobId;
    private final int totalTasks;
    private final Function2<Object, T, BoxedUnit> resultHandler;
    private final AtomicInteger finishedTasks;
    private final Promise<BoxedUnit> jobPromise;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public int jobId() {
        return this.jobId;
    }

    private AtomicInteger finishedTasks() {
        return this.finishedTasks;
    }

    private Promise<BoxedUnit> jobPromise() {
        return this.jobPromise;
    }

    public boolean jobFinished() {
        return this.jobPromise().isCompleted();
    }

    public Future<BoxedUnit> completionFuture() {
        return this.jobPromise().future();
    }

    public void cancel() {
        this.dagScheduler.cancelJob(this.jobId(), (Option<String>)None$.MODULE$);
    }

    @Override
    public void taskSucceeded(int index, Object result) {
        JobWaiter jobWaiter = this;
        synchronized (jobWaiter) {
            this.resultHandler.apply((Object)BoxesRunTime.boxToInteger((int)index), result);
        }
        if (this.finishedTasks().incrementAndGet() == this.totalTasks) {
            this.jobPromise().success((Object)BoxedUnit.UNIT);
            return;
        }
    }

    @Override
    public void jobFailed(Exception exception) {
        if (!this.jobPromise().tryFailure((Throwable)exception)) {
            this.logWarning((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> "Ignore failure", exception);
            return;
        }
    }

    public JobWaiter(DAGScheduler dagScheduler, int jobId, int totalTasks, Function2<Object, T, BoxedUnit> resultHandler) {
        this.dagScheduler = dagScheduler;
        this.jobId = jobId;
        this.totalTasks = totalTasks;
        this.resultHandler = resultHandler;
        Logging.$init$((Logging)this);
        this.finishedTasks = new AtomicInteger(0);
        this.jobPromise = totalTasks == 0 ? Promise$.MODULE$.successful((Object)BoxedUnit.UNIT) : Promise$.MODULE$.apply();
    }
}

