/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.utils;

import org.apache.commons.lang3.NotImplementedException;

public class Hash {
    private static final int[] a = new int[]{-1, -1216193348, 284828658, -716303054, 1972430140, -320408015, -1990934688, 1541639048, -904054080, -1301123186, -1159823750, -892530300, -80560723, 691456471, -1246196425, -764226733, -516317085, -623940729, 896062753, 1975917034, 2083228861, 19676287, 174201911, 1999063570, 1931294618, -463598277, -357257709, 281297095, 1355753625, -664421050, -1430391985, 563060931};

    public static int hash(Object o, HashType ht) {
        int hashcode = o.hashCode();
        switch (ht) {
            case StandardJava: {
                return hashcode;
            }
            case LinearHash: {
                return Hash.linearHash(hashcode);
            }
            case ExpHash: {
                return Hash.expHash(hashcode);
            }
        }
        throw new NotImplementedException("Not Implemented hashing combination");
    }

    public static int hash(double o, HashType ht) {
        switch (ht) {
            case StandardJava: {
                return Double.valueOf(o).hashCode();
            }
            case LinearHash: {
                long v = Double.doubleToLongBits(o);
                return Hash.linearHash((int)(v ^ v >>> 32));
            }
        }
        throw new NotImplementedException("Not Implemented hashing combination for double value");
    }

    public static int linearHash(int v) {
        return Hash.linearHash(v, a.length);
    }

    public static int linearHash(int v, int bits) {
        int res = 0;
        for (int i = 0; i < bits; ++i) {
            res = (res << 1) + (Long.bitCount(a[i] & v) & 1);
        }
        return res;
    }

    public static byte expHash(int x) {
        for (int value = 0; value < a.length; ++value) {
            int dot = Long.bitCount(a[value] & x) & 1;
            if (dot == 0) continue;
            return (byte)(value + 1);
        }
        return (byte)a.length;
    }

    public static enum HashType {
        StandardJava,
        LinearHash,
        ExpHash;

    }
}

