/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.utils;

import java.util.Arrays;
import org.apache.sysds.runtime.compress.utils.Util;

public class DblArray {
    private final double[] _arr;
    private int _hash;

    public DblArray(double[] arr) {
        this._arr = arr;
    }

    private DblArray(double[] arr, int hash) {
        this._arr = arr;
        this._hash = hash;
    }

    public DblArray(DblArray that) {
        this(Arrays.copyOf(that._arr, that._arr.length), that.hashCode());
    }

    public double[] getData() {
        return this._arr;
    }

    public void resetHash() {
        this._hash = 0;
    }

    public boolean isEmpty() {
        if (this._arr == null) {
            return true;
        }
        for (int i = 0; i < this._arr.length; ++i) {
            if (this._arr[i] == 0.0) continue;
            return false;
        }
        return true;
    }

    public final int hashCode() {
        if (this._hash != 0) {
            return this._hash;
        }
        this._hash = this.hashCode(this._arr);
        return this._hash;
    }

    private final int hashCode(double[] arr) {
        int h = 1;
        for (double element : this._arr) {
            long bits = Double.doubleToLongBits(element);
            h = 857 * h + (int)(bits ^ bits >>> 32);
        }
        h ^= h >>> 20 ^ h >>> 12;
        h = h ^ h >>> 7 ^ h >>> 4;
        return h;
    }

    public final boolean equals(DblArray that) {
        if (this.hashCode() == that.hashCode()) {
            double[] t = this._arr;
            double[] o = that._arr;
            for (int i = 0; i < t.length; ++i) {
                if (Util.eq(t[i], o[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        return o instanceof DblArray && this.equals((DblArray)o);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(2 + this._arr.length * 4);
        sb.append("[");
        sb.append(DblArray.doubleToString(this._arr[0]));
        for (int i = 1; i < this._arr.length; ++i) {
            sb.append(", ");
            sb.append(DblArray.doubleToString(this._arr[i]));
        }
        sb.append("]");
        return sb.toString();
    }

    private static String doubleToString(double v) {
        if (v == (double)((long)v)) {
            return Long.toString((long)v);
        }
        return Double.toString(v);
    }
}

