/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.util;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang.NotImplementedException;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.parfor.stat.InfrastructureAnalyzer;

public class CommonThreadPool
implements ExecutorService {
    private static final int size = InfrastructureAnalyzer.getLocalParallelism();
    private static final ExecutorService shared = ForkJoinPool.commonPool();
    private final ExecutorService _pool;
    public static ExecutorService triggerRemoteOPsPool = null;

    public CommonThreadPool(ExecutorService pool) {
        this._pool = pool;
    }

    public static ExecutorService get(int k) {
        return new CommonThreadPool(size == k ? shared : Executors.newFixedThreadPool(k));
    }

    public static <T> void invokeAndShutdown(ExecutorService pool, Collection<? extends Callable<T>> tasks) {
        try {
            List ret = pool.invokeAll(tasks);
            for (Future r : ret) {
                r.get();
            }
            pool.shutdown();
        }
        catch (Exception ex) {
            throw new DMLRuntimeException(ex);
        }
    }

    public static void shutdownShared() {
        shared.shutdownNow();
    }

    public static void shutdownAsyncRDDPool() {
        if (triggerRemoteOPsPool != null) {
            triggerRemoteOPsPool.shutdown();
            triggerRemoteOPsPool = null;
        }
    }

    @Override
    public void shutdown() {
        if (this._pool != shared) {
            this._pool.shutdown();
        }
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this._pool != shared ? this._pool.shutdownNow() : null;
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this._pool.invokeAll(tasks);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this._pool.invokeAll(tasks, timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        this._pool.execute(command);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this._pool.submit(task);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this._pool.submit(task, result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this._pool.submit(task);
    }

    @Override
    public boolean isShutdown() {
        throw new NotImplementedException();
    }

    @Override
    public boolean isTerminated() {
        throw new NotImplementedException();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        throw new NotImplementedException();
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        throw new NotImplementedException();
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        throw new NotImplementedException();
    }
}

