/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.matrix.operators;

import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.functionobjects.IndexFunction;
import org.apache.sysds.runtime.instructions.cp.AggregateUnaryCPInstruction;
import org.apache.sysds.runtime.matrix.operators.CountDistinctOperatorTypes;
import org.apache.sysds.runtime.matrix.operators.Operator;
import org.apache.sysds.utils.Hash;

public class CountDistinctOperator
extends Operator {
    private static final long serialVersionUID = 7615123453265129670L;
    private final CountDistinctOperatorTypes operatorType;
    private final Hash.HashType hashType;
    private Types.Direction direction;
    private IndexFunction indexFunction;

    public CountDistinctOperator(AggregateUnaryCPInstruction.AUType opType) {
        super(true);
        switch (opType) {
            case COUNT_DISTINCT: {
                this.operatorType = CountDistinctOperatorTypes.COUNT;
                break;
            }
            case COUNT_DISTINCT_APPROX: {
                this.operatorType = CountDistinctOperatorTypes.KMV;
                break;
            }
            default: {
                throw new DMLRuntimeException(opType + " not supported for CountDistinct Operator");
            }
        }
        this.hashType = Hash.HashType.LinearHash;
    }

    public CountDistinctOperator(CountDistinctOperatorTypes operatorType) {
        super(true);
        this.operatorType = operatorType;
        this.hashType = Hash.HashType.StandardJava;
    }

    public CountDistinctOperator(CountDistinctOperatorTypes operatorType, Hash.HashType hashType) {
        super(true);
        this.operatorType = operatorType;
        this.hashType = hashType;
    }

    public CountDistinctOperator(CountDistinctOperatorTypes operatorType, IndexFunction indexFunction, Hash.HashType hashType) {
        super(true);
        this.operatorType = operatorType;
        this.indexFunction = indexFunction;
        this.hashType = hashType;
    }

    public CountDistinctOperatorTypes getOperatorType() {
        return this.operatorType;
    }

    public Hash.HashType getHashType() {
        return this.hashType;
    }

    public IndexFunction getIndexFunction() {
        return this.indexFunction;
    }

    public CountDistinctOperator setIndexFunction(IndexFunction indexFunction) {
        this.indexFunction = indexFunction;
        return this;
    }

    public Types.Direction getDirection() {
        return this.direction;
    }

    public CountDistinctOperator setDirection(Types.Direction direction) {
        this.direction = direction;
        return this;
    }
}

