/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.fed;

import org.apache.sysds.runtime.controlprogram.caching.FrameObject;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.controlprogram.federated.FederatedRequest;
import org.apache.sysds.runtime.controlprogram.federated.FederationMap;
import org.apache.sysds.runtime.controlprogram.federated.FederationUtils;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.fed.FEDInstruction;
import org.apache.sysds.runtime.instructions.fed.TernaryFEDInstruction;
import org.apache.sysds.runtime.matrix.operators.TernaryOperator;

public class TernaryFrameScalarFEDInstruction
extends TernaryFEDInstruction {
    protected TernaryFrameScalarFEDInstruction(TernaryOperator op, CPOperand in1, CPOperand in2, CPOperand in3, CPOperand out, String opcode, String istr, FEDInstruction.FederatedOutput fedOut) {
        super(op, in1, in2, in3, out, opcode, istr, fedOut);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        FrameObject fo = ec.getFrameObject(this.input1);
        FederationMap fedMap = fo.getFedMapping();
        FederatedRequest fr1 = FederationUtils.callInstruction(this.instString, this.output, new CPOperand[]{this.input1}, new long[]{fedMap.getID()});
        fedMap.execute(this.getTID(), true, fr1);
        FrameObject out = ec.getFrameObject(this.output);
        out.setSchema(fo.getSchema());
        out.getDataCharacteristics().set(fo.getDataCharacteristics());
        out.setFedMapping(fedMap.copyWithNewID(fr1.getID()));
    }
}

