/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.lib;

import org.apache.sysds.runtime.compress.CompressedMatrixBlock;
import org.apache.sysds.runtime.matrix.data.LibMatrixReorg;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.util.UtilFunctions;

public class CLALibRexpand {
    public static MatrixBlock rexpand(CompressedMatrixBlock in, MatrixBlock ret, double max, boolean rows, boolean cast, boolean ignore, int k) {
        if (rows) {
            return in.getUncompressed("Rexpand in rows direction (one hot encode)").rexpandOperations(ret, max, rows, cast, ignore, k);
        }
        return CLALibRexpand.rexpandCols(in, max, cast, ignore, k);
    }

    private static MatrixBlock rexpandCols(CompressedMatrixBlock in, double max, boolean cast, boolean ignore, int k) {
        return CLALibRexpand.rexpandCols(in, UtilFunctions.toInt(max), cast, ignore, k);
    }

    private static MatrixBlock rexpandCols(CompressedMatrixBlock in, int max, boolean cast, boolean ignore, int k) {
        LibMatrixReorg.checkRexpand(in, ignore);
        int nRows = in.getNumRows();
        if (in.isEmptyBlock(false)) {
            return new MatrixBlock(nRows, max, true);
        }
        if (in.isOverlapping() || in.getColGroups().size() > 1) {
            return LibMatrixReorg.rexpand(in.getUncompressed("Rexpand (one hot encode)"), new MatrixBlock(), max, false, cast, ignore, k);
        }
        CompressedMatrixBlock retC = new CompressedMatrixBlock(nRows, max);
        retC.allocateColGroup(in.getColGroups().get(0).rexpandCols(max, ignore, cast, nRows));
        retC.recomputeNonZeros();
        return retC;
    }
}

