/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.dictionary;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.commons.lang.NotImplementedException;
import org.apache.sysds.runtime.compress.colgroup.dictionary.ADictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.Dictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.DictionaryFactory;
import org.apache.sysds.runtime.compress.colgroup.dictionary.MatrixBlockDictionary;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.functionobjects.Builtin;
import org.apache.sysds.runtime.functionobjects.Divide;
import org.apache.sysds.runtime.functionobjects.Multiply;
import org.apache.sysds.runtime.functionobjects.Plus;
import org.apache.sysds.runtime.functionobjects.ValueFunction;
import org.apache.sysds.runtime.instructions.cp.CM_COV_Object;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.operators.BinaryOperator;
import org.apache.sysds.runtime.matrix.operators.ScalarOperator;
import org.apache.sysds.runtime.matrix.operators.UnaryOperator;
import org.apache.sysds.utils.MemoryEstimates;

public class QDictionary
extends ADictionary {
    private static final long serialVersionUID = 2100501253343438897L;
    protected double _scale;
    protected byte[] _values;

    protected QDictionary(byte[] values, double scale) {
        this._values = values;
        this._scale = scale;
    }

    @Override
    public double[] getValues() {
        if (this._values == null) {
            return new double[0];
        }
        double[] res = new double[this._values.length];
        for (int i = 0; i < this._values.length; ++i) {
            res[i] = this.getValue(i);
        }
        return res;
    }

    @Override
    public double getValue(int i) {
        return i >= this.size() ? 0.0 : (double)this._values[i] * this._scale;
    }

    public byte getValueByte(int i) {
        return this._values[i];
    }

    public byte[] getValuesByte() {
        return this._values;
    }

    public double getScale() {
        return this._scale;
    }

    @Override
    public long getInMemorySize() {
        return QDictionary.getInMemorySize(this.size());
    }

    public static long getInMemorySize(int valuesCount) {
        return 16L + MemoryEstimates.byteArrayCost(valuesCount) + 8L;
    }

    @Override
    public double aggregate(double init, Builtin fn) {
        int len = this.size();
        double ret = init;
        for (int i = 0; i < len; ++i) {
            ret = fn.execute(ret, this.getValue(i));
        }
        return ret;
    }

    @Override
    public double aggregateWithReference(double init, Builtin fn, double[] reference, boolean def) {
        throw new NotImplementedException();
    }

    @Override
    public double[] aggregateRows(Builtin fn, int nCol) {
        if (nCol == 1) {
            return this.getValues();
        }
        int nRows = this._values.length / nCol;
        double[] res = new double[nRows];
        for (int i = 0; i < nRows; ++i) {
            int off = i * nCol;
            res[i] = this._values[off];
            for (int j = off + 1; j < off + nCol; ++j) {
                res[i] = fn.execute(res[i], (double)this._values[j] * this._scale);
            }
        }
        return res;
    }

    @Override
    public double[] aggregateRowsWithDefault(Builtin fn, double[] defaultTuple) {
        throw new NotImplementedException();
    }

    @Override
    public double[] aggregateRowsWithReference(Builtin fn, double[] reference) {
        throw new NotImplementedException();
    }

    @Override
    public QDictionary inplaceScalarOp(ScalarOperator op) {
        if (this._values == null) {
            return this;
        }
        if (op.fn instanceof Multiply || op.fn instanceof Divide) {
            this._scale = op.executeScalar(this._scale);
            return this;
        }
        if (op.fn instanceof Plus) {
            double max = Math.max(Math.abs(op.executeScalar(-127.0 * this._scale)), Math.abs(op.executeScalar(127.0 * this._scale)));
            double oldScale = this._scale;
            this._scale = max / 127.0;
            for (int i = 0; i < this._values.length; ++i) {
                this._values[i] = (byte)Math.round(op.executeScalar((double)this._values[i] * oldScale) / this._scale);
            }
        } else {
            int i;
            double[] temp = new double[this._values.length];
            double max = Math.abs(op.executeScalar(this.getValue(0)));
            for (i = 0; i < this._values.length; ++i) {
                temp[i] = op.executeScalar(this.getValue(i));
                double absTemp = Math.abs(temp[i]);
                if (!(absTemp > max)) continue;
                max = absTemp;
            }
            this._scale = max / 127.0;
            for (i = 0; i < this._values.length; ++i) {
                this._values[i] = (byte)Math.round(temp[i] / this._scale);
            }
        }
        return this;
    }

    @Override
    public QDictionary applyScalarOp(ScalarOperator op) {
        throw new NotImplementedException();
    }

    @Override
    public ADictionary applyUnaryOp(UnaryOperator op) {
        throw new NotImplementedException();
    }

    @Override
    public ADictionary applyScalarOpWithReference(ScalarOperator op, double[] reference, double[] newReference) {
        throw new NotImplementedException();
    }

    @Override
    public ADictionary applyUnaryOpWithReference(UnaryOperator op, double[] reference, double[] newReference) {
        throw new NotImplementedException();
    }

    private int size() {
        return this._values.length;
    }

    @Override
    public QDictionary clone() {
        return new QDictionary((byte[])this._values.clone(), this._scale);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeByte(DictionaryFactory.Type.INT8_DICT.ordinal());
        out.writeDouble(this._scale);
        out.writeInt(this._values.length);
        for (int i = 0; i < this._values.length; ++i) {
            out.writeByte(this._values[i]);
        }
    }

    public static QDictionary read(DataInput in) throws IOException {
        double scale = in.readDouble();
        int numVals = in.readInt();
        byte[] values = new byte[numVals];
        for (int i = 0; i < numVals; ++i) {
            values[i] = in.readByte();
        }
        return new QDictionary(values, scale);
    }

    @Override
    public long getExactSizeOnDisk() {
        return 13 + this.size();
    }

    @Override
    public int getNumberOfValues(int nCol) {
        return this._values == null ? 0 : this._values.length / nCol;
    }

    @Override
    public double[] sumAllRowsToDouble(int nrColumns) {
        if (nrColumns == 1) {
            return this.getValues();
        }
        int numVals = this.getNumberOfValues(nrColumns);
        double[] ret = new double[numVals];
        for (int k = 0; k < numVals; ++k) {
            ret[k] = this.sumRow(k, nrColumns);
        }
        return ret;
    }

    @Override
    public double[] sumAllRowsToDoubleWithDefault(double[] defaultTuple) {
        throw new NotImplementedException();
    }

    @Override
    public double[] sumAllRowsToDoubleWithReference(double[] reference) {
        throw new NotImplementedException();
    }

    @Override
    public double[] sumAllRowsToDoubleSq(int nrColumns) {
        int numVals = this.getNumberOfValues(nrColumns);
        double[] ret = new double[numVals];
        for (int k = 0; k < numVals; ++k) {
            ret[k] = this.sumRowSq(k, nrColumns);
        }
        return ret;
    }

    @Override
    public double[] sumAllRowsToDoubleSqWithDefault(double[] defaultTuple) {
        throw new NotImplementedException();
    }

    @Override
    public double[] sumAllRowsToDoubleSqWithReference(double[] reference) {
        throw new NotImplementedException();
    }

    private double sumRow(int k, int nrColumns) {
        if (this._values == null) {
            return 0.0;
        }
        int valOff = k * nrColumns;
        int res = 0;
        for (int i = 0; i < nrColumns; ++i) {
            res += this._values[valOff + i];
        }
        return (double)res * this._scale;
    }

    private double sumRowSq(int k, int nrColumns) {
        if (this._values == null) {
            return 0.0;
        }
        int valOff = k * nrColumns;
        double res = 0.0;
        for (int i = 0; i < nrColumns; ++i) {
            res += (double)(this._values[valOff + i] * this._values[valOff + i]) * this._scale * this._scale;
        }
        return res;
    }

    @Override
    public void colSum(double[] c, int[] counts, int[] colIndexes) {
        throw new NotImplementedException("Not Implemented");
    }

    @Override
    public void colSumSq(double[] c, int[] counts, int[] colIndexes) {
        throw new NotImplementedException("Not Implemented");
    }

    @Override
    public void colSumSqWithReference(double[] c, int[] counts, int[] colIndexes, double[] reference) {
        throw new NotImplementedException();
    }

    @Override
    public double sum(int[] counts, int ncol) {
        throw new NotImplementedException("Not Implemented");
    }

    @Override
    public double sumSq(int[] counts, int ncol) {
        throw new NotImplementedException("Not Implemented");
    }

    @Override
    public double sumSqWithReference(int[] counts, double[] reference) {
        throw new NotImplementedException("Not Implemented");
    }

    @Override
    public String getString(int colIndexes) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.size(); ++i) {
            sb.append(this._values[i]);
            sb.append(i % colIndexes == colIndexes - 1 ? "\n" : " ");
        }
        return sb.toString();
    }

    public Dictionary makeDoubleDictionary() {
        double[] doubleValues = this.getValues();
        return new Dictionary(doubleValues);
    }

    @Override
    public ADictionary sliceOutColumnRange(int idxStart, int idxEnd, int previousNumberOfColumns) {
        int numberTuples = this.getNumberOfValues(previousNumberOfColumns);
        int tupleLengthAfter = idxEnd - idxStart;
        byte[] newDictValues = new byte[tupleLengthAfter * numberTuples];
        int orgOffset = idxStart;
        int targetOffset = 0;
        for (int v = 0; v < numberTuples; ++v) {
            int c = 0;
            while (c < tupleLengthAfter) {
                newDictValues[targetOffset] = this._values[orgOffset];
                ++c;
                ++orgOffset;
                ++targetOffset;
            }
            orgOffset += previousNumberOfColumns - idxEnd + idxStart;
        }
        return new QDictionary(newDictValues, this._scale);
    }

    @Override
    public boolean containsValue(double pattern) {
        if (Double.isNaN(pattern) || Double.isInfinite(pattern)) {
            return false;
        }
        throw new NotImplementedException("Not contains value on Q Dictionary");
    }

    @Override
    public boolean containsValueWithReference(double pattern, double[] reference) {
        throw new NotImplementedException();
    }

    @Override
    public long getNumberNonZeros(int[] counts, int nCol) {
        long nnz = 0L;
        int nRow = this._values.length / nCol;
        for (int i = 0; i < nRow; ++i) {
            int off;
            long rowCount = 0L;
            for (int j = off = i * nCol; j < off + nCol; ++j) {
                if (this._values[j] == 0) continue;
                ++rowCount;
            }
            nnz += rowCount * (long)counts[i];
        }
        return nnz;
    }

    @Override
    public long getNumberNonZerosWithReference(int[] counts, double[] reference, int nRows) {
        throw new NotImplementedException("not implemented yet");
    }

    @Override
    public void addToEntry(double[] v, int fr, int to, int nCol) {
        throw new NotImplementedException("Not implemented yet");
    }

    @Override
    public void addToEntry(double[] v, int fr, int to, int nCol, int rep) {
        throw new NotImplementedException("Not implemented yet");
    }

    @Override
    public void addToEntryVectorized(double[] v, int f1, int f2, int f3, int f4, int f5, int f6, int f7, int f8, int t1, int t2, int t3, int t4, int t5, int t6, int t7, int t8, int nCol) {
        throw new NotImplementedException("Not implemented yet");
    }

    @Override
    public boolean isLossy() {
        return false;
    }

    @Override
    public ADictionary subtractTuple(double[] tuple) {
        throw new NotImplementedException();
    }

    @Override
    public MatrixBlockDictionary getMBDict(int nCol) {
        throw new NotImplementedException();
    }

    @Override
    public void aggregateCols(double[] c, Builtin fn, int[] colIndexes) {
        throw new NotImplementedException();
    }

    @Override
    public void aggregateColsWithReference(double[] c, Builtin fn, int[] colIndexes, double[] reference, boolean def) {
        throw new NotImplementedException();
    }

    @Override
    public ADictionary scaleTuples(int[] scaling, int nCol) {
        throw new NotImplementedException();
    }

    @Override
    public ADictionary preaggValuesFromDense(int numVals, int[] colIndexes, int[] aggregateColumns, double[] b, int cut) {
        throw new NotImplementedException();
    }

    @Override
    public ADictionary replace(double pattern, double replace, int nCol) {
        throw new NotImplementedException();
    }

    @Override
    public ADictionary replaceWithReference(double pattern, double replace, double[] reference) {
        throw new NotImplementedException();
    }

    @Override
    public void product(double[] ret, int[] counts, int nCol) {
        throw new NotImplementedException();
    }

    @Override
    public void productWithDefault(double[] ret, int[] counts, double[] def, int defCount) {
        throw new NotImplementedException();
    }

    @Override
    public void productWithReference(double[] ret, int[] counts, double[] reference, int refCount) {
        throw new NotImplementedException();
    }

    @Override
    public ADictionary binOpLeft(BinaryOperator op, double[] v, int[] colIndexes) {
        throw new NotImplementedException();
    }

    @Override
    public ADictionary binOpRight(BinaryOperator op, double[] v, int[] colIndexes) {
        throw new NotImplementedException();
    }

    @Override
    public ADictionary binOpRight(BinaryOperator op, double[] v) {
        throw new NotImplementedException();
    }

    @Override
    public ADictionary binOpLeftWithReference(BinaryOperator op, double[] v, int[] colIndexes, double[] reference, double[] newReference) {
        throw new NotImplementedException();
    }

    @Override
    public ADictionary binOpRightWithReference(BinaryOperator op, double[] v, int[] colIndexes, double[] reference, double[] newReference) {
        throw new NotImplementedException();
    }

    @Override
    public CM_COV_Object centralMoment(CM_COV_Object ret, ValueFunction fn, int[] counts, int nRows) {
        throw new NotImplementedException();
    }

    @Override
    public CM_COV_Object centralMomentWithReference(CM_COV_Object ret, ValueFunction fn, int[] counts, double reference, int nRows) {
        throw new NotImplementedException();
    }

    @Override
    public ADictionary rexpandCols(int max, boolean ignore, boolean cast, int nCol) {
        throw new NotImplementedException();
    }

    @Override
    public ADictionary rexpandColsWithReference(int max, boolean ignore, boolean cast, double reference) {
        throw new NotImplementedException();
    }

    @Override
    public double getSparsity() {
        return 1.0;
    }

    @Override
    public void multiplyScalar(double v, double[] ret, int off, int dictIdx, int[] cols) {
        throw new NotImplementedException();
    }

    @Override
    protected void TSMMWithScaling(int[] counts, int[] rows, int[] cols, MatrixBlock ret) {
        throw new NotImplementedException();
    }

    @Override
    protected void MMDict(ADictionary right, int[] rowsLeft, int[] colsRight, MatrixBlock result) {
        throw new NotImplementedException();
    }

    @Override
    protected void MMDictDense(double[] left, int[] rowsLeft, int[] colsRight, MatrixBlock result) {
        throw new NotImplementedException();
    }

    @Override
    protected void MMDictSparse(SparseBlock left, int[] rowsLeft, int[] colsRight, MatrixBlock result) {
        throw new NotImplementedException();
    }

    @Override
    protected void TSMMToUpperTriangle(ADictionary right, int[] rowsLeft, int[] colsRight, MatrixBlock result) {
        throw new NotImplementedException();
    }

    @Override
    protected void TSMMToUpperTriangleDense(double[] left, int[] rowsLeft, int[] colsRight, MatrixBlock result) {
        throw new NotImplementedException();
    }

    @Override
    protected void TSMMToUpperTriangleSparse(SparseBlock left, int[] rowsLeft, int[] colsRight, MatrixBlock result) {
        throw new NotImplementedException();
    }

    @Override
    protected void TSMMToUpperTriangleScaling(ADictionary right, int[] rowsLeft, int[] colsRight, int[] scale, MatrixBlock result) {
        throw new NotImplementedException();
    }

    @Override
    protected void TSMMToUpperTriangleDenseScaling(double[] left, int[] rowsLeft, int[] colsRight, int[] scale, MatrixBlock result) {
        throw new NotImplementedException();
    }

    @Override
    protected void TSMMToUpperTriangleSparseScaling(SparseBlock left, int[] rowsLeft, int[] colsRight, int[] scale, MatrixBlock result) {
        throw new NotImplementedException();
    }
}

