/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup;

import java.util.Arrays;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.colgroup.AColGroupCompressed;
import org.apache.sysds.runtime.compress.colgroup.ColGroupConst;
import org.apache.sysds.runtime.compress.colgroup.dictionary.ADictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.Dictionary;
import org.apache.sysds.runtime.compress.cost.ComputationCostEstimator;
import org.apache.sysds.runtime.compress.utils.Util;
import org.apache.sysds.runtime.data.DenseBlock;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.functionobjects.Builtin;
import org.apache.sysds.runtime.functionobjects.ValueFunction;
import org.apache.sysds.runtime.instructions.cp.CM_COV_Object;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.operators.BinaryOperator;
import org.apache.sysds.runtime.matrix.operators.CMOperator;
import org.apache.sysds.runtime.matrix.operators.ScalarOperator;
import org.apache.sysds.runtime.matrix.operators.UnaryOperator;

public class ColGroupEmpty
extends AColGroupCompressed {
    private static final long serialVersionUID = -2307677253622099958L;

    protected ColGroupEmpty() {
    }

    public ColGroupEmpty(int[] colIndices) {
        super(colIndices);
    }

    public static ColGroupEmpty create(int nCol) {
        return new ColGroupEmpty(Util.genColsIndices(nCol));
    }

    @Override
    public AColGroup.CompressionType getCompType() {
        return AColGroup.CompressionType.EMPTY;
    }

    @Override
    public AColGroup.ColGroupType getColGroupType() {
        return AColGroup.ColGroupType.EMPTY;
    }

    @Override
    public void decompressToDenseBlock(DenseBlock target, int rl, int ru, int offR, int offC) {
    }

    @Override
    public void decompressToSparseBlock(SparseBlock sb, int rl, int ru, int offR, int offC) {
    }

    @Override
    public double getIdx(int r, int colIdx) {
        return 0.0;
    }

    @Override
    public AColGroup scalarOperation(ScalarOperator op) {
        double v = op.executeScalar(0.0);
        if (v == 0.0) {
            return this;
        }
        double[] retV = new double[this._colIndexes.length];
        Arrays.fill(retV, v);
        return ColGroupConst.create(this._colIndexes, (ADictionary)new Dictionary(retV));
    }

    @Override
    public AColGroup unaryOperation(UnaryOperator op) {
        double v = op.fn.execute(0L);
        if (v == 0.0) {
            return this;
        }
        double[] retV = new double[this._colIndexes.length];
        Arrays.fill(retV, v);
        return ColGroupConst.create(this._colIndexes, (ADictionary)new Dictionary(retV));
    }

    @Override
    public AColGroup binaryRowOpLeft(BinaryOperator op, double[] v, boolean isRowSafe) {
        if (isRowSafe) {
            return this;
        }
        ValueFunction fn = op.fn;
        double[] retVals = new double[this._colIndexes.length];
        int lenV = this._colIndexes.length;
        boolean allZero = true;
        for (int i = 0; i < lenV; ++i) {
            retVals[i] = fn.execute(v[this._colIndexes[i]], 0.0);
            allZero = 0.0 == retVals[i] && allZero;
        }
        if (allZero) {
            return this;
        }
        return ColGroupConst.create(this._colIndexes, (ADictionary)new Dictionary(retVals));
    }

    @Override
    public AColGroup binaryRowOpRight(BinaryOperator op, double[] v, boolean isRowSafe) {
        if (isRowSafe) {
            return this;
        }
        ValueFunction fn = op.fn;
        double[] retVals = new double[this._colIndexes.length];
        int lenV = this._colIndexes.length;
        boolean allZero = true;
        for (int i = 0; i < lenV; ++i) {
            retVals[i] = fn.execute(0.0, v[this._colIndexes[i]]);
            allZero = 0.0 == retVals[i] && allZero;
        }
        if (allZero) {
            return this;
        }
        return ColGroupConst.create(this._colIndexes, (ADictionary)new Dictionary(retVals));
    }

    @Override
    public int getNumValues() {
        return 0;
    }

    @Override
    public void leftMultByAColGroup(AColGroup lhs, MatrixBlock c) {
    }

    @Override
    public void tsmmAColGroup(AColGroup other, MatrixBlock result) {
    }

    @Override
    public void leftMultByMatrixNoPreAgg(MatrixBlock matrix, MatrixBlock result, int rl, int ru, int cl, int cu) {
    }

    @Override
    public AColGroup copy() {
        return new ColGroupEmpty(this._colIndexes);
    }

    @Override
    public boolean containsValue(double pattern) {
        return pattern == 0.0;
    }

    @Override
    public long getNumberNonZeros(int nRows) {
        return 0L;
    }

    @Override
    protected AColGroup sliceSingleColumn(int idx) {
        return new ColGroupEmpty(new int[]{0});
    }

    @Override
    protected AColGroup sliceMultiColumns(int idStart, int idEnd, int[] outputCols) {
        return new ColGroupEmpty(outputCols);
    }

    @Override
    public AColGroup rightMultByMatrix(MatrixBlock right) {
        return null;
    }

    @Override
    public AColGroup replace(double pattern, double replace) {
        if (pattern == 0.0) {
            return ColGroupConst.create(this._colIndexes, replace);
        }
        return new ColGroupEmpty(this._colIndexes);
    }

    @Override
    public final double getMin() {
        return 0.0;
    }

    @Override
    public final double getMax() {
        return 0.0;
    }

    @Override
    protected double computeMxx(double c, Builtin builtin) {
        return builtin.execute(c, 0.0);
    }

    @Override
    protected void computeColMxx(double[] c, Builtin builtin) {
        for (int colId : this._colIndexes) {
            c[colId] = builtin.execute(c[colId], 0.0);
        }
    }

    @Override
    protected void computeSum(double[] c, int nRows) {
    }

    @Override
    protected void computeRowSums(double[] c, int rl, int ru, double[] preAgg) {
    }

    @Override
    public void computeColSums(double[] c, int nRows) {
    }

    @Override
    protected void computeSumSq(double[] c, int nRows) {
    }

    @Override
    protected void computeColSumsSq(double[] c, int nRows) {
    }

    @Override
    protected void computeRowMxx(double[] c, Builtin builtin, int rl, int ru, double[] preAgg) {
        for (int r = rl; r < ru; ++r) {
            c[r] = builtin.execute(c[r], 0.0);
        }
    }

    @Override
    protected void tsmm(double[] result, int numColumns, int nRows) {
    }

    @Override
    protected void computeProduct(double[] c, int nRows) {
        c[0] = 0.0;
    }

    @Override
    protected void computeRowProduct(double[] c, int rl, int ru, double[] preAgg) {
        for (int i = 0; i < c.length; ++i) {
            c[i] = 0.0;
        }
    }

    @Override
    protected void computeColProduct(double[] c, int nRows) {
        for (int i = 0; i < c.length; ++i) {
            c[i] = 0.0;
        }
    }

    @Override
    protected double[] preAggSumRows() {
        return null;
    }

    @Override
    protected double[] preAggSumSqRows() {
        return null;
    }

    @Override
    protected double[] preAggProductRows() {
        return null;
    }

    @Override
    protected double[] preAggBuiltinRows(Builtin builtin) {
        return null;
    }

    @Override
    public CM_COV_Object centralMoment(CMOperator op, int nRows) {
        CM_COV_Object ret = new CM_COV_Object();
        op.fn.execute(ret, 0.0, nRows);
        return ret;
    }

    @Override
    public AColGroup rexpandCols(int max, boolean ignore, boolean cast, int nRows) {
        if (!ignore) {
            throw new DMLRuntimeException("Invalid input to rexpand since it contains zero use ignore flag to encode anyway");
        }
        return ColGroupEmpty.create(max);
    }

    @Override
    public double getCost(ComputationCostEstimator e, int nRows) {
        int nCols = this.getNumCols();
        return e.getCost(nRows, 1, nCols, 1, 1.0E-5);
    }
}

