/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.lops;

import org.apache.sysds.common.Types;
import org.apache.sysds.lops.Lop;

public class Compression
extends Lop {
    public static final String OPCODE = "compress";
    private final int _singletonLookupKey;

    public Compression(Lop input, Types.DataType dt, Types.ValueType vt, Types.ExecType et, int singletonLookupKey) {
        super(Lop.Type.Checkpoint, dt, vt);
        this.addInput(input);
        input.addOutput(this);
        this.lps.setProperties(this.inputs, et);
        this._singletonLookupKey = singletonLookupKey;
    }

    @Override
    public String toString() {
        return OPCODE;
    }

    @Override
    public String getInstructions(String input1, String output) {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        sb.append(OPCODE);
        sb.append("\u00b0");
        sb.append(this.getInputs().get(0).prepInputOperand(input1));
        sb.append("\u00b0");
        sb.append(this.prepOutputOperand(output));
        if (this._singletonLookupKey != 0) {
            sb.append("\u00b0");
            sb.append(this._singletonLookupKey);
        }
        return sb.toString();
    }

    public static enum CompressConfig {
        TRUE,
        FALSE,
        COST,
        AUTO,
        WORKLOAD;


        public boolean isEnabled() {
            return this != FALSE;
        }

        public boolean isWorkload() {
            return this == WORKLOAD;
        }
    }
}

