/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.security.client;

import java.util.Collection;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.TokenSelector;
import org.apache.hadoop.yarn.security.client.TimelineDelegationTokenIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class TimelineDelegationTokenSelector
implements TokenSelector<TimelineDelegationTokenIdentifier> {
    private static final Logger LOG = LoggerFactory.getLogger(TimelineDelegationTokenSelector.class);

    public Token<TimelineDelegationTokenIdentifier> selectToken(Text service, Collection<Token<? extends TokenIdentifier>> tokens) {
        if (service == null) {
            return null;
        }
        LOG.debug("Looking for a token with service {}", (Object)service);
        for (Token<? extends TokenIdentifier> token : tokens) {
            LOG.debug("Token kind is {} and the token's service name is {}", (Object)token.getKind(), (Object)token.getService());
            if (!TimelineDelegationTokenIdentifier.KIND_NAME.equals((Object)token.getKind()) || !service.equals((Object)token.getService())) continue;
            return token;
        }
        return null;
    }
}

