/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.dictionary;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.compress.colgroup.dictionary.Dictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.MatrixBlockDictionary;
import org.apache.sysds.runtime.functionobjects.Builtin;
import org.apache.sysds.runtime.matrix.operators.BinaryOperator;
import org.apache.sysds.runtime.matrix.operators.ScalarOperator;

public abstract class ADictionary {
    protected static final Log LOG = LogFactory.getLog((String)ADictionary.class.getName());

    public abstract double[] getValues();

    public abstract double getValue(int var1);

    public abstract long getInMemorySize();

    public abstract double aggregate(double var1, Builtin var3);

    public abstract double[] aggregateTuples(Builtin var1, int var2);

    public abstract ADictionary apply(ScalarOperator var1);

    public abstract ADictionary applyScalarOp(ScalarOperator var1, double var2, int var4);

    public ADictionary applyBinaryRowOp(BinaryOperator op, double[] v, boolean sparseSafe, int[] colIndexes, boolean left) {
        return left ? this.applyBinaryRowOpLeft(op, v, sparseSafe, colIndexes) : this.applyBinaryRowOpRight(op, v, sparseSafe, colIndexes);
    }

    public abstract ADictionary applyBinaryRowOpLeft(BinaryOperator var1, double[] var2, boolean var3, int[] var4);

    public abstract ADictionary applyBinaryRowOpRight(BinaryOperator var1, double[] var2, boolean var3, int[] var4);

    public abstract ADictionary clone();

    public abstract ADictionary cloneAndExtend(int var1);

    public abstract void aggregateCols(double[] var1, Builtin var2, int[] var3);

    public abstract void write(DataOutput var1) throws IOException;

    public abstract long getExactSizeOnDisk();

    public abstract boolean isLossy();

    public abstract int getNumberOfValues(int var1);

    public abstract double[] sumAllRowsToDouble(boolean var1, int var2);

    public abstract double sumRow(int var1, boolean var2, int var3);

    public abstract double[] colSum(int[] var1, int var2);

    public abstract void colSum(double[] var1, int[] var2, int[] var3, boolean var4);

    public abstract double sum(int[] var1, int var2);

    public abstract double sumsq(int[] var1, int var2);

    public abstract String getString(int var1);

    public abstract void addMaxAndMin(double[] var1, int[] var2);

    public abstract ADictionary sliceOutColumnRange(int var1, int var2, int var3);

    public abstract ADictionary reExpandColumns(int var1);

    public abstract boolean containsValue(double var1);

    public abstract long getNumberNonZeros(int[] var1, int var2);

    public abstract void addToEntry(Dictionary var1, int var2, int var3, int var4);

    public double[] getMostCommonTuple(int[] counts, int nCol) {
        int maxIndex = 0;
        int maxCount = 0;
        for (int i = 0; i < counts.length; ++i) {
            if (counts[i] <= maxCount) continue;
            maxCount = counts[i];
            maxIndex = i;
        }
        return this.getTuple(maxIndex, nCol);
    }

    public abstract double[] getTuple(int var1, int var2);

    public abstract ADictionary subtractTuple(double[] var1);

    public abstract MatrixBlockDictionary getAsMatrixBlockDictionary(int var1);

    public abstract ADictionary scaleTuples(int[] var1, int var2);

    public abstract void preaggValuesFromDense(int var1, int[] var2, int[] var3, double[] var4, double[] var5, int var6);

    public abstract ADictionary replace(double var1, double var3, int var5, boolean var6);
}

