/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.parser;

import java.util.HashMap;
import java.util.Map;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;

public class FunctionDictionary<T extends Types.FunctionBlock> {
    private Map<String, T> _funs = new HashMap<String, T>();
    private Map<String, T> _funsOrig;

    public void addFunction(String fname, T fsb) {
        if (this._funs.containsKey(fname)) {
            throw new DMLRuntimeException("Function '" + fname + "' already existing in namespace.");
        }
        this._funs.put(fname, fsb);
        if (this._funsOrig != null) {
            this._funsOrig.put(fname, fsb);
        }
    }

    public void addFunction(String fname, T fsb, boolean opt) {
        Map<String, T> map;
        if (!opt && this._funsOrig == null) {
            this._funsOrig = new HashMap<String, T>();
        }
        Map<String, T> map2 = map = opt ? this._funs : this._funsOrig;
        if (map.containsKey(fname)) {
            throw new DMLRuntimeException("Function '" + fname + "' (" + opt + ") already existing in namespace.");
        }
        map.put(fname, fsb);
    }

    public void removeFunction(String fname) {
        this._funs.remove(fname);
        if (this._funsOrig != null) {
            this._funsOrig.remove(fname);
        }
    }

    public T getFunction(String fname) {
        return this.getFunction(fname, true);
    }

    public T getFunction(String fname, boolean opt) {
        if (!opt && this._funsOrig == null) {
            throw new DMLRuntimeException("Requested unoptimized function '" + fname + "' but original function copies have not been created.");
        }
        return (T)(opt ? (Types.FunctionBlock)this._funs.get(fname) : (this._funsOrig != null ? (Types.FunctionBlock)this._funsOrig.get(fname) : null));
    }

    public boolean containsFunction(String fname) {
        return this.containsFunction(fname, true);
    }

    public boolean containsFunction(String fname, boolean opt) {
        return opt ? this._funs.containsKey(fname) : this._funsOrig != null && this._funsOrig.containsKey(fname);
    }

    public Map<String, T> getFunctions() {
        return this.getFunctions(true);
    }

    public Map<String, T> getFunctions(boolean opt) {
        return opt ? this._funs : this._funsOrig;
    }

    public void copyOriginalFunctions() {
        this._funsOrig = new HashMap<String, T>();
        for (Map.Entry<String, T> fe : this._funs.entrySet()) {
            this._funsOrig.put(fe.getKey(), ((Types.FunctionBlock)fe.getValue()).cloneFunctionBlock());
        }
    }

    public void merge(FunctionDictionary<T> that) {
        for (Map.Entry<String, T> e : that._funs.entrySet()) {
            if (this._funs.containsKey(e.getKey())) continue;
            this._funs.put(e.getKey(), e.getValue());
        }
        if (this._funsOrig != null && that._funsOrig != null) {
            for (Map.Entry<String, T> e : that._funsOrig.entrySet()) {
                if (this._funsOrig.containsKey(e.getKey())) continue;
                this._funsOrig.put(e.getKey(), e.getValue());
            }
        }
    }
}

