/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.transform.decode;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.matrix.data.FrameBlock;
import org.apache.sysds.runtime.transform.TfUtils;
import org.apache.sysds.runtime.transform.decode.Decoder;
import org.apache.sysds.runtime.transform.decode.DecoderComposite;
import org.apache.sysds.runtime.transform.decode.DecoderDummycode;
import org.apache.sysds.runtime.transform.decode.DecoderPassThrough;
import org.apache.sysds.runtime.transform.decode.DecoderRecode;
import org.apache.sysds.runtime.transform.meta.TfMetaUtils;
import org.apache.sysds.runtime.util.CollectionUtils;
import org.apache.sysds.runtime.util.UtilFunctions;
import org.apache.wink.json4j.JSONObject;

public class DecoderFactory {
    public static Decoder createDecoder(String spec, String[] colnames, Types.ValueType[] schema, FrameBlock meta) {
        return DecoderFactory.createDecoder(spec, colnames, schema, meta, meta.getNumColumns(), -1, -1);
    }

    public static Decoder createDecoder(String spec, String[] colnames, Types.ValueType[] schema, FrameBlock meta, int clen) {
        return DecoderFactory.createDecoder(spec, colnames, schema, meta, clen, -1, -1);
    }

    public static Decoder createDecoder(String spec, String[] colnames, Types.ValueType[] schema, FrameBlock meta, int minCol, int maxCol) {
        return DecoderFactory.createDecoder(spec, colnames, schema, meta, meta.getNumColumns(), minCol, maxCol);
    }

    public static Decoder createDecoder(String spec, String[] colnames, Types.ValueType[] schema, FrameBlock meta, int clen, int minCol, int maxCol) {
        DecoderComposite decoder = null;
        try {
            JSONObject jSpec = new JSONObject(spec);
            ArrayList<Decoder> ldecoders = new ArrayList<Decoder>();
            List<Integer> rcIDs = Arrays.asList(ArrayUtils.toObject((int[])TfMetaUtils.parseJsonIDList(jSpec, colnames, TfUtils.TfMethod.RECODE.toString(), minCol, maxCol)));
            List<Integer> dcIDs = Arrays.asList(ArrayUtils.toObject((int[])TfMetaUtils.parseJsonIDList(jSpec, colnames, TfUtils.TfMethod.DUMMYCODE.toString(), minCol, maxCol)));
            rcIDs = CollectionUtils.unionDistinct(rcIDs, dcIDs);
            int len = dcIDs.isEmpty() ? Math.min(meta.getNumColumns(), clen) : meta.getNumColumns();
            List<Integer> ptIDs = CollectionUtils.except(UtilFunctions.getSeqList(1, len, 1), rcIDs);
            if (schema == null) {
                schema = UtilFunctions.nCopies(len, Types.ValueType.STRING);
                for (Integer col : ptIDs) {
                    schema[col.intValue() - 1] = Types.ValueType.FP64;
                }
            }
            if (!dcIDs.isEmpty()) {
                ldecoders.add(new DecoderDummycode(schema, ArrayUtils.toPrimitive((Integer[])dcIDs.toArray(new Integer[0]))));
            }
            if (!rcIDs.isEmpty()) {
                ldecoders.add(new DecoderRecode(schema, !dcIDs.isEmpty(), ArrayUtils.toPrimitive((Integer[])rcIDs.toArray(new Integer[0]))));
            }
            if (!ptIDs.isEmpty()) {
                ldecoders.add(new DecoderPassThrough(schema, ArrayUtils.toPrimitive((Integer[])ptIDs.toArray(new Integer[0])), ArrayUtils.toPrimitive((Integer[])dcIDs.toArray(new Integer[0]))));
            }
            decoder = new DecoderComposite(schema, ldecoders);
            decoder.setColnames(colnames);
            ((Decoder)decoder).initMetaData(meta);
        }
        catch (Exception ex) {
            throw new DMLRuntimeException(ex);
        }
        return decoder;
    }

    public static int getDecoderType(Decoder decoder) {
        if (decoder instanceof DecoderDummycode) {
            return DecoderType.Dummycode.ordinal();
        }
        if (decoder instanceof DecoderRecode) {
            return DecoderType.Recode.ordinal();
        }
        if (decoder instanceof DecoderPassThrough) {
            return DecoderType.PassThrough.ordinal();
        }
        throw new DMLRuntimeException("Unsupported decoder type: " + decoder.getClass().getCanonicalName());
    }

    public static Decoder createInstance(int type) {
        DecoderType dtype = DecoderType.values()[type];
        switch (dtype) {
            case Dummycode: {
                return new DecoderDummycode(null, null);
            }
            case PassThrough: {
                return new DecoderPassThrough(null, null, null);
            }
            case Recode: {
                return new DecoderRecode(null, false, null);
            }
        }
        throw new DMLRuntimeException("Unsupported Encoder Type used:  " + (Object)((Object)dtype));
    }

    public static enum DecoderType {
        Dummycode,
        PassThrough,
        Recode;

    }
}

