/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.io.hdf5.message;

import java.nio.ByteBuffer;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.BitSet;
import org.apache.sysds.runtime.io.hdf5.H5BufferBuilder;
import org.apache.sysds.runtime.io.hdf5.H5RootObject;
import org.apache.sysds.runtime.io.hdf5.H5RuntimeException;
import org.apache.sysds.runtime.io.hdf5.Utils;
import org.apache.sysds.runtime.io.hdf5.message.H5Message;

public class H5ObjectModificationTimeMessage
extends H5Message {
    private final long unixEpocSecond;

    public H5ObjectModificationTimeMessage(H5RootObject rootObject, BitSet flags, long unixEpocSecond) {
        super(rootObject, flags);
        this.unixEpocSecond = unixEpocSecond;
    }

    public H5ObjectModificationTimeMessage(H5RootObject rootObject, BitSet flags, ByteBuffer bb) {
        super(rootObject, flags);
        rootObject.setObjectModificationTimeVersion(bb.get());
        if (rootObject.getObjectModificationTimeVersion() != 1) {
            throw new H5RuntimeException("Unrecognized version " + rootObject.getObjectModificationTimeVersion());
        }
        bb.position(bb.position() + 3);
        this.unixEpocSecond = Utils.readBytesAsUnsignedLong(bb, 4);
    }

    @Override
    public void toBuffer(H5BufferBuilder bb) {
        super.toBuffer(bb, 18);
        bb.writeByte(this.rootObject.getObjectModificationTimeVersion());
        byte[] reserved = new byte[]{0, 0, 0};
        bb.writeBytes(reserved);
        bb.writeInt((int)this.unixEpocSecond);
    }

    public LocalDateTime getModifiedTime() {
        return LocalDateTime.ofEpochSecond(this.unixEpocSecond, 0, ZoneOffset.UTC);
    }

    public long getUnixEpocSecond() {
        return this.unixEpocSecond;
    }
}

