/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.data.SparseRow;
import org.apache.sysds.runtime.io.FileFormatPropertiesCSV;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.runtime.io.MatrixReader;
import org.apache.sysds.runtime.io.ReaderTextCSV;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.util.CommonThreadPool;
import org.apache.sysds.runtime.util.UtilFunctions;

public class ReaderTextCSVParallel
extends MatrixReader {
    private final int _numThreads = OptimizerUtils.getParallelTextReadParallelism();
    protected final FileFormatPropertiesCSV _props;
    protected SplitOffsetInfos _offsets;
    protected int _bLen;
    protected int _rLen;
    protected int _cLen;
    protected JobConf _job;

    public ReaderTextCSVParallel(FileFormatPropertiesCSV props) {
        this._props = props;
    }

    @Override
    public MatrixBlock readMatrixFromHDFS(String fname, long rlen, long clen, int blen, long estnnz) throws IOException, DMLRuntimeException {
        this._bLen = blen;
        this._job = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
        Path path = new Path(fname);
        FileSystem fs = IOUtilFunctions.getFileSystem(path, (Configuration)this._job);
        FileInputFormat.addInputPath((JobConf)this._job, (Path)path);
        TextInputFormat informat = new TextInputFormat();
        informat.configure(this._job);
        InputSplit[] splits = informat.getSplits(this._job, this._numThreads);
        splits = IOUtilFunctions.sortInputSplits(splits);
        ReaderTextCSVParallel.checkValidInputFile(fs, path);
        MatrixBlock ret = this.computeCSVSizeAndCreateOutputMatrixBlock(splits, path, rlen, clen, estnnz);
        this.readCSVMatrixFromHDFS(splits, path, ret);
        ret.examSparsity();
        if (rlen >= 0L && rlen != (long)ret.getNumRows()) {
            throw new DMLRuntimeException("Read matrix inconsistent with given meta data: expected nrow=" + rlen + ", real nrow=" + ret.getNumRows());
        }
        return ret;
    }

    @Override
    public MatrixBlock readMatrixFromInputStream(InputStream is, long rlen, long clen, int blen, long estnnz) throws IOException, DMLRuntimeException {
        return new ReaderTextCSV(this._props).readMatrixFromInputStream(is, rlen, clen, blen, estnnz);
    }

    private void readCSVMatrixFromHDFS(InputSplit[] splits, Path path, MatrixBlock dest) throws IOException {
        FileInputFormat.addInputPath((JobConf)this._job, (Path)path);
        TextInputFormat informat = new TextInputFormat();
        informat.configure(this._job);
        ExecutorService pool = CommonThreadPool.get(this._numThreads);
        try {
            ArrayList<CSVReadTask> tasks = new ArrayList<CSVReadTask>();
            int splitCount = 0;
            for (InputSplit split : splits) {
                if (dest.isInSparseFormat() && this._props.getNAStrings() != null) {
                    tasks.add(new CSVReadSparseNanTask(split, informat, dest, splitCount++));
                    continue;
                }
                if (dest.isInSparseFormat() && this._props.getFillValue() == 0.0) {
                    tasks.add(new CSVReadSparseNoNanTaskAndFill(split, informat, dest, splitCount++));
                    continue;
                }
                if (dest.isInSparseFormat()) {
                    tasks.add(new CSVReadSparseNoNanTask(split, informat, dest, splitCount++));
                    continue;
                }
                if (this._props.getNAStrings() != null) {
                    tasks.add(new CSVReadDenseNanTask(split, informat, dest, splitCount++));
                    continue;
                }
                tasks.add(new CSVReadDenseNoNanTask(split, informat, dest, splitCount++));
            }
            long lnnz = 0L;
            for (Future rt : pool.invokeAll(tasks)) {
                lnnz += ((Long)rt.get()).longValue();
            }
            pool.shutdown();
            dest.setNonZeros(lnnz);
        }
        catch (Exception e) {
            throw new IOException("Thread pool issue, while parallel read.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MatrixBlock computeCSVSizeAndCreateOutputMatrixBlock(InputSplit[] splits, Path path, long rlen, long clen, long estnnz) throws IOException, DMLRuntimeException {
        this._rLen = 0;
        this._cLen = 0;
        FileInputFormat.addInputPath((JobConf)this._job, (Path)path);
        TextInputFormat informat = new TextInputFormat();
        informat.configure(this._job);
        LongWritable key = new LongWritable();
        Text oneLine = new Text();
        RecordReader reader = informat.getRecordReader(splits[0], this._job, Reporter.NULL);
        try {
            if (reader.next((Object)key, (Object)oneLine)) {
                String cellStr = oneLine.toString().trim();
                this._cLen = StringUtils.countMatches((String)cellStr, (String)this._props.getDelim()) + 1;
            }
        }
        finally {
            IOUtilFunctions.closeSilently(reader);
        }
        try {
            ExecutorService pool = CommonThreadPool.get(this._numThreads);
            ArrayList<IOUtilFunctions.CountRowsTask> tasks = new ArrayList<IOUtilFunctions.CountRowsTask>();
            boolean hasHeader = this._props.hasHeader();
            for (InputSplit split : splits) {
                tasks.add(new IOUtilFunctions.CountRowsTask(split, informat, this._job, hasHeader));
                hasHeader = false;
            }
            this._offsets = new SplitOffsetInfos(tasks.size());
            int i = 0;
            for (Future rc : pool.invokeAll(tasks)) {
                int lnrow = (int)((Long)rc.get()).longValue();
                this._offsets.setOffsetPerSplit(i, this._rLen);
                this._offsets.setLenghtPerSplit(i, lnrow);
                this._rLen += lnrow;
                ++i;
            }
            pool.shutdown();
        }
        catch (Exception e) {
            throw new IOException("Thread pool Error " + e.getMessage(), e);
        }
        if (rlen != -1L && (long)this._rLen != rlen || clen != -1L && (long)this._cLen != clen) {
            String msg = "Read matrix dimensions differ from meta data: [" + this._rLen + "x" + this._cLen + "] vs. [" + rlen + "x" + clen + "].";
            if (rlen < (long)this._rLen || clen < (long)this._cLen) {
                throw new DMLRuntimeException(msg);
            }
            LOG.warn((Object)msg);
            this._rLen = (int)rlen;
            this._cLen = (int)clen;
        }
        long estnnz2 = estnnz < 0L ? (long)this._rLen * (long)this._cLen : estnnz;
        return ReaderTextCSVParallel.createOutputMatrixBlock(this._rLen, this._cLen, this._rLen, estnnz2, true, true);
    }

    private class CSVReadSparseNoNanTaskAndFill
    extends CSVReadTask {
        public CSVReadSparseNoNanTaskAndFill(InputSplit split, TextInputFormat informat, MatrixBlock dest, int splitCount) {
            super(split, informat, dest, splitCount);
        }

        @Override
        protected long parse(RecordReader<LongWritable, Text> reader, LongWritable key, Text value) throws IOException {
            SparseBlock sb = this._dest.getSparseBlock();
            long nnz = 0L;
            double cellValue = 0.0;
            while (reader.next((Object)key, (Object)value)) {
                this.col = 0;
                String cellStr = value.toString().trim();
                String[] parts = IOUtilFunctions.split(cellStr, ReaderTextCSVParallel.this._props.getDelim());
                sb.allocate(this.row);
                SparseRow r = sb.get(this.row);
                for (String part : parts) {
                    if (!part.isEmpty() && (cellValue = Double.parseDouble(part)) != 0.0) {
                        r.append(this.col, cellValue);
                        ++nnz;
                    }
                    ++this.col;
                }
                IOUtilFunctions.checkAndRaiseErrorCSVNumColumns(this._split.toString(), cellStr, parts, ReaderTextCSVParallel.this._cLen);
                ++this.row;
            }
            return nnz;
        }
    }

    private class CSVReadSparseNoNanTask
    extends CSVReadTask {
        public CSVReadSparseNoNanTask(InputSplit split, TextInputFormat informat, MatrixBlock dest, int splitCount) {
            super(split, informat, dest, splitCount);
        }

        @Override
        protected long parse(RecordReader<LongWritable, Text> reader, LongWritable key, Text value) throws IOException {
            SparseBlock sb = this._dest.getSparseBlock();
            long nnz = 0L;
            double cellValue = 0.0;
            boolean noFillEmpty = false;
            while (reader.next((Object)key, (Object)value)) {
                this.col = 0;
                String cellStr = value.toString().trim();
                String[] parts = IOUtilFunctions.split(cellStr, ReaderTextCSVParallel.this._props.getDelim());
                sb.allocate(this.row);
                SparseRow r = sb.get(this.row);
                for (String part : parts) {
                    if ((part = part.trim()).isEmpty()) {
                        noFillEmpty |= !ReaderTextCSVParallel.this._props.isFill();
                        cellValue = ReaderTextCSVParallel.this._props.getFillValue();
                    } else {
                        cellValue = Double.parseDouble(part);
                    }
                    if (cellValue != 0.0) {
                        r.append(this.col, cellValue);
                        ++nnz;
                    }
                    ++this.col;
                }
                IOUtilFunctions.checkAndRaiseErrorCSVEmptyField(cellStr, ReaderTextCSVParallel.this._props.isFill(), noFillEmpty);
                IOUtilFunctions.checkAndRaiseErrorCSVNumColumns(this._split.toString(), cellStr, parts, ReaderTextCSVParallel.this._cLen);
                ++this.row;
            }
            return nnz;
        }
    }

    private class CSVReadSparseNanTask
    extends CSVReadTask {
        public CSVReadSparseNanTask(InputSplit split, TextInputFormat informat, MatrixBlock dest, int splitCount) {
            super(split, informat, dest, splitCount);
        }

        @Override
        protected long parse(RecordReader<LongWritable, Text> reader, LongWritable key, Text value) throws IOException {
            boolean noFillEmpty = false;
            double cellValue = 0.0;
            SparseBlock sb = this._dest.getSparseBlock();
            long nnz = 0L;
            while (reader.next((Object)key, (Object)value)) {
                String cellStr = value.toString().trim();
                String[] parts = IOUtilFunctions.split(cellStr, ReaderTextCSVParallel.this._props.getDelim());
                this.col = 0;
                sb.allocate(this.row);
                SparseRow r = sb.get(this.row);
                for (String part : parts) {
                    if ((part = part.trim()).isEmpty()) {
                        noFillEmpty |= !ReaderTextCSVParallel.this._props.isFill();
                        cellValue = ReaderTextCSVParallel.this._props.getFillValue();
                    } else {
                        cellValue = UtilFunctions.parseToDouble(part, ReaderTextCSVParallel.this._props.getNAStrings());
                    }
                    if (cellValue != 0.0) {
                        r.append(this.col, cellValue);
                        ++nnz;
                    }
                    ++this.col;
                }
                IOUtilFunctions.checkAndRaiseErrorCSVEmptyField(cellStr, ReaderTextCSVParallel.this._props.isFill(), noFillEmpty);
                IOUtilFunctions.checkAndRaiseErrorCSVNumColumns(this._split.toString(), cellStr, parts, ReaderTextCSVParallel.this._cLen);
                ++this.row;
            }
            return nnz;
        }
    }

    private class CSVReadDenseNanTask
    extends CSVReadTask {
        public CSVReadDenseNanTask(InputSplit split, TextInputFormat informat, MatrixBlock dest, int splitCount) {
            super(split, informat, dest, splitCount);
        }

        @Override
        protected long parse(RecordReader<LongWritable, Text> reader, LongWritable key, Text value) throws IOException {
            double[] a = this._dest.getDenseBlockValues();
            double cellValue = 0.0;
            boolean noFillEmpty = false;
            int index = this.row * ReaderTextCSVParallel.this._cLen;
            long nnz = 0L;
            while (reader.next((Object)key, (Object)value)) {
                String[] parts;
                String cellStr = value.toString().trim();
                for (String part : parts = IOUtilFunctions.split(cellStr, ReaderTextCSVParallel.this._props.getDelim())) {
                    if ((part = part.trim()).isEmpty()) {
                        noFillEmpty |= !ReaderTextCSVParallel.this._props.isFill();
                        cellValue = ReaderTextCSVParallel.this._props.getFillValue();
                    } else {
                        cellValue = UtilFunctions.parseToDouble(part, ReaderTextCSVParallel.this._props.getNAStrings());
                    }
                    if (cellValue != 0.0) {
                        a[index] = cellValue;
                        ++nnz;
                    }
                    ++index;
                }
                IOUtilFunctions.checkAndRaiseErrorCSVEmptyField(cellStr, ReaderTextCSVParallel.this._props.isFill(), noFillEmpty);
                IOUtilFunctions.checkAndRaiseErrorCSVNumColumns(this._split.toString(), cellStr, parts, ReaderTextCSVParallel.this._cLen);
                ++this.row;
            }
            return nnz;
        }
    }

    private class CSVReadDenseNoNanTask
    extends CSVReadTask {
        public CSVReadDenseNoNanTask(InputSplit split, TextInputFormat informat, MatrixBlock dest, int splitCount) {
            super(split, informat, dest, splitCount);
        }

        @Override
        protected long parse(RecordReader<LongWritable, Text> reader, LongWritable key, Text value) throws IOException {
            double[] a = this._dest.getDenseBlockValues();
            double cellValue = 0.0;
            long nnz = 0L;
            boolean noFillEmpty = false;
            int index = this.row * ReaderTextCSVParallel.this._cLen;
            while (reader.next((Object)key, (Object)value)) {
                String[] parts;
                String cellStr = value.toString().trim();
                for (String part : parts = IOUtilFunctions.split(cellStr, ReaderTextCSVParallel.this._props.getDelim())) {
                    if ((part = part.trim()).isEmpty()) {
                        noFillEmpty |= !ReaderTextCSVParallel.this._props.isFill();
                        cellValue = ReaderTextCSVParallel.this._props.getFillValue();
                    } else {
                        cellValue = Double.parseDouble(part);
                    }
                    if (cellValue != 0.0) {
                        a[index] = cellValue;
                        ++nnz;
                    }
                    ++index;
                }
                IOUtilFunctions.checkAndRaiseErrorCSVEmptyField(cellStr, ReaderTextCSVParallel.this._props.isFill(), noFillEmpty);
                IOUtilFunctions.checkAndRaiseErrorCSVNumColumns(this._split.toString(), cellStr, parts, ReaderTextCSVParallel.this._cLen);
                ++this.row;
            }
            return nnz;
        }
    }

    private abstract class CSVReadTask
    implements Callable<Long> {
        protected final InputSplit _split;
        protected final TextInputFormat _informat;
        protected final MatrixBlock _dest;
        protected final boolean _isFirstSplit;
        protected final int _splitCount;
        protected int row = 0;
        protected int col = 0;

        public CSVReadTask(InputSplit split, TextInputFormat informat, MatrixBlock dest, int splitCount) {
            this._split = split;
            this._informat = informat;
            this._dest = dest;
            this._isFirstSplit = splitCount == 0;
            this._splitCount = splitCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Long call() throws Exception {
            try {
                RecordReader reader = this._informat.getRecordReader(this._split, ReaderTextCSVParallel.this._job, Reporter.NULL);
                LongWritable key = new LongWritable();
                Text value = new Text();
                if (this._isFirstSplit && ReaderTextCSVParallel.this._props.hasHeader()) {
                    reader.next((Object)key, (Object)value);
                }
                this.row = ReaderTextCSVParallel.this._offsets.getOffsetPerSplit(this._splitCount);
                long nnz = 0L;
                try {
                    nnz = this.parse((RecordReader<LongWritable, Text>)reader, key, value);
                    this.verifyRows(value);
                }
                finally {
                    IOUtilFunctions.closeSilently(reader);
                }
                return nnz;
            }
            catch (Exception ex) {
                if (this.row < 0 || this.row + 1 > ReaderTextCSVParallel.this._rLen || this.col < 0 || this.col + 1 > ReaderTextCSVParallel.this._cLen) {
                    String errMsg = "CSV cell [" + (this.row + 1) + "," + (this.col + 1) + "] out of overall matrix range [1:" + ReaderTextCSVParallel.this._rLen + ",1:" + ReaderTextCSVParallel.this._cLen + "]. " + ex.getMessage();
                    throw new IOException(errMsg, ex);
                }
                String errMsg = "Unable to read matrix in text CSV format. " + ex.getMessage();
                throw new IOException(errMsg, ex);
            }
        }

        protected abstract long parse(RecordReader<LongWritable, Text> var1, LongWritable var2, Text var3) throws IOException;

        protected void verifyRows(Text value) throws IOException {
            if (this.row != ReaderTextCSVParallel.this._offsets.getOffsetPerSplit(this._splitCount) + ReaderTextCSVParallel.this._offsets.getLenghtPerSplit(this._splitCount)) {
                throw new IOException("Incorrect number of rows (" + this.row + ") found in delimited file (" + (ReaderTextCSVParallel.this._offsets.getOffsetPerSplit(this._splitCount) + ReaderTextCSVParallel.this._offsets.getLenghtPerSplit(this._splitCount)) + "): " + value);
            }
        }
    }

    private static class SplitOffsetInfos {
        private int[] offsetPerSplit = null;
        private int[] lenghtPerSplit = null;

        public SplitOffsetInfos(int numSplits) {
            this.lenghtPerSplit = new int[numSplits];
            this.offsetPerSplit = new int[numSplits];
        }

        public int getLenghtPerSplit(int split) {
            return this.lenghtPerSplit[split];
        }

        public void setLenghtPerSplit(int split, int r) {
            this.lenghtPerSplit[split] = r;
        }

        public int getOffsetPerSplit(int split) {
            return this.offsetPerSplit[split];
        }

        public void setOffsetPerSplit(int split, int o) {
            this.offsetPerSplit[split] = o;
        }
    }
}

