/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.fed;

import java.util.concurrent.Future;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.controlprogram.federated.FederatedRequest;
import org.apache.sysds.runtime.controlprogram.federated.FederatedResponse;
import org.apache.sysds.runtime.controlprogram.federated.FederationUtils;
import org.apache.sysds.runtime.instructions.cp.AggregateTernaryCPInstruction;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.cp.DoubleObject;
import org.apache.sysds.runtime.instructions.cp.ScalarObject;
import org.apache.sysds.runtime.instructions.fed.FEDInstruction;

public class AggregateTernaryFEDInstruction
extends FEDInstruction {
    public final AggregateTernaryCPInstruction _ins;

    protected AggregateTernaryFEDInstruction(AggregateTernaryCPInstruction ins) {
        super(FEDInstruction.FEDType.AggregateTernary, ins.getOperator(), ins.getOpcode(), ins.getInstructionString());
        this._ins = ins;
    }

    public static AggregateTernaryFEDInstruction parseInstruction(AggregateTernaryCPInstruction ins) {
        return new AggregateTernaryFEDInstruction(ins);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void processInstruction(ExecutionContext ec) {
        MatrixObject mo3;
        MatrixObject mo1 = ec.getMatrixObject(this._ins.input1);
        MatrixObject mo2 = ec.getMatrixObject(this._ins.input2);
        MatrixObject matrixObject = mo3 = this._ins.input3.isLiteral() ? null : ec.getMatrixObject(this._ins.input3);
        if (mo1.isFederated() && mo2.isFederated() && mo1.getFedMapping().isAligned(mo2.getFedMapping(), false) && mo3 == null) {
            FederatedRequest fr1 = mo1.getFedMapping().broadcast(ec.getScalarInput(this._ins.input3));
            FederatedRequest fr2 = FederationUtils.callInstruction(this._ins.getInstructionString(), this._ins.getOutput(), new CPOperand[]{this._ins.input1, this._ins.input2, this._ins.input3}, new long[]{mo1.getFedMapping().getID(), mo2.getFedMapping().getID(), fr1.getID()});
            FederatedRequest fr3 = new FederatedRequest(FederatedRequest.RequestType.GET_VAR, fr2.getID());
            FederatedRequest fr4 = mo2.getFedMapping().cleanup(this.getTID(), fr1.getID(), fr2.getID());
            Future<FederatedResponse>[] tmp = mo1.getFedMapping().execute(this.getTID(), fr1, fr2, fr3, fr4);
            if (!this._ins.output.getDataType().isScalar()) throw new DMLRuntimeException("Not Implemented Federated Ternary Variation");
            double sum = 0.0;
            for (Future<FederatedResponse> fr : tmp) {
                try {
                    sum += ((ScalarObject)fr.get().getData()[0]).getDoubleValue();
                }
                catch (Exception e) {
                    throw new DMLRuntimeException("Federated Get data failed with exception on TernaryFedInstruction", e);
                }
            }
            ec.setScalarOutput(this._ins.output.getName(), new DoubleObject(sum));
            return;
        } else if (mo1.isFederated() && this._ins.input3.isMatrix() && mo3 != null) {
            FederatedRequest[] fr1 = mo1.getFedMapping().broadcastSliced(mo3, false);
            FederatedRequest[] fr2 = mo1.getFedMapping().broadcastSliced(mo2, false);
            FederatedRequest fr3 = FederationUtils.callInstruction(this._ins.getInstructionString(), this._ins.getOutput(), new CPOperand[]{this._ins.input1, this._ins.input2, this._ins.input3}, new long[]{mo1.getFedMapping().getID(), fr2[0].getID(), fr1[0].getID()});
            FederatedRequest fr4 = new FederatedRequest(FederatedRequest.RequestType.GET_VAR, fr3.getID());
            FederatedRequest fr5 = mo2.getFedMapping().cleanup(this.getTID(), fr1[0].getID(), fr2[0].getID());
            Future<FederatedResponse>[] tmp = mo1.getFedMapping().execute(this.getTID(), fr1, new FederatedRequest[]{fr2[0], fr3, fr4, fr5});
            if (!this._ins.output.getDataType().isScalar()) throw new DMLRuntimeException("Not Implemented Federated Ternary Variation");
            double sum = 0.0;
            for (Future<FederatedResponse> fr : tmp) {
                try {
                    sum += ((ScalarObject)fr.get().getData()[0]).getDoubleValue();
                }
                catch (Exception e) {
                    throw new DMLRuntimeException("Federated Get data failed with exception on TernaryFedInstruction", e);
                }
            }
            ec.setScalarOutput(this._ins.output.getName(), new DoubleObject(sum));
            return;
        } else {
            if (mo3 != null) throw new DMLRuntimeException("Federated AggregateTernary not supported with the following federated objects: " + mo1.isFederated() + ":" + mo1.getFedMapping() + " " + mo2.isFederated() + ":" + mo2.getFedMapping() + mo3.isFederated() + ":" + mo3.getFedMapping());
            throw new DMLRuntimeException("Federated AggregateTernary not supported with the following federated objects: " + mo1.isFederated() + ":" + mo1.getFedMapping() + " " + mo2.isFederated() + ":" + mo2.getFedMapping());
        }
    }
}

