/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.parfor.opt;

import org.apache.sysds.api.DMLScript;
import org.apache.sysds.common.Types;
import org.apache.sysds.hops.Hop;
import org.apache.sysds.hops.LeftIndexingOp;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.hops.rewrite.HopRewriteUtils;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.parfor.opt.CostEstimator;
import org.apache.sysds.runtime.controlprogram.parfor.opt.OptNode;
import org.apache.sysds.runtime.controlprogram.parfor.opt.OptTreePlanMappingAbstract;
import org.apache.sysds.runtime.controlprogram.parfor.opt.Optimizer;
import org.apache.sysds.runtime.controlprogram.parfor.opt.OptimizerRuleBased;

public class CostEstimatorHops
extends CostEstimator {
    public static final double DEFAULT_MEM_SP = 2.097152E7;
    private OptTreePlanMappingAbstract _map = null;

    public CostEstimatorHops(OptTreePlanMappingAbstract map) {
        this._map = map;
    }

    @Override
    public double getLeafNodeEstimate(CostEstimator.TestMeasure measure, OptNode node) {
        boolean forcedExec;
        if (node.getNodeType() != OptNode.NodeType.HOP) {
            return 0.0;
        }
        if (measure != CostEstimator.TestMeasure.MEMORY_USAGE) {
            throw new DMLRuntimeException("Testmeasure " + (Object)((Object)measure) + " not supported by cost model " + (Object)((Object)Optimizer.CostModelType.STATIC_MEM_METRIC) + ".");
        }
        Hop h = this._map.getMappedHop(node.getID());
        double value = h.getMemEstimate();
        value = this._exclVars != null && this._exclType == CostEstimator.ExcludeType.SHARED_READ ? h.getInputOutputSize(this._exclVars) : value;
        double DEFAULT_MEM_REMOTE = OptimizerUtils.isSparkExecutionMode() ? 2.097152E7 : 0.0;
        boolean bl = forcedExec = DMLScript.getGlobalExecMode() == Types.ExecMode.SINGLE_NODE || h.getForcedExecType() != null;
        if (value >= DEFAULT_MEM_REMOTE) {
            if (h.getExecType() == Types.ExecType.SPARK) {
                value = DEFAULT_MEM_REMOTE + h.getSpBroadcastSize();
            } else if (h.getExecType() == Types.ExecType.CP && value >= OptimizerUtils.getLocalMemBudget()) {
                if (!forcedExec && !HopRewriteUtils.hasListInputs(h)) {
                    LOG.warn((Object)("Memory estimate larger than budget but CP exec type (op=" + h.getOpString() + ", name=" + h.getName() + ", memest=" + h.getMemEstimate() + ")."));
                }
                value = DEFAULT_MEM_REMOTE;
            } else if (h.getExecType() == null) {
                value = DEFAULT_MEM_REMOTE;
            }
        }
        if (h.getForcedExecType() == Types.ExecType.SPARK) {
            value = DEFAULT_MEM_REMOTE;
        }
        if (value <= 0.0 && !forcedExec) {
            LOG.warn((Object)("Cannot get memory estimate for hop (op=" + h.getOpString() + ", name=" + h.getName() + ", memest=" + h.getMemEstimate() + ")."));
            value = 1024.0;
        }
        double d = value = this._exclVars != null && this._exclType == CostEstimator.ExcludeType.RESULT_LIX && h instanceof LeftIndexingOp && this._exclVars.contains(h.getName()) ? 0.0 : value;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Memory estimate " + h.getName() + ", " + h.getOpString() + "(" + (Object)((Object)node.getExecType()) + ")=" + OptimizerRuleBased.toMB(value)));
        }
        return value;
    }

    @Override
    public double getLeafNodeEstimate(CostEstimator.TestMeasure measure, OptNode node, Types.ExecType et) {
        if (node.getNodeType() != OptNode.NodeType.HOP) {
            return 0.0;
        }
        if (measure != CostEstimator.TestMeasure.MEMORY_USAGE) {
            throw new DMLRuntimeException("Testmeasure " + (Object)((Object)measure) + " not supported by cost model " + (Object)((Object)Optimizer.CostModelType.STATIC_MEM_METRIC) + ".");
        }
        Hop h = this._map.getMappedHop(node.getID());
        double value = h.getMemEstimate();
        if (et != Types.ExecType.CP) {
            value = 2.097152E7;
        }
        if (value <= 0.0) {
            value = 1024.0;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Memory estimate (forced exec type) " + h.getName() + ", " + h.getOpString() + "(" + (Object)((Object)node.getExecType()) + ")=" + OptimizerRuleBased.toMB(value)));
        }
        return value;
    }
}

