/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.utils;

import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.DMLCompressionException;
import org.apache.sysds.runtime.compress.utils.IntArrayList;

public abstract class ABitmap {
    protected static final Log LOG = LogFactory.getLog((String)ABitmap.class.getName());
    protected final int _numCols;
    protected final int _numRows;
    protected IntArrayList[] _offsetsLists;
    protected final int _numZeros;

    public ABitmap(int numCols, IntArrayList[] offsetsLists, int rows) {
        this._numCols = numCols;
        this._numRows = rows;
        int offsetsTotal = 0;
        if (offsetsLists != null) {
            for (IntArrayList a : offsetsLists) {
                offsetsTotal += a.size();
            }
            this._numZeros = rows - offsetsTotal;
            if (this._numZeros < 0) {
                throw new DMLCompressionException("Error in constructing bitmap");
            }
        } else {
            this._numZeros = rows;
        }
        this._offsetsLists = offsetsLists;
    }

    public int getNumColumns() {
        return this._numCols;
    }

    public int getNumRows() {
        return this._numRows;
    }

    public boolean isEmpty() {
        return this._offsetsLists == null;
    }

    public abstract boolean lossy();

    public abstract int getNumValues();

    public IntArrayList[] getOffsetList() {
        return this._offsetsLists;
    }

    public IntArrayList getOffsetsList(int idx) {
        return this._offsetsLists[idx];
    }

    public long getNumOffsets() {
        long ret = 0L;
        for (IntArrayList offlist : this._offsetsLists) {
            ret += (long)offlist.size();
        }
        return ret;
    }

    public int getNumOffsets(int ix) {
        return this._offsetsLists[ix].size();
    }

    public abstract void sortValuesByFrequency();

    public boolean containsZero() {
        return this._numZeros > 0;
    }

    public int getZeroCounts() {
        return this._numZeros;
    }

    public abstract int getNumNonZerosInOffset(int var1);

    public abstract BitmapType getType();

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("  zeros:  " + this._numZeros);
        sb.append("  columns:" + this._numCols);
        sb.append("\nOffsets:" + Arrays.toString(this._offsetsLists));
        return sb.toString();
    }

    public static enum BitmapType {
        Lossy,
        Full;

    }
}

