/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.federated;

import java.util.Arrays;
import org.apache.sysds.runtime.util.IndexRange;

public class FederatedRange
implements Comparable<FederatedRange> {
    private long[] _beginDims;
    private long[] _endDims;

    public FederatedRange(long[] beginDims, long[] endDims) {
        this._beginDims = beginDims;
        this._endDims = endDims;
    }

    public FederatedRange(FederatedRange other) {
        this((long[])other._beginDims.clone(), (long[])other._endDims.clone());
    }

    public FederatedRange(FederatedRange other, long clen) {
        this((long[])other._beginDims.clone(), (long[])other._endDims.clone());
        this._endDims[1] = clen;
    }

    public void setBeginDim(int dim, long value) {
        this._beginDims[dim] = value;
    }

    public void setEndDim(int dim, long value) {
        this._endDims[dim] = value;
    }

    public long[] getBeginDims() {
        return this._beginDims;
    }

    public long[] getEndDims() {
        return this._endDims;
    }

    public int[] getBeginDimsInt() {
        return Arrays.stream(this._beginDims).mapToInt(i -> (int)i).toArray();
    }

    public int[] getEndDimsInt() {
        return Arrays.stream(this._endDims).mapToInt(i -> (int)i).toArray();
    }

    public long getSize() {
        long size = 1L;
        for (int i = 0; i < this._beginDims.length; ++i) {
            size *= this.getSize(i);
        }
        return size;
    }

    public long getSize(int dim) {
        return this._endDims[dim] - this._beginDims[dim];
    }

    @Override
    public int compareTo(FederatedRange o) {
        for (int i = 0; i < this._beginDims.length; ++i) {
            if (this._beginDims[i] < o._beginDims[i]) {
                return -1;
            }
            if (this._beginDims[i] <= o._beginDims[i]) continue;
            return 1;
        }
        return 0;
    }

    public String toString() {
        return Arrays.toString(this._beginDims) + " - " + Arrays.toString(this._endDims);
    }

    public FederatedRange shift(long rshift, long cshift) {
        this._beginDims[0] = this._beginDims[0] + rshift;
        this._endDims[0] = this._endDims[0] + rshift;
        this._beginDims[1] = this._beginDims[1] + cshift;
        this._endDims[1] = this._endDims[1] + cshift;
        return this;
    }

    public FederatedRange transpose() {
        long tmpBeg = this._beginDims[0];
        long tmpEnd = this._endDims[0];
        this._beginDims[0] = this._beginDims[1];
        this._endDims[0] = this._endDims[1];
        this._beginDims[1] = tmpBeg;
        this._endDims[1] = tmpEnd;
        return this;
    }

    public IndexRange asIndexRange() {
        return new IndexRange(this._beginDims[0], this._endDims[0], this._beginDims[1], this._endDims[1]);
    }
}

