/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.cp;

import java.util.ArrayList;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.cp.CPInstruction;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.cp.ComputationCPInstruction;
import org.apache.sysml.runtime.matrix.data.LibCommonsMath;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.operators.Operator;

public class MultiReturnBuiltinCPInstruction
extends ComputationCPInstruction {
    protected ArrayList<CPOperand> _outputs;

    private MultiReturnBuiltinCPInstruction(Operator op, CPOperand input1, ArrayList<CPOperand> outputs, String opcode, String istr) {
        super(CPInstruction.CPType.MultiReturnBuiltin, op, input1, null, outputs.get(0), opcode, istr);
        this._outputs = outputs;
    }

    public CPOperand getOutput(int i) {
        return this._outputs.get(i);
    }

    public static MultiReturnBuiltinCPInstruction parseInstruction(String str) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        ArrayList<CPOperand> outputs = new ArrayList<CPOperand>();
        String opcode = parts[0];
        if (opcode.equalsIgnoreCase("qr")) {
            CPOperand in1 = new CPOperand(parts[1]);
            outputs.add(new CPOperand(parts[2], Expression.ValueType.DOUBLE, Expression.DataType.MATRIX));
            outputs.add(new CPOperand(parts[3], Expression.ValueType.DOUBLE, Expression.DataType.MATRIX));
            return new MultiReturnBuiltinCPInstruction(null, in1, outputs, opcode, str);
        }
        if (opcode.equalsIgnoreCase("lu")) {
            CPOperand in1 = new CPOperand(parts[1]);
            outputs.add(new CPOperand(parts[2], Expression.ValueType.DOUBLE, Expression.DataType.MATRIX));
            outputs.add(new CPOperand(parts[3], Expression.ValueType.DOUBLE, Expression.DataType.MATRIX));
            outputs.add(new CPOperand(parts[4], Expression.ValueType.DOUBLE, Expression.DataType.MATRIX));
            return new MultiReturnBuiltinCPInstruction(null, in1, outputs, opcode, str);
        }
        if (opcode.equalsIgnoreCase("eigen")) {
            CPOperand in1 = new CPOperand(parts[1]);
            outputs.add(new CPOperand(parts[2], Expression.ValueType.DOUBLE, Expression.DataType.MATRIX));
            outputs.add(new CPOperand(parts[3], Expression.ValueType.DOUBLE, Expression.DataType.MATRIX));
            return new MultiReturnBuiltinCPInstruction(null, in1, outputs, opcode, str);
        }
        if (opcode.equalsIgnoreCase("svd")) {
            CPOperand in1 = new CPOperand(parts[1]);
            outputs.add(new CPOperand(parts[2], Expression.ValueType.DOUBLE, Expression.DataType.MATRIX));
            outputs.add(new CPOperand(parts[3], Expression.ValueType.DOUBLE, Expression.DataType.MATRIX));
            outputs.add(new CPOperand(parts[4], Expression.ValueType.DOUBLE, Expression.DataType.MATRIX));
            return new MultiReturnBuiltinCPInstruction(null, in1, outputs, opcode, str);
        }
        throw new DMLRuntimeException("Invalid opcode in MultiReturnBuiltin instruction: " + opcode);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        if (!LibCommonsMath.isSupportedMultiReturnOperation(this.getOpcode())) {
            throw new DMLRuntimeException("Invalid opcode in MultiReturnBuiltin instruction: " + this.getOpcode());
        }
        MatrixBlock in = ec.getMatrixInput(this.input1.getName());
        MatrixBlock[] out = LibCommonsMath.multiReturnOperations(in, this.getOpcode());
        ec.releaseMatrixInput(this.input1.getName(), this.getExtendedOpcode());
        for (int i = 0; i < this._outputs.size(); ++i) {
            ec.setMatrixOutput(this._outputs.get(i).getName(), out[i], this.getExtendedOpcode());
        }
    }
}

