/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.lops;

import org.apache.sysml.lops.Lop;
import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.lops.LopsException;
import org.apache.sysml.lops.compile.JobType;
import org.apache.sysml.parser.Expression;

public class Nary
extends Lop {
    private OperationType operationType;

    public Nary(OperationType operationType, Expression.DataType dt, Expression.ValueType vt, Lop[] inputLops, LopProperties.ExecType et) {
        super(Lop.Type.Nary, dt, vt);
        this.operationType = operationType;
        for (Lop inputLop : inputLops) {
            this.addInput(inputLop);
            inputLop.addOutput(this);
        }
        if (et != LopProperties.ExecType.CP && et != LopProperties.ExecType.SPARK) {
            throw new LopsException("Unsupported exec type for nary lop:" + et.name());
        }
        this.lps.addCompatibility(JobType.INVALID);
        this.lps.setProperties(this.inputs, et, LopProperties.ExecLocation.ControlProgram, false, false, false);
    }

    @Override
    public String toString() {
        return "Operation Type: " + (Object)((Object)this.operationType);
    }

    public OperationType getOperationType() {
        return this.operationType;
    }

    @Override
    public String getInstructions(String[] inputs, String output) {
        String opString = this.getOpcode();
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        sb.append(opString);
        sb.append("\u00b0");
        for (int i = 0; i < inputs.length; ++i) {
            sb.append(this.getInputs().get(i).prepInputOperand(inputs[i]));
            sb.append("\u00b0");
        }
        sb.append(this.prepOutputOperand(output));
        return sb.toString();
    }

    private String getOpcode() {
        switch (this.operationType) {
            case PRINTF: 
            case CBIND: 
            case RBIND: 
            case EVAL: 
            case LIST: {
                return this.operationType.name().toLowerCase();
            }
            case MIN: 
            case MAX: {
                return "n" + this.operationType.name().toLowerCase();
            }
        }
        throw new UnsupportedOperationException("Nary operation type (" + (Object)((Object)this.operationType) + ") is not defined.");
    }

    public static enum OperationType {
        PRINTF,
        CBIND,
        RBIND,
        MIN,
        MAX,
        EVAL,
        LIST;

    }
}

