/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.text.ParseException;
import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.logging.Log;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapreduce.counters.AbstractCounters;
import org.apache.hadoop.mapreduce.counters.CounterGroupBase;
import org.apache.hadoop.mapreduce.counters.Limits;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormatCounter;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormatCounter;
import org.apache.hadoop.mapreduce.util.CountersStrings;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class Counters
extends AbstractCounters<Counter, Group> {
    public static int MAX_COUNTER_LIMIT = Limits.getCountersMax();
    public static int MAX_GROUP_LIMIT = Limits.getGroupsMax();
    private static HashMap<String, String> depricatedCounterMap = new HashMap();
    private static final GroupFactory groupFactory;

    public Counters() {
        super(groupFactory);
    }

    public Counters(org.apache.hadoop.mapreduce.Counters newCounters) {
        super(newCounters, groupFactory);
    }

    private static void initDepricatedMap() {
        depricatedCounterMap.put(FileInputFormat.Counter.class.getName(), FileInputFormatCounter.class.getName());
        depricatedCounterMap.put(FileOutputFormat.Counter.class.getName(), FileOutputFormatCounter.class.getName());
        depricatedCounterMap.put(FileInputFormat.Counter.class.getName(), FileInputFormatCounter.class.getName());
        depricatedCounterMap.put(FileOutputFormat.Counter.class.getName(), FileOutputFormatCounter.class.getName());
    }

    private static String getNewGroupKey(String oldGroup) {
        if (depricatedCounterMap.containsKey(oldGroup)) {
            return depricatedCounterMap.get(oldGroup);
        }
        return null;
    }

    static Counters downgrade(org.apache.hadoop.mapreduce.Counters newCounters) {
        return new Counters(newCounters);
    }

    @Override
    public synchronized Group getGroup(String groupName) {
        return (Group)super.getGroup(groupName);
    }

    public synchronized Collection<String> getGroupNames() {
        return IteratorUtils.toList(super.getGroupNames().iterator());
    }

    public synchronized String makeCompactString() {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (Group group : this) {
            for (Counter counter : group) {
                if (first) {
                    first = false;
                } else {
                    builder.append(',');
                }
                builder.append(group.getDisplayName());
                builder.append('.');
                builder.append(counter.getDisplayName());
                builder.append(':');
                builder.append(counter.getCounter());
            }
        }
        return builder.toString();
    }

    static long getCounterValue(CounterGroupBase<Counter> group, String counterName) {
        Counter counter = (Counter)group.findCounter(counterName, false);
        if (counter != null) {
            return counter.getValue();
        }
        return 0L;
    }

    @Override
    public synchronized Counter findCounter(String group, String name) {
        if (name.equals("MAP_INPUT_BYTES")) {
            LOG.warn("Counter name MAP_INPUT_BYTES is deprecated. Use FileInputFormatCounters as group name and  BYTES_READ as counter name instead");
            return (Counter)this.findCounter((Enum<?>)FileInputFormatCounter.BYTES_READ);
        }
        String newGroupKey = Counters.getNewGroupKey(group);
        if (newGroupKey != null) {
            group = newGroupKey;
        }
        return this.getGroup(group).getCounterForName(name);
    }

    @Deprecated
    public Counter findCounter(String group, int id, String name) {
        return this.findCounter(group, name);
    }

    public void incrCounter(Enum<?> key, long amount) {
        ((Counter)this.findCounter(key)).increment(amount);
    }

    public void incrCounter(String group, String counter, long amount) {
        this.findCounter(group, counter).increment(amount);
    }

    public synchronized long getCounter(Enum<?> key) {
        return ((Counter)this.findCounter(key)).getValue();
    }

    public synchronized void incrAllCounters(Counters other) {
        for (Group otherGroup : other) {
            Group group = this.getGroup(otherGroup.getName());
            group.setDisplayName(otherGroup.getDisplayName());
            for (Counter otherCounter : otherGroup) {
                Counter counter = group.getCounterForName(otherCounter.getName());
                counter.setDisplayName(otherCounter.getDisplayName());
                counter.increment(otherCounter.getValue());
            }
        }
    }

    public int size() {
        return this.countCounters();
    }

    public static Counters sum(Counters a, Counters b) {
        Counters counters = new Counters();
        counters.incrAllCounters(a);
        counters.incrAllCounters(b);
        return counters;
    }

    public void log(Log log) {
        log.info("Counters: " + this.size());
        for (Group group : this) {
            log.info("  " + group.getDisplayName());
            for (Counter counter : group) {
                log.info("    " + counter.getDisplayName() + "=" + counter.getCounter());
            }
        }
    }

    public String makeEscapedCompactString() {
        return CountersStrings.toEscapedCompactString((AbstractCounters)this);
    }

    public static Counters fromEscapedCompactString(String compactString) throws ParseException {
        return (Counters)CountersStrings.parseEscapedCompactString((String)compactString, (AbstractCounters)new Counters());
    }

    static {
        Counters.initDepricatedMap();
        groupFactory = new GroupFactory();
    }
}

