/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.data;

import java.util.Arrays;
import org.apache.sysml.runtime.functionobjects.Builtin;
import org.apache.sysml.runtime.functionobjects.Equals;
import org.apache.sysml.runtime.functionobjects.GreaterThan;
import org.apache.sysml.runtime.functionobjects.GreaterThanEquals;
import org.apache.sysml.runtime.functionobjects.KahanPlus;
import org.apache.sysml.runtime.functionobjects.LessThan;
import org.apache.sysml.runtime.functionobjects.LessThanEquals;
import org.apache.sysml.runtime.functionobjects.NotEquals;
import org.apache.sysml.runtime.functionobjects.ReduceAll;
import org.apache.sysml.runtime.functionobjects.ReduceCol;
import org.apache.sysml.runtime.functionobjects.ReduceRow;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.data.SparseBlock;
import org.apache.sysml.runtime.matrix.operators.AggregateUnaryOperator;
import org.apache.sysml.runtime.matrix.operators.BinaryOperator;
import org.apache.sysml.runtime.matrix.operators.UnaryOperator;
import org.apache.sysml.runtime.util.DataConverter;
import org.apache.sysml.runtime.util.SortUtils;

public class LibMatrixOuterAgg {
    private LibMatrixOuterAgg() {
    }

    public static boolean isRowIndexMax(AggregateUnaryOperator uaggOp) {
        return uaggOp.aggOp.increOp.fn instanceof Builtin && ((Builtin)uaggOp.aggOp.increOp.fn).bFunc == Builtin.BuiltinCode.MAXINDEX;
    }

    public static boolean isRowIndexMin(AggregateUnaryOperator uaggOp) {
        return uaggOp.aggOp.increOp.fn instanceof Builtin && ((Builtin)uaggOp.aggOp.increOp.fn).bFunc == Builtin.BuiltinCode.MININDEX;
    }

    public static boolean isCompareOperator(BinaryOperator bOp) {
        return bOp.fn instanceof LessThan || bOp.fn instanceof LessThanEquals || bOp.fn instanceof GreaterThan || bOp.fn instanceof GreaterThanEquals || bOp.fn instanceof Equals || bOp.fn instanceof NotEquals;
    }

    public static boolean isSupportedUaggOp(AggregateUnaryOperator uaggOp, BinaryOperator bOp) {
        boolean bSupported = false;
        if (LibMatrixOuterAgg.isCompareOperator(bOp) && (uaggOp.aggOp.increOp.fn instanceof KahanPlus || LibMatrixOuterAgg.isRowIndexMin(uaggOp) || LibMatrixOuterAgg.isRowIndexMax(uaggOp)) && (uaggOp.indexFn instanceof ReduceCol || uaggOp.indexFn instanceof ReduceRow || uaggOp.indexFn instanceof ReduceAll)) {
            bSupported = true;
        }
        return bSupported;
    }

    public static int[] prepareRowIndices(int iCols, double[] vmb, BinaryOperator bOp, AggregateUnaryOperator uaggOp) {
        return LibMatrixOuterAgg.isRowIndexMax(uaggOp) ? LibMatrixOuterAgg.prepareRowIndicesMax(iCols, vmb, bOp) : LibMatrixOuterAgg.prepareRowIndicesMin(iCols, vmb, bOp);
    }

    public static int[] prepareRowIndicesMax(int iCols, double[] vmb, BinaryOperator bOp) {
        int[] vixCumSum = null;
        int[] vix = new int[iCols];
        if (!(bOp.fn instanceof NotEquals)) {
            for (int i = 0; i < iCols; ++i) {
                vix[i] = i;
            }
            SortUtils.sortByValueStable(0, iCols, vmb, vix);
        }
        if (bOp.fn instanceof LessThan || bOp.fn instanceof LessThanEquals || bOp.fn instanceof GreaterThan || bOp.fn instanceof GreaterThanEquals) {
            int i;
            boolean bPrimeCumSum = false;
            if (bOp.fn instanceof LessThan || bOp.fn instanceof LessThanEquals) {
                bPrimeCumSum = true;
            }
            double[] dvix = new double[vix.length];
            if (bPrimeCumSum) {
                for (i = 0; i < vix.length; ++i) {
                    dvix[vix.length - 1 - i] = vix[i];
                }
            } else {
                for (i = 0; i < vix.length; ++i) {
                    dvix[i] = vix[i];
                }
            }
            MatrixBlock mbix = DataConverter.convertToMatrixBlock(dvix, true);
            UnaryOperator u_op = new UnaryOperator(Builtin.getBuiltinFnObject(Builtin.BuiltinCode.CUMMAX));
            MatrixBlock mbResult = (MatrixBlock)mbix.unaryOperations(u_op, new MatrixBlock());
            vixCumSum = DataConverter.convertToIntVector(mbResult);
            if (bPrimeCumSum) {
                for (int i2 = 0; i2 < (vixCumSum.length + 1) / 2; ++i2) {
                    int iTemp = vixCumSum[vixCumSum.length - 1 - i2];
                    vixCumSum[vixCumSum.length - 1 - i2] = vixCumSum[i2];
                    vixCumSum[i2] = iTemp;
                }
            }
            LibMatrixOuterAgg.adjustRowIndicesMax(vixCumSum, vmb, bOp);
        } else if (bOp.fn instanceof Equals || bOp.fn instanceof NotEquals) {
            LibMatrixOuterAgg.adjustRowIndicesMax(vix, vmb, bOp);
            vixCumSum = vix;
        }
        return vixCumSum;
    }

    public static int[] prepareRowIndicesMin(int iCols, double[] vmb, BinaryOperator bOp) {
        int[] vixCumSum = null;
        int[] vix = new int[iCols];
        if (!(bOp.fn instanceof NotEquals) && !(bOp.fn instanceof Equals)) {
            for (int i = 0; i < iCols; ++i) {
                vix[i] = i;
            }
            SortUtils.sortByValueStable(0, iCols, vmb, vix);
        }
        if (bOp.fn instanceof LessThan || bOp.fn instanceof LessThanEquals || bOp.fn instanceof GreaterThan || bOp.fn instanceof GreaterThanEquals) {
            int i;
            boolean bPrimeCumSum = false;
            if (bOp.fn instanceof GreaterThan || bOp.fn instanceof GreaterThanEquals) {
                bPrimeCumSum = true;
            }
            double[] dvix = new double[vix.length];
            if (bPrimeCumSum) {
                for (i = 0; i < vix.length; ++i) {
                    dvix[vix.length - 1 - i] = vix[i];
                }
            } else {
                for (i = 0; i < vix.length; ++i) {
                    dvix[i] = vix[i];
                }
            }
            MatrixBlock mbix = DataConverter.convertToMatrixBlock(dvix, true);
            UnaryOperator u_op = new UnaryOperator(Builtin.getBuiltinFnObject(Builtin.BuiltinCode.CUMMIN));
            MatrixBlock mbResult = (MatrixBlock)mbix.unaryOperations(u_op, new MatrixBlock());
            vixCumSum = DataConverter.convertToIntVector(mbResult);
            if (bPrimeCumSum) {
                for (int i2 = 0; i2 < (vixCumSum.length + 1) / 2; ++i2) {
                    int iTemp = vixCumSum[vixCumSum.length - 1 - i2];
                    vixCumSum[vixCumSum.length - 1 - i2] = vixCumSum[i2];
                    vixCumSum[i2] = iTemp;
                }
            }
            LibMatrixOuterAgg.adjustRowIndicesMin(vixCumSum, vmb, bOp);
        } else if (bOp.fn instanceof Equals || bOp.fn instanceof NotEquals) {
            LibMatrixOuterAgg.adjustRowIndicesMin(vix, vmb, bOp);
            vixCumSum = vix;
        }
        return vixCumSum;
    }

    public static void resetOutputMatrix(MatrixIndexes in1Ix, MatrixBlock in1Val, MatrixIndexes outIx, MatrixBlock outVal, AggregateUnaryOperator uaggOp) {
        if (uaggOp.indexFn instanceof ReduceCol) {
            outIx.setIndexes(in1Ix.getRowIndex(), 1L);
            outVal.reset(in1Val.getNumRows(), 2, false);
        } else if (uaggOp.indexFn instanceof ReduceRow) {
            outIx.setIndexes(1L, in1Ix.getColumnIndex());
            outVal.reset(2, in1Val.getNumColumns(), false);
        } else if (uaggOp.indexFn instanceof ReduceAll) {
            outIx.setIndexes(1L, 1L);
            outVal.reset(1, 2, false);
        }
    }

    public static void aggregateMatrix(MatrixBlock in1Val, MatrixBlock outVal, double[] bv, int[] bvi, BinaryOperator bOp, AggregateUnaryOperator uaggOp) {
        if (LibMatrixOuterAgg.isRowIndexMax(uaggOp)) {
            if (bOp.fn instanceof LessThan) {
                LibMatrixOuterAgg.uaRIMLt(in1Val, outVal, bv, bvi, bOp);
            } else if (bOp.fn instanceof LessThanEquals) {
                LibMatrixOuterAgg.uaRIMLe(in1Val, outVal, bv, bvi, bOp);
            } else if (bOp.fn instanceof GreaterThan) {
                LibMatrixOuterAgg.uaRIMGt(in1Val, outVal, bv, bvi, bOp);
            } else if (bOp.fn instanceof GreaterThanEquals) {
                LibMatrixOuterAgg.uaRIMGe(in1Val, outVal, bv, bvi, bOp);
            } else if (bOp.fn instanceof Equals) {
                LibMatrixOuterAgg.uaRIMEq(in1Val, outVal, bv, bvi, bOp);
            } else if (bOp.fn instanceof NotEquals) {
                LibMatrixOuterAgg.uaRIMNe(in1Val, outVal, bv, bvi, bOp);
            }
        } else if (LibMatrixOuterAgg.isRowIndexMin(uaggOp)) {
            if (bOp.fn instanceof LessThan) {
                LibMatrixOuterAgg.uaRIMinLt(in1Val, outVal, bv, bvi, bOp);
            } else if (bOp.fn instanceof LessThanEquals) {
                LibMatrixOuterAgg.uaRIMinLe(in1Val, outVal, bv, bvi, bOp);
            } else if (bOp.fn instanceof GreaterThan) {
                LibMatrixOuterAgg.uaRIMinGt(in1Val, outVal, bv, bvi, bOp);
            } else if (bOp.fn instanceof GreaterThanEquals) {
                LibMatrixOuterAgg.uaRIMinGe(in1Val, outVal, bv, bvi, bOp);
            } else if (bOp.fn instanceof Equals) {
                LibMatrixOuterAgg.uaRIMinEq(in1Val, outVal, bv, bvi, bOp);
            } else if (bOp.fn instanceof NotEquals) {
                LibMatrixOuterAgg.uaRIMinNe(in1Val, outVal, bv, bvi, bOp);
            }
        } else if (uaggOp.indexFn instanceof ReduceCol) {
            if (bOp.fn instanceof LessThan || bOp.fn instanceof GreaterThanEquals) {
                LibMatrixOuterAgg.uaRowSumLtGe(in1Val, outVal, bv, bOp);
            } else if (bOp.fn instanceof GreaterThan || bOp.fn instanceof LessThanEquals) {
                LibMatrixOuterAgg.uaRowSumGtLe(in1Val, outVal, bv, bOp);
            } else if (bOp.fn instanceof Equals || bOp.fn instanceof NotEquals) {
                LibMatrixOuterAgg.uaRowSumEqNe(in1Val, outVal, bv, bOp);
            }
        } else if (uaggOp.indexFn instanceof ReduceRow) {
            if (bOp.fn instanceof LessThan || bOp.fn instanceof GreaterThanEquals) {
                LibMatrixOuterAgg.uaColSumLtGe(in1Val, outVal, bv, bOp);
            } else if (bOp.fn instanceof GreaterThan || bOp.fn instanceof LessThanEquals) {
                LibMatrixOuterAgg.uaColSumGtLe(in1Val, outVal, bv, bOp);
            } else if (bOp.fn instanceof Equals || bOp.fn instanceof NotEquals) {
                LibMatrixOuterAgg.uaColSumEqNe(in1Val, outVal, bv, bOp);
            }
        } else if (uaggOp.indexFn instanceof ReduceAll) {
            if (bOp.fn instanceof LessThan || bOp.fn instanceof GreaterThanEquals) {
                LibMatrixOuterAgg.uaSumLtGe(in1Val, outVal, bv, bOp);
            } else if (bOp.fn instanceof GreaterThan || bOp.fn instanceof LessThanEquals) {
                LibMatrixOuterAgg.uaSumGtLe(in1Val, outVal, bv, bOp);
            } else if (bOp.fn instanceof Equals || bOp.fn instanceof NotEquals) {
                LibMatrixOuterAgg.uaSumEqNe(in1Val, outVal, bv, bOp);
            }
        }
    }

    private static void uaRowSumLtGe(MatrixBlock in, MatrixBlock out, double[] bv, BinaryOperator bOp) {
        int agg0 = LibMatrixOuterAgg.sumRowSumLtGeColSumGtLe(0.0, bv, bOp);
        int m = in.rlen;
        for (int i = 0; i < m; ++i) {
            double ai = in.quickGetValue(i, 0);
            int cnt = ai == 0.0 ? agg0 : LibMatrixOuterAgg.sumRowSumLtGeColSumGtLe(ai, bv, bOp);
            out.quickSetValue(i, 0, cnt);
        }
    }

    private static void uaRowSumGtLe(MatrixBlock in, MatrixBlock out, double[] bv, BinaryOperator bOp) {
        int agg0 = LibMatrixOuterAgg.sumRowSumGtLeColSumLtGe(0.0, bv, bOp);
        int m = in.rlen;
        for (int i = 0; i < m; ++i) {
            double ai = in.quickGetValue(i, 0);
            int cnt = ai == 0.0 ? agg0 : LibMatrixOuterAgg.sumRowSumGtLeColSumLtGe(ai, bv, bOp);
            out.quickSetValue(i, 0, cnt);
        }
    }

    private static void uaRowSumEqNe(MatrixBlock in, MatrixBlock out, double[] bv, BinaryOperator bOp) {
        int agg0 = LibMatrixOuterAgg.sumEqNe(0.0, bv, bOp);
        int m = in.rlen;
        for (int i = 0; i < m; ++i) {
            double ai = in.quickGetValue(i, 0);
            int cnt = ai == 0.0 ? agg0 : LibMatrixOuterAgg.sumEqNe(ai, bv, bOp);
            out.quickSetValue(i, 0, cnt);
        }
    }

    private static void uaColSumLtGe(MatrixBlock in1Val, MatrixBlock outVal, double[] bv, BinaryOperator bOp) {
        if (in1Val.isInSparseFormat()) {
            LibMatrixOuterAgg.s_uaColSumLtGe(in1Val, outVal, bv, bOp);
        } else {
            LibMatrixOuterAgg.d_uaColSumLtGe(in1Val, outVal, bv, bOp);
        }
    }

    private static void uaColSumGtLe(MatrixBlock in1Val, MatrixBlock outVal, double[] bv, BinaryOperator bOp) {
        if (in1Val.isInSparseFormat()) {
            LibMatrixOuterAgg.s_uaColSumGtLe(in1Val, outVal, bv, bOp);
        } else {
            LibMatrixOuterAgg.d_uaColSumGtLe(in1Val, outVal, bv, bOp);
        }
    }

    private static void uaColSumEqNe(MatrixBlock in1Val, MatrixBlock outVal, double[] bv, BinaryOperator bOp) {
        if (in1Val.isInSparseFormat()) {
            LibMatrixOuterAgg.s_uaColSumEqNe(in1Val, outVal, bv, bOp);
        } else {
            LibMatrixOuterAgg.d_uaColSumEqNe(in1Val, outVal, bv, bOp);
        }
    }

    private static void uaSumLtGe(MatrixBlock in, MatrixBlock out, double[] bv, BinaryOperator bOp) {
        int agg0 = LibMatrixOuterAgg.sumRowSumLtGeColSumGtLe(0.0, bv, bOp);
        int m = in.rlen;
        for (int i = 0; i < m; ++i) {
            double ai = in.quickGetValue(i, 0);
            int cnt = ai == 0.0 ? agg0 : LibMatrixOuterAgg.sumRowSumLtGeColSumGtLe(ai, bv, bOp);
            out.quickSetValue(0, 0, cnt += (int)out.quickGetValue(0, 0));
        }
    }

    private static void uaSumGtLe(MatrixBlock in, MatrixBlock out, double[] bv, BinaryOperator bOp) {
        int agg0 = LibMatrixOuterAgg.sumRowSumGtLeColSumLtGe(0.0, bv, bOp);
        int m = in.rlen;
        for (int i = 0; i < m; ++i) {
            double ai = in.quickGetValue(i, 0);
            int cnt = ai == 0.0 ? agg0 : LibMatrixOuterAgg.sumRowSumGtLeColSumLtGe(ai, bv, bOp);
            out.quickSetValue(0, 0, cnt += (int)out.quickGetValue(0, 0));
        }
    }

    private static void uaSumEqNe(MatrixBlock in, MatrixBlock out, double[] bv, BinaryOperator bOp) {
        int agg0 = LibMatrixOuterAgg.sumEqNe(0.0, bv, bOp);
        int m = in.rlen;
        for (int i = 0; i < m; ++i) {
            double ai = in.quickGetValue(i, 0);
            int cnt = ai == 0.0 ? agg0 : LibMatrixOuterAgg.sumEqNe(ai, bv, bOp);
            out.quickSetValue(0, 0, cnt += (int)out.quickGetValue(0, 0));
        }
    }

    private static void uaRIMLt(MatrixBlock in, MatrixBlock out, double[] bv, int[] bvi, BinaryOperator bOp) {
        int ind0 = LibMatrixOuterAgg.uarimaxLt(0.0, bv, bvi, bOp);
        int m = in.rlen;
        for (int i = 0; i < m; ++i) {
            double ai = in.quickGetValue(i, 0);
            int ind = ai == 0.0 ? ind0 : LibMatrixOuterAgg.uarimaxLt(ai, bv, bvi, bOp);
            out.quickSetValue(i, 0, ind);
        }
    }

    private static void uaRIMLe(MatrixBlock in, MatrixBlock out, double[] bv, int[] bvi, BinaryOperator bOp) {
        int ind0 = LibMatrixOuterAgg.uarimaxLe(0.0, bv, bvi, bOp);
        int m = in.rlen;
        for (int i = 0; i < m; ++i) {
            double ai = in.quickGetValue(i, 0);
            int ind = ai == 0.0 ? ind0 : LibMatrixOuterAgg.uarimaxLe(ai, bv, bvi, bOp);
            out.quickSetValue(i, 0, ind);
        }
    }

    private static void uaRIMGt(MatrixBlock in, MatrixBlock out, double[] bv, int[] bvi, BinaryOperator bOp) {
        int ind0 = LibMatrixOuterAgg.uarimaxGt(0.0, bv, bvi, bOp);
        int m = in.rlen;
        for (int i = 0; i < m; ++i) {
            double ai = in.quickGetValue(i, 0);
            int ind = ai == 0.0 ? ind0 : LibMatrixOuterAgg.uarimaxGt(ai, bv, bvi, bOp);
            out.quickSetValue(i, 0, ind);
        }
    }

    private static void uaRIMGe(MatrixBlock in, MatrixBlock out, double[] bv, int[] bvi, BinaryOperator bOp) {
        int ind0 = LibMatrixOuterAgg.uarimaxGe(0.0, bv, bvi, bOp);
        int m = in.rlen;
        for (int i = 0; i < m; ++i) {
            double ai = in.quickGetValue(i, 0);
            int ind = ai == 0.0 ? ind0 : LibMatrixOuterAgg.uarimaxGe(ai, bv, bvi, bOp);
            out.quickSetValue(i, 0, ind);
        }
    }

    private static void uaRIMEq(MatrixBlock in, MatrixBlock out, double[] bv, int[] bvi, BinaryOperator bOp) {
        int ind0 = LibMatrixOuterAgg.uarimaxEq(0.0, bv, bvi, bOp);
        int m = in.rlen;
        for (int i = 0; i < m; ++i) {
            double ai = in.quickGetValue(i, 0);
            int ind = ai == 0.0 ? ind0 : LibMatrixOuterAgg.uarimaxEq(ai, bv, bvi, bOp);
            out.quickSetValue(i, 0, ind);
        }
    }

    private static void uaRIMNe(MatrixBlock in, MatrixBlock out, double[] bv, int[] bvi, BinaryOperator bOp) {
        int ind0 = LibMatrixOuterAgg.uarimaxNe(0.0, bv, bvi, bOp);
        int m = in.rlen;
        for (int i = 0; i < m; ++i) {
            double ai = in.quickGetValue(i, 0);
            int ind = ai == 0.0 ? ind0 : LibMatrixOuterAgg.uarimaxNe(ai, bv, bvi, bOp);
            out.quickSetValue(i, 0, ind);
        }
    }

    private static void uaRIMinLt(MatrixBlock in, MatrixBlock out, double[] bv, int[] bvi, BinaryOperator bOp) {
        int ind0 = LibMatrixOuterAgg.uariminLt(0.0, bv, bvi, bOp);
        int m = in.rlen;
        for (int i = 0; i < m; ++i) {
            double ai = in.quickGetValue(i, 0);
            int ind = ai == 0.0 ? ind0 : LibMatrixOuterAgg.uariminLt(ai, bv, bvi, bOp);
            out.quickSetValue(i, 0, ind);
        }
    }

    private static void uaRIMinLe(MatrixBlock in, MatrixBlock out, double[] bv, int[] bvi, BinaryOperator bOp) {
        int ind0 = LibMatrixOuterAgg.uariminLe(0.0, bv, bvi, bOp);
        int m = in.rlen;
        for (int i = 0; i < m; ++i) {
            double ai = in.quickGetValue(i, 0);
            int ind = ai == 0.0 ? ind0 : LibMatrixOuterAgg.uariminLe(ai, bv, bvi, bOp);
            out.quickSetValue(i, 0, ind);
        }
    }

    private static void uaRIMinGt(MatrixBlock in, MatrixBlock out, double[] bv, int[] bvi, BinaryOperator bOp) {
        int ind0 = LibMatrixOuterAgg.uariminGt(0.0, bv, bvi, bOp);
        int m = in.rlen;
        for (int i = 0; i < m; ++i) {
            double ai = in.quickGetValue(i, 0);
            int ind = ai == 0.0 ? ind0 : LibMatrixOuterAgg.uariminGt(ai, bv, bvi, bOp);
            out.quickSetValue(i, 0, ind);
        }
    }

    private static void uaRIMinGe(MatrixBlock in, MatrixBlock out, double[] bv, int[] bvi, BinaryOperator bOp) {
        int ind0 = LibMatrixOuterAgg.uariminGe(0.0, bv, bvi, bOp);
        int m = in.rlen;
        for (int i = 0; i < m; ++i) {
            double ai = in.quickGetValue(i, 0);
            int ind = ai == 0.0 ? ind0 : LibMatrixOuterAgg.uariminGe(ai, bv, bvi, bOp);
            out.quickSetValue(i, 0, ind);
        }
    }

    private static void uaRIMinEq(MatrixBlock in, MatrixBlock out, double[] bv, int[] bvi, BinaryOperator bOp) {
        int ind0 = LibMatrixOuterAgg.uariminEq(0.0, bv, bvi, bOp);
        int m = in.rlen;
        for (int i = 0; i < m; ++i) {
            double ai = in.quickGetValue(i, 0);
            int ind = ai == 0.0 ? ind0 : LibMatrixOuterAgg.uariminEq(ai, bv, bvi, bOp);
            out.quickSetValue(i, 0, ind);
        }
    }

    private static void uaRIMinNe(MatrixBlock in, MatrixBlock out, double[] bv, int[] bvi, BinaryOperator bOp) {
        int ind0 = LibMatrixOuterAgg.uariminNe(0.0, bv, bvi, bOp);
        int m = in.rlen;
        for (int i = 0; i < m; ++i) {
            double ai = in.quickGetValue(i, 0);
            int ind = ai == 0.0 ? ind0 : LibMatrixOuterAgg.uariminNe(ai, bv, bvi, bOp);
            out.quickSetValue(i, 0, ind);
        }
    }

    private static void d_uaColSumLtGe(MatrixBlock in, MatrixBlock out, double[] bv, BinaryOperator bOp) {
        int agg0 = LibMatrixOuterAgg.sumRowSumGtLeColSumLtGe(0.0, bv, bOp);
        int m = in.clen;
        for (int i = 0; i < m; ++i) {
            double ai = in.quickGetValue(0, i);
            int cnt = ai == 0.0 ? agg0 : LibMatrixOuterAgg.sumRowSumGtLeColSumLtGe(ai, bv, bOp);
            out.quickSetValue(0, i, cnt);
        }
    }

    private static void s_uaColSumLtGe(MatrixBlock in, MatrixBlock out, double[] bv, BinaryOperator bOp) {
        int agg0 = LibMatrixOuterAgg.sumRowSumGtLeColSumLtGe(0.0, bv, bOp);
        out.allocateDenseBlock(true);
        if ((double)agg0 != 0.0) {
            out.getDenseBlock().set(0, 1, 0, out.clen, agg0);
            out.setNonZeros(out.clen);
        }
        if (in.isEmptyBlock(false)) {
            return;
        }
        SparseBlock sblock = in.getSparseBlock();
        for (int j = 0; j < sblock.numRows(); ++j) {
            if (sblock.isEmpty(j)) continue;
            int apos = sblock.pos(j);
            int alen = sblock.size(j);
            int[] aix = sblock.indexes(j);
            double[] avals = sblock.values(j);
            for (int i = apos; i < apos + alen; ++i) {
                int cnt = LibMatrixOuterAgg.sumRowSumGtLeColSumLtGe(avals[i], bv, bOp);
                out.quickSetValue(0, aix[i], cnt);
            }
        }
    }

    private static void d_uaColSumGtLe(MatrixBlock in, MatrixBlock out, double[] bv, BinaryOperator bOp) {
        int agg0 = LibMatrixOuterAgg.sumRowSumLtGeColSumGtLe(0.0, bv, bOp);
        int m = in.clen;
        for (int i = 0; i < m; ++i) {
            double ai = in.quickGetValue(0, i);
            int cnt = ai == 0.0 ? agg0 : LibMatrixOuterAgg.sumRowSumLtGeColSumGtLe(ai, bv, bOp);
            out.quickSetValue(0, i, cnt);
        }
    }

    private static void s_uaColSumGtLe(MatrixBlock in, MatrixBlock out, double[] bv, BinaryOperator bOp) {
        int agg0 = LibMatrixOuterAgg.sumRowSumLtGeColSumGtLe(0.0, bv, bOp);
        out.allocateDenseBlock(true);
        if ((double)agg0 != 0.0) {
            out.getDenseBlock().set(0, 1, 0, out.clen, agg0);
            out.setNonZeros(out.getNumColumns());
        }
        if (in.isEmptyBlock(false)) {
            return;
        }
        SparseBlock sblock = in.getSparseBlock();
        for (int j = 0; j < sblock.numRows(); ++j) {
            if (sblock.isEmpty(j)) continue;
            int apos = sblock.pos(j);
            int alen = sblock.size(j);
            int[] aix = sblock.indexes(j);
            double[] avals = sblock.values(j);
            for (int i = apos; i < apos + alen; ++i) {
                int cnt = LibMatrixOuterAgg.sumRowSumLtGeColSumGtLe(avals[i], bv, bOp);
                out.quickSetValue(0, aix[i], cnt);
            }
        }
    }

    private static void d_uaColSumEqNe(MatrixBlock in, MatrixBlock out, double[] bv, BinaryOperator bOp) {
        int agg0 = LibMatrixOuterAgg.sumEqNe(0.0, bv, bOp);
        int m = in.clen;
        for (int i = 0; i < m; ++i) {
            double ai = in.quickGetValue(0, i);
            int cnt = ai == 0.0 ? agg0 : LibMatrixOuterAgg.sumEqNe(ai, bv, bOp);
            out.quickSetValue(0, i, cnt);
        }
    }

    private static void s_uaColSumEqNe(MatrixBlock in, MatrixBlock out, double[] bv, BinaryOperator bOp) {
        int agg0 = LibMatrixOuterAgg.sumEqNe(0.0, bv, bOp);
        out.allocateDenseBlock(true);
        if ((double)agg0 != 0.0) {
            out.getDenseBlock().set(0, 1, 0, out.clen, agg0);
            out.setNonZeros(out.getNumColumns());
        }
        if (in.isEmptyBlock(false)) {
            return;
        }
        SparseBlock sblock = in.getSparseBlock();
        for (int j = 0; j < sblock.numRows(); ++j) {
            if (sblock.isEmpty(j)) continue;
            int apos = sblock.pos(j);
            int alen = sblock.size(j);
            int[] aix = sblock.indexes(j);
            double[] avals = sblock.values(j);
            for (int i = apos; i < apos + alen; ++i) {
                int cnt = LibMatrixOuterAgg.sumEqNe(avals[i], bv, bOp);
                out.quickSetValue(0, aix[i], cnt);
            }
        }
    }

    private static int sumRowSumGtLeColSumLtGe(double value, double[] bv, BinaryOperator bOp) {
        int ix;
        int cnt = 0;
        if (ix >= 0) {
            for (ix = Arrays.binarySearch(bv, value); ix > 0 && value == bv[ix - 1]; --ix) {
            }
            ++ix;
        }
        cnt = bv.length - Math.abs(ix) + 1;
        if (bOp.fn instanceof LessThan || bOp.fn instanceof GreaterThan) {
            cnt = bv.length - cnt;
        }
        return cnt;
    }

    private static int sumRowSumLtGeColSumGtLe(double value, double[] bv, BinaryOperator bOp) {
        int ix = Arrays.binarySearch(bv, value);
        int cnt = 0;
        if (ix >= 0) {
            while (value == bv[ix++] && ix < bv.length) {
            }
            ix += value == bv[bv.length - 1] ? 1 : 0;
        }
        cnt = bv.length - Math.abs(ix) + 1;
        if (bOp.fn instanceof LessThanEquals || bOp.fn instanceof GreaterThanEquals) {
            cnt = bv.length - cnt;
        }
        return cnt;
    }

    private static int sumEqNe(double value, double[] bv, BinaryOperator bOp) {
        int ix;
        int cnt = 0;
        if (ix >= 0) {
            for (ix = Arrays.binarySearch(bv, value); ix > 0 && value == bv[ix - 1]; --ix) {
            }
            while (ix < bv.length && value == bv[ix]) {
                ++ix;
                ++cnt;
            }
        }
        if (bOp.fn instanceof NotEquals) {
            cnt = bv.length - cnt;
        }
        return cnt;
    }

    private static int uarimaxEq(double value, double[] bv, int[] bvi, BinaryOperator bOp) {
        int ix = Arrays.binarySearch(bv, value);
        int ixMax = bv.length;
        if (ix >= 0) {
            ixMax = bvi[ix] + 1;
        }
        return ixMax;
    }

    private static int uarimaxNe(double value, double[] bv, int[] bvi, BinaryOperator bOp) {
        int ixMax = bv.length;
        if (bv[bv.length - 1] == value) {
            ixMax = bvi[0] + 1;
        }
        return ixMax;
    }

    private static int uarimaxGt(double value, double[] bv, int[] bvi, BinaryOperator bOp) {
        int ixMax = bv.length;
        if (value <= bv[0] || value > bv[bv.length - 1]) {
            return ixMax;
        }
        int ix = Arrays.binarySearch(bv, value);
        ix = Math.abs(ix) - 1;
        ixMax = bvi[ix - 1] + 1;
        return ixMax;
    }

    private static int uarimaxGe(double value, double[] bv, int[] bvi, BinaryOperator bOp) {
        int ixMax = bv.length;
        if (value < bv[0] || value >= bv[bv.length - 1]) {
            return ixMax;
        }
        int ix = Arrays.binarySearch(bv, value);
        if (ix < 0) {
            ix = Math.abs(ix) - 2;
        }
        ixMax = bvi[ix] + 1;
        return ixMax;
    }

    private static int uarimaxLt(double value, double[] bv, int[] bvi, BinaryOperator bOp) {
        int ixMax = bv.length;
        if (value < bv[0] || value >= bv[bv.length - 1]) {
            return ixMax;
        }
        int ix = Arrays.binarySearch(bv, value);
        if (ix < 0) {
            ix = Math.abs(ix) - 2;
        }
        ixMax = bvi[ix] + 1;
        return ixMax;
    }

    private static int uarimaxLe(double value, double[] bv, int[] bvi, BinaryOperator bOp) {
        int ixMax = bv.length;
        if (value <= bv[0] || value > bv[bv.length - 1]) {
            return ixMax;
        }
        int ix = Arrays.binarySearch(bv, value);
        if (ix < 0) {
            ix = Math.abs(ix) - 1;
        }
        ixMax = bvi[ix] + 1;
        return ixMax;
    }

    private static int uariminEq(double value, double[] bv, int[] bvi, BinaryOperator bOp) {
        int ixMin = 1;
        if (value == bv[0]) {
            ixMin = bvi[0] + 1;
        }
        return ixMin;
    }

    private static int uariminNe(double value, double[] bv, int[] bvi, BinaryOperator bOp) {
        int ixMin = 1;
        if (bv[0] != value) {
            ixMin = bvi[0] + 1;
        }
        return ixMin;
    }

    private static int uariminGt(double value, double[] bv, int[] bvi, BinaryOperator bOp) {
        int ixMin = 1;
        if (value <= bv[0] || value > bv[bv.length - 1]) {
            return ixMin;
        }
        int ix = Arrays.binarySearch(bv, value);
        ix = Math.abs(ix) - 1;
        ixMin = bvi[ix] + 1;
        return ixMin;
    }

    private static int uariminGe(double value, double[] bv, int[] bvi, BinaryOperator bOp) {
        int ixMin = 1;
        if (value <= bv[0] || value > bv[bv.length - 1]) {
            return ixMin;
        }
        int ix = Arrays.binarySearch(bv, value);
        if (ix < 0) {
            ix = Math.abs(ix) - 1;
        }
        ixMin = bvi[ix - 1] + 1;
        return ixMin;
    }

    private static int uariminLt(double value, double[] bv, int[] bvi, BinaryOperator bOp) {
        int ixMin = 1;
        if (value < bv[0] || value >= bv[bv.length - 1]) {
            return ixMin;
        }
        int ix = Arrays.binarySearch(bv, value);
        if (ix < 0) {
            ix = Math.abs(ix) - 2;
        }
        ixMin = bvi[ix] + 1;
        return ixMin;
    }

    private static int uariminLe(double value, double[] bv, int[] bvi, BinaryOperator bOp) {
        int ixMin = 1;
        if (value < bv[0] || value > bv[bv.length - 1]) {
            return ixMin;
        }
        int ix = Arrays.binarySearch(bv, value);
        if (ix < 0) {
            ix = Math.abs(ix) - 1;
        }
        ixMin = bvi[ix] + 1;
        return ixMin;
    }

    public static void adjustRowIndicesMax(int[] vix, double[] vmb, BinaryOperator bOp) {
        if (bOp.fn instanceof LessThan) {
            LibMatrixOuterAgg.shiftLeft(vix, vmb);
        } else if (bOp.fn instanceof GreaterThanEquals || bOp.fn instanceof Equals) {
            LibMatrixOuterAgg.setMaxIndexInPartition(vix, vmb);
        } else if (bOp.fn instanceof NotEquals) {
            int i;
            double dLastValue = vmb[vmb.length - 1];
            for (i = vmb.length - 1; i > 0 && dLastValue == vmb[i - 1]; --i) {
            }
            vix[0] = i > 0 ? i - 1 : vix.length - 1;
        }
    }

    public static void adjustRowIndicesMin(int[] vix, double[] vmb, BinaryOperator bOp) {
        if (bOp.fn instanceof GreaterThan) {
            LibMatrixOuterAgg.setMinIndexInPartition(vix, vmb);
        } else if (bOp.fn instanceof GreaterThanEquals) {
            LibMatrixOuterAgg.shiftLeft(vix, vmb);
        } else if (bOp.fn instanceof LessThanEquals) {
            LibMatrixOuterAgg.shiftRight(vix, vmb);
        } else if (bOp.fn instanceof Equals) {
            int i;
            double dFirstValue = vmb[0];
            for (i = 0; i < vmb.length - 1 && dFirstValue == vmb[i + 1]; ++i) {
            }
            vix[0] = i < vmb.length - 1 ? i + 1 : 0;
        } else if (bOp.fn instanceof NotEquals) {
            int i;
            double dFirstValue = vmb[0];
            for (i = 0; i < vmb.length - 1 && dFirstValue == vmb[i + 1]; ++i) {
            }
            vix[0] = i < vmb.length - 1 ? i - 1 : 0;
        }
    }

    public static void shiftRight(int[] vix, double[] vmb) {
        int i = vix.length - 1;
        while (i > 0) {
            int iPrevInd = i;
            double dPrevVal = vmb[iPrevInd];
            while (i >= 0 && dPrevVal == vmb[i]) {
                --i;
            }
            if (i < 0) continue;
            for (int j = i + 1; j <= iPrevInd; ++j) {
                vix[j] = vix[i];
            }
        }
    }

    public static void shiftLeft(int[] vix, double[] vmb) {
        int iCurInd = 0;
        for (int i = 0; i < vix.length; ++i) {
            double dPrevVal = vmb[iCurInd];
            while (i < vix.length && dPrevVal == vmb[i]) {
                ++i;
            }
            if (i >= vix.length) continue;
            for (int j = iCurInd; j < i; ++j) {
                vix[j] = vix[i];
            }
            iCurInd = i;
        }
    }

    public static void setMinIndexInPartition(int[] vix, double[] vmb) {
        int iLastIndex = 0;
        double dLastVal = vix[iLastIndex];
        for (int i = 0; i < vix.length - 1; ++i) {
            while (i < vmb.length - 1 && dLastVal == vmb[i + 1]) {
                ++i;
            }
            for (int j = iLastIndex + 1; j <= i; ++j) {
                vix[j] = vix[iLastIndex];
            }
            if (i >= vix.length - 1) continue;
            iLastIndex = i + 1;
            dLastVal = vmb[i + 1];
        }
    }

    public static void setMaxIndexInPartition(int[] vix, double[] vmb) {
        int iLastIndex = vix.length - 1;
        double dLastVal = vix[iLastIndex];
        int i = vix.length - 1;
        while (i > 0) {
            while (i > 0 && dLastVal == vmb[i]) {
                --i;
            }
            for (int j = i + 1; j < iLastIndex; ++j) {
                vix[j] = vix[iLastIndex];
            }
            if (i <= 0) continue;
            iLastIndex = i;
            dLastVal = vmb[i];
        }
    }
}

