/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.controlprogram;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.sysml.parser.DMLProgram;
import org.apache.sysml.parser.DataIdentifier;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.ExternalFunctionProgramBlock;
import org.apache.sysml.runtime.controlprogram.Program;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.instructions.Instruction;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.matrix.data.InputInfo;
import org.apache.sysml.udf.ExternalFunctionInvocationInstruction;
import org.apache.sysml.udf.PackageFunction;

public class ExternalFunctionProgramBlockCP
extends ExternalFunctionProgramBlock {
    public ExternalFunctionProgramBlockCP(Program prog, ArrayList<DataIdentifier> inputParams, ArrayList<DataIdentifier> outputParams, HashMap<String, String> otherParams, String baseDir) {
        super(prog, inputParams, outputParams, baseDir);
        this._otherParams = new HashMap();
        this._otherParams.putAll(otherParams);
        this.createInstructions();
    }

    @Override
    public void execute(ExecutionContext ec) {
        if (this._inst.size() != 1) {
            throw new DMLRuntimeException("Invalid number of instructions: " + this._inst.size());
        }
        try {
            ((Instruction)this._inst.get(0)).processInstruction(ec);
        }
        catch (Exception e) {
            throw new DMLRuntimeException(this.printBlockErrorLocation() + "Error evaluating external function: " + DMLProgram.constructFunctionKey(this._namespace, this._functionName), e);
        }
        this.checkOutputParameters(ec.getVariables());
    }

    @Override
    protected void createInstructions() {
        this._inst = new ArrayList();
        String className = (String)this._otherParams.get("classname");
        String configFile = (String)this._otherParams.get("configfile");
        if (className == null) {
            throw new RuntimeException(this.printBlockErrorLocation() + "classname" + " not provided!");
        }
        CPOperand[] inputs = this.getOperands(this.getInputParams());
        CPOperand[] outputs = this.getOperands(this.getOutputParams());
        PackageFunction fun = this.createFunctionObject(className, configFile);
        ExternalFunctionInvocationInstruction einst = new ExternalFunctionInvocationInstruction(inputs, outputs, fun, this._baseDir, InputInfo.BinaryBlockInputInfo);
        this.verifyFunctionInputsOutputs(fun, inputs, outputs);
        this._inst.add(einst);
    }

    @Override
    public String printBlockErrorLocation() {
        return "ERROR: Runtime error in external function program block (for CP) generated from external function statement block between lines " + this._beginLine + " and " + this._endLine + " -- ";
    }
}

