/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.utils.conn;

import javax.net.ssl.SSLContext;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.impl.nio.DefaultNHttpServerConnection;
import org.apache.http.nio.reactor.IOSession;
import org.apache.http.nio.reactor.ssl.SSLIOSession;
import org.apache.http.nio.reactor.ssl.SSLMode;
import org.apache.http.nio.reactor.ssl.SSLSetupHandler;
import org.apache.synapse.transport.utils.conn.SynapseNHttpServerConnectionFactory;

public class SynapseNHttpSSLServerConnectionFactory
extends SynapseNHttpServerConnectionFactory {
    private SSLContext sslContext;
    private SSLSetupHandler sslSetupHandler;

    public SynapseNHttpSSLServerConnectionFactory(ConnectionConfig config, SSLContext sslContext, SSLSetupHandler sslSetupHandler) {
        super(config);
        this.sslContext = sslContext;
        this.sslSetupHandler = sslSetupHandler;
    }

    @Override
    public DefaultNHttpServerConnection createConnection(IOSession session) {
        SSLIOSession ssliosession = new SSLIOSession(session, SSLMode.SERVER, this.sslContext, this.sslSetupHandler);
        session.setAttribute("http.session.ssl", (Object)ssliosession);
        return super.createConnection((IOSession)ssliosession);
    }
}

