/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.utils.config;

import java.nio.charset.CodingErrorAction;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.synapse.commons.util.MiscellaneousUtil;

public abstract class HttpTransportConfiguration {
    protected Log log = LogFactory.getLog(this.getClass());
    private Properties props;

    public HttpTransportConfiguration(String fileName) {
        try {
            this.props = MiscellaneousUtil.loadProperties((String)(fileName + ".properties"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected abstract int getThreadsPerReactor();

    public IOReactorConfig getListeningReactorConfig() {
        IOReactorConfig.Builder builder = IOReactorConfig.custom().setIoThreadCount(this.getThreadsPerReactor()).setSoTimeout(this.getIntProperty("http.socket.timeout.listener", this.getIntProperty("http.socket.timeout", 60000)).intValue()).setConnectTimeout(this.getIntProperty("http.connection.timeout", 0).intValue()).setInterestOpQueued(this.getBooleanProperty("http.nio.interest-ops-queueing", false).booleanValue()).setTcpNoDelay(this.getBooleanProperty("http.tcp.nodelay", true).booleanValue());
        if (this.getIntProperty("http.socket.rcv-buffer-size") != null) {
            builder.setRcvBufSize(this.getIntProperty("http.socket.rcv-buffer-size").intValue());
        }
        if (this.getIntProperty("http.socket.snd-buffer-size") != null) {
            builder.setSndBufSize(this.getIntProperty("http.socket.snd-buffer-size").intValue());
        }
        if (this.getIntProperty("http.socket.linger") != null) {
            builder.setSoLinger(this.getIntProperty("http.socket.linger").intValue());
        }
        if (this.getBooleanProperty("http.socket.reuseaddr") != null) {
            builder.setSoReuseAddress(this.getBooleanProperty("http.socket.reuseaddr").booleanValue());
        }
        if (this.getIntProperty("http.nio.select-interval") != null) {
            builder.setSelectInterval((long)this.getIntProperty("http.nio.select-interval").intValue());
        }
        return builder.build();
    }

    public IOReactorConfig getConnectingReactorConfig() {
        IOReactorConfig.Builder builder = IOReactorConfig.custom().setIoThreadCount(this.getThreadsPerReactor()).setSoTimeout(this.getIntProperty("http.socket.timeout.sender", this.getIntProperty("http.socket.timeout", 60000)).intValue()).setConnectTimeout(this.getIntProperty("http.connection.timeout", 0).intValue()).setInterestOpQueued(this.getBooleanProperty("http.nio.interest-ops-queueing", false).booleanValue()).setTcpNoDelay(this.getBooleanProperty("http.tcp.nodelay", true).booleanValue());
        if (this.getIntProperty("http.socket.rcv-buffer-size") != null) {
            builder.setRcvBufSize(this.getIntProperty("http.socket.rcv-buffer-size").intValue());
        }
        if (this.getIntProperty("http.socket.snd-buffer-size") != null) {
            builder.setSndBufSize(this.getIntProperty("http.socket.snd-buffer-size").intValue());
        }
        if (this.getIntProperty("http.socket.linger") != null) {
            builder.setSoLinger(this.getIntProperty("http.socket.linger").intValue());
        }
        if (this.getBooleanProperty("http.socket.reuseaddr") != null) {
            builder.setSoReuseAddress(this.getBooleanProperty("http.socket.reuseaddr").booleanValue());
        }
        if (this.getIntProperty("http.nio.select-interval") != null) {
            builder.setSelectInterval((long)this.getIntProperty("http.nio.select-interval").intValue());
        }
        return builder.build();
    }

    public ConnectionConfig getConnectionConfig() {
        return ConnectionConfig.custom().setBufferSize(this.getIntProperty("http.socket.buffer-size", 8192).intValue()).setMalformedInputAction(this.getMalformedInputActionValue()).setUnmappableInputAction(this.getUnMappableInputActionValue()).build();
    }

    public Integer getIntProperty(String name, Integer def) {
        String val = System.getProperty(name);
        if (val == null) {
            val = this.props.getProperty(name);
        }
        if (val != null) {
            int intVal;
            try {
                intVal = Integer.valueOf(val);
            }
            catch (NumberFormatException e) {
                this.log.warn((Object)("Invalid http tuning property value. " + name + " must be an integer"));
                return def;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Using http tuning parameter : " + name + " = " + val));
            }
            return intVal;
        }
        return def;
    }

    public Integer getIntProperty(String name) {
        return this.getIntProperty(name, null);
    }

    public Boolean getBooleanProperty(String name, Boolean def) {
        String val = System.getProperty(name);
        if (val == null) {
            val = this.props.getProperty(name);
        }
        if (val != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Using http tuning parameter : " + name + " = " + val));
            }
            return Boolean.valueOf(val);
        }
        return def;
    }

    public Boolean getBooleanProperty(String name) {
        return this.getBooleanProperty(name, null);
    }

    public String getStringProperty(String name, String def) {
        String val = System.getProperty(name);
        if (val == null) {
            val = this.props.getProperty(name);
        }
        return val == null ? def : val;
    }

    private CodingErrorAction getMalformedInputActionValue() {
        String val = this.getStringProperty("http.malformed.input.action", "report");
        return this.getCodingErrorAction(val);
    }

    private CodingErrorAction getUnMappableInputActionValue() {
        String val = this.getStringProperty("http.unmappable.input.action", "report");
        return this.getCodingErrorAction(val);
    }

    private CodingErrorAction getCodingErrorAction(String action) {
        if ("report".equals(action)) {
            return CodingErrorAction.REPORT;
        }
        if ("ignore".equals(action)) {
            return CodingErrorAction.IGNORE;
        }
        if ("replace".equals(action)) {
            return CodingErrorAction.REPLACE;
        }
        return CodingErrorAction.REPORT;
    }
}

