/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.nhttp.util;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.zip.GZIPOutputStream;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GzipMessageFormatterDecorator
implements MessageFormatter {
    private static final Log log = LogFactory.getLog(GzipMessageFormatterDecorator.class);
    private MessageFormatter messageFormatter;

    public GzipMessageFormatterDecorator(MessageFormatter messageFormatter) {
        this.messageFormatter = messageFormatter;
    }

    public byte[] getBytes(MessageContext messageContext, OMOutputFormat format) throws AxisFault {
        return this.messageFormatter.getBytes(messageContext, format);
    }

    public void writeTo(MessageContext messageContext, OMOutputFormat format, OutputStream outputStream, boolean preserve) throws AxisFault {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Serialize message in to a GZIP stream");
            }
            GZIPOutputStream out = new GZIPOutputStream(outputStream);
            this.messageFormatter.writeTo(messageContext, format, (OutputStream)out, preserve);
            try {
                ((OutputStream)out).flush();
                ((OutputStream)out).close();
            }
            catch (IOException e) {
                this.handleException("Error closing message stream", e);
            }
        }
        catch (IOException e) {
            this.handleException("Error getting GZIP output stream", e);
        }
    }

    public String getContentType(MessageContext messageContext, OMOutputFormat format, String soapAction) {
        return this.messageFormatter.getContentType(messageContext, format, soapAction);
    }

    public URL getTargetAddress(MessageContext messageContext, OMOutputFormat format, URL targetURL) throws AxisFault {
        return this.messageFormatter.getTargetAddress(messageContext, format, targetURL);
    }

    public String formatSOAPAction(MessageContext messageContext, OMOutputFormat format, String soapAction) {
        return this.messageFormatter.formatSOAPAction(messageContext, format, soapAction);
    }

    private void handleException(String msg, Exception e) throws AxisFault {
        log.error((Object)msg, (Throwable)e);
        throw new AxisFault(msg, (Throwable)e);
    }
}

