/*
 * Decompiled with CFR 0.152.
 */
package com.sun.script.xslt;

import com.sun.script.xslt.XSLTScriptEngineFactory;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class XSLTScriptEngine
extends AbstractScriptEngine
implements Compilable {
    public static final String SOURCE = "com.sun.script.xslt.source";
    public static final String RESULT = "com.sun.script.xslt.result";
    public static final String URI_RESOLVER = "com.sun.script.xslt.URIResolver";
    public static final String SYSTEM_ID = "com.sun.script.xslt.systemId";
    private ScriptEngineFactory factory;

    public CompiledScript compile(String script) throws ScriptException {
        return this.compile(new StringReader(script));
    }

    public CompiledScript compile(Reader reader) throws ScriptException {
        Templates templates = this.compileTransform(reader, this.context);
        return new XSLTCompiledScript(templates);
    }

    public Object eval(String str, ScriptContext ctx) throws ScriptException {
        return this.eval((Reader)new StringReader(str), ctx);
    }

    public Object eval(Reader reader, ScriptContext ctx) throws ScriptException {
        return this.evalTransform(reader, ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScriptEngineFactory getFactory() {
        XSLTScriptEngine xSLTScriptEngine = this;
        synchronized (xSLTScriptEngine) {
            if (this.factory == null) {
                this.factory = new XSLTScriptEngineFactory();
            }
        }
        return this.factory;
    }

    public Bindings createBindings() {
        return new SimpleBindings();
    }

    void setFactory(ScriptEngineFactory factory) {
        this.factory = factory;
    }

    private Templates compileTransform(Reader reader, ScriptContext ctx) throws ScriptException {
        try {
            ctx.setAttribute("context", ctx, 100);
            ctx.setAttribute("engine", this, 100);
            TransformerFactory transFactory = TransformerFactory.newInstance();
            transFactory.setErrorListener(new ContextErrorListener(ctx));
            transFactory.setURIResolver(XSLTScriptEngine.getURIResolver(ctx));
            return transFactory.newTemplates(new StreamSource(reader));
        }
        catch (Exception exp) {
            throw new ScriptException(exp);
        }
    }

    private Object evalTransform(Reader reader, ScriptContext ctx) throws ScriptException {
        Transformer trans;
        try {
            ctx.setAttribute("context", ctx, 100);
            ctx.setAttribute("engine", this, 100);
            TransformerFactory transFactory = TransformerFactory.newInstance();
            transFactory.setErrorListener(new ContextErrorListener(ctx));
            transFactory.setURIResolver(XSLTScriptEngine.getURIResolver(ctx));
            trans = transFactory.newTransformer(new StreamSource(reader));
        }
        catch (Exception exp) {
            throw new ScriptException(exp);
        }
        return this.evalTransform(trans, ctx);
    }

    private Object evalTransform(Transformer transformer, ScriptContext ctx) throws ScriptException {
        try {
            transformer.clearParameters();
            transformer.setParameter("context", ctx);
            transformer.setErrorListener(new ContextErrorListener(ctx));
            transformer.setURIResolver(XSLTScriptEngine.getURIResolver(ctx));
            transformer.transform(XSLTScriptEngine.getSource(ctx), XSLTScriptEngine.getResult(ctx));
            return null;
        }
        catch (Exception exp) {
            throw new ScriptException(exp);
        }
    }

    private static URIResolver getURIResolver(ScriptContext ctx) {
        Object uriResolver = ctx.getAttribute(URI_RESOLVER);
        if (uriResolver instanceof URIResolver) {
            return (URIResolver)uriResolver;
        }
        return new URIResolver(){

            public Source resolve(String href, String base) throws TransformerException {
                try {
                    URL url = new URL(href);
                    URLConnection conn = url.openConnection();
                    return new StreamSource(conn.getInputStream());
                }
                catch (Exception exp) {
                    try {
                        URL context = new URL(base);
                        URL url = new URL(context, href);
                        URLConnection conn = url.openConnection();
                        return new StreamSource(conn.getInputStream());
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
            }
        };
    }

    private static Source getSource(ScriptContext ctx) throws ScriptException {
        Source src;
        Object obj = ctx.getAttribute(SOURCE);
        if (obj instanceof Source) {
            src = (Source)obj;
        } else if (obj instanceof String) {
            src = new StreamSource((String)obj);
            src.setSystemId((String)obj);
        } else if (obj instanceof File) {
            String sysId = ((File)obj).toURI().toString();
            src = new StreamSource((File)obj);
            src.setSystemId(sysId);
        } else {
            src = obj instanceof InputStream ? new StreamSource((InputStream)obj) : (obj instanceof Reader ? new StreamSource((Reader)obj) : new StreamSource(ctx.getReader()));
        }
        Object systemId = ctx.getAttribute(SYSTEM_ID);
        if (systemId instanceof String) {
            src.setSystemId((String)systemId);
        }
        return src;
    }

    private static Result getResult(ScriptContext ctx) {
        Object result = ctx.getAttribute(RESULT);
        if (result instanceof Result) {
            return (Result)result;
        }
        if (result instanceof String) {
            return new StreamResult((String)result);
        }
        if (result instanceof File) {
            return new StreamResult((File)result);
        }
        if (result instanceof OutputStream) {
            return new StreamResult((OutputStream)result);
        }
        if (result instanceof Writer) {
            return new StreamResult((Writer)result);
        }
        return new StreamResult(ctx.getWriter());
    }

    static Object access$000(XSLTScriptEngine x0, Transformer x1, ScriptContext x2) throws ScriptException {
        return x0.evalTransform(x1, x2);
    }

    private static class ContextErrorListener
    implements ErrorListener {
        private PrintWriter err;

        ContextErrorListener(ScriptContext ctx) {
            this.err = new PrintWriter(ctx.getErrorWriter());
        }

        public void error(TransformerException exception) throws TransformerException {
            this.err.println("ERROR: " + exception.getMessage());
            throw exception;
        }

        public void fatalError(TransformerException exception) throws TransformerException {
            this.err.println("FATAL ERROR: " + exception.getMessage());
            throw exception;
        }

        public void warning(TransformerException exception) throws TransformerException {
            this.err.println("WARNING: " + exception.getMessage());
            throw exception;
        }
    }

    private class XSLTCompiledScript
    extends CompiledScript {
        private Templates templates;

        XSLTCompiledScript(Templates templates) {
            this.templates = templates;
        }

        public ScriptEngine getEngine() {
            return XSLTScriptEngine.this;
        }

        public synchronized Object eval(ScriptContext ctx) throws ScriptException {
            Transformer trans;
            ctx.setAttribute("context", ctx, 100);
            ctx.setAttribute("engine", this, 100);
            try {
                trans = this.templates.newTransformer();
            }
            catch (Exception exp) {
                throw new ScriptException(exp);
            }
            return XSLTScriptEngine.access$000(XSLTScriptEngine.this, trans, ctx);
        }
    }
}

